/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.inventory;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.InventoryListener;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.engine.BaseInventory;
import fr.maxlego08.menu.api.engine.InventoryResult;
import fr.maxlego08.menu.api.engine.ItemButton;
import fr.maxlego08.menu.api.exceptions.InventoryOpenException;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class VInventory
extends ZUtils
implements Cloneable,
BaseInventory {
    protected int id;
    protected ZMenuPlugin plugin;
    protected final Map<Integer, ItemButton> items = new HashMap<Integer, ItemButton>();
    protected final Map<Integer, ItemButton> playerInventoryItems = new HashMap<Integer, ItemButton>();
    protected Player player;
    protected int page;
    protected Object[] args;
    protected Inventory inventory;
    protected String guiName;
    protected boolean disableClick = true;
    protected boolean disablePlayerInventoryClick = true;
    private boolean isClose = false;

    @Override
    public boolean isClose() {
        return this.isClose;
    }

    public int getId() {
        return this.id;
    }

    public VInventory setId(int id) {
        this.id = id;
        return this;
    }

    protected void createInventory(String name) {
        this.createInventory(name, 54);
    }

    protected void createInventory(String name, int size) {
        this.guiName = name;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (String)name);
    }

    protected void createInventory(String name, InventoryType inventoryType) {
        this.guiName = name;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)inventoryType, (String)name);
    }

    protected void createMetaInventory(String name, int size) {
        this.guiName = name;
        this.inventory = this.plugin.getMetaUpdater().createInventory(name, size, (InventoryHolder)this);
    }

    protected void createMetaInventory(String name, InventoryType inventoryType) {
        this.guiName = name;
        this.inventory = this.plugin.getMetaUpdater().createInventory(name, inventoryType, (InventoryHolder)this);
    }

    private void createDefaultInventory() {
        if (this.inventory == null) {
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)"\u00a7cDefault Inventory");
        }
    }

    @Override
    public ItemButton addItem(int slot, ItemStack itemStack) {
        return this.addItem(false, slot, itemStack, true);
    }

    @Override
    public ItemButton addItem(boolean inPlayerInventory, int slot, ItemStack itemStack) {
        return this.addItem(inPlayerInventory, slot, itemStack, true);
    }

    @Override
    public ItemButton addItem(int slot, ItemStack itemStack, boolean enableAntiDupe) {
        return this.addItem(false, slot, itemStack, enableAntiDupe);
    }

    @Override
    public ItemButton addItem(boolean inPlayerInventory, int slot, ItemStack itemStack, boolean enableAntiDupe) {
        this.createDefaultInventory();
        if (itemStack == null) {
            this.plugin.getLogger().severe("Attention, a null itemstack was found in slot " + slot + " ! > " + String.valueOf(this));
            return null;
        }
        if (Config.enableAntiDupe && enableAntiDupe) {
            itemStack = this.plugin.getDupeManager().protectItem(itemStack);
        }
        ItemButton button = new ItemButton(itemStack, slot);
        boolean needCancel = false;
        for (InventoryListener inventoryListener : this.plugin.getInventoryManager().getInventoryListeners()) {
            if (!inventoryListener.addItem(this, inPlayerInventory, button, enableAntiDupe)) continue;
            needCancel = true;
        }
        if (inPlayerInventory) {
            this.playerInventoryItems.put(slot, button);
            if (!needCancel) {
                this.player.getInventory().setItem(slot, itemStack);
            }
        } else {
            this.items.put(slot, button);
            if (!needCancel) {
                this.inventory.setItem(slot, itemStack);
            }
        }
        return button;
    }

    @Override
    public void removeItem(int slot) {
        this.items.remove(slot);
    }

    @Override
    public void removePlayerItem(int slot) {
        this.playerInventoryItems.remove(slot);
    }

    @Override
    public void clearItem() {
        this.items.clear();
        this.playerInventoryItems.clear();
    }

    @Override
    public Map<Integer, ItemButton> getItems() {
        return this.items;
    }

    @Override
    public Map<Integer, ItemButton> getPlayerInventoryItems() {
        return this.playerInventoryItems;
    }

    @Override
    public boolean isDisableClick() {
        return this.disableClick;
    }

    @Override
    public void setDisableClick(boolean disableClick) {
        this.disableClick = disableClick;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public Inventory getSpigotInventory() {
        return this.inventory;
    }

    @Override
    public String getGuiName() {
        return this.guiName;
    }

    protected InventoryResult preOpenInventory(ZMenuPlugin main, Player player, int page, Object ... args) throws InventoryOpenException {
        this.page = page;
        this.args = args;
        this.player = player;
        this.plugin = main;
        return this.openInventory(main, player, page, args);
    }

    public abstract InventoryResult openInventory(ZMenuPlugin var1, Player var2, int var3, Object ... var4) throws InventoryOpenException;

    protected void onPreClose(InventoryCloseEvent event, ZMenuPlugin plugin, Player player) {
        this.isClose = true;
        this.onClose(event, plugin, player);
    }

    protected void onClose(InventoryCloseEvent event, ZMenuPlugin plugin, Player player) {
    }

    protected void onDrag(InventoryDragEvent event, ZMenuPlugin plugin, Player player) {
    }

    @Override
    public ZMenuPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    protected VInventory clone() {
        try {
            return (VInventory)this.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void postOpen(ZMenuPlugin plugin, Player player, int page, Object[] objects) {
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isDisablePlayerInventoryClick() {
        return this.disablePlayerInventoryClick;
    }

    @Override
    public void setDisablePlayerInventoryClick(boolean disablePlayerInventoryClick) {
        this.disablePlayerInventoryClick = disablePlayerInventoryClick;
    }

    public void onInventoryClick(InventoryClickEvent event, ZMenuPlugin plugin, Player player) {
    }
}

