/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.inventory;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.engine.InventoryResult;
import fr.maxlego08.menu.api.engine.ItemButton;
import fr.maxlego08.menu.api.exceptions.InventoryAlreadyExistException;
import fr.maxlego08.menu.api.exceptions.InventoryOpenException;
import fr.maxlego08.menu.api.players.inventory.InventoriesPlayer;
import fr.maxlego08.menu.api.utils.CompatibilityUtil;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.inventory.VInventory;
import fr.maxlego08.menu.inventory.inventories.InventoryDefault;
import fr.maxlego08.menu.listener.ListenerAdapter;
import fr.maxlego08.menu.zcore.enums.EnumInventory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class VInventoryManager
extends ListenerAdapter {
    private final Map<Integer, VInventory> inventories = new HashMap<Integer, VInventory>();
    private final ZMenuPlugin plugin;
    private final Map<UUID, Long> cooldownClick = new HashMap<UUID, Long>();

    public VInventoryManager(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerInventory(EnumInventory enumInventory, VInventory inventory) {
        if (this.inventories.containsKey(enumInventory.getId())) {
            throw new InventoryAlreadyExistException("Inventory with id " + inventory.getId() + " already exist !");
        }
        this.inventories.put(enumInventory.getId(), inventory);
    }

    public void createInventory(EnumInventory enumInventory, Player player, int page, Object ... objects) {
        this.createInventory(enumInventory.getId(), player, page, objects);
    }

    public void createInventory(int id, Player player, int page, Object ... objects) {
        Optional<VInventory> optional = this.getInventory(id);
        if (optional.isEmpty()) {
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.VINVENTORY_ERROR, "%id%", id);
            return;
        }
        VInventory inventory = optional.get();
        VInventory clonedInventory = inventory.clone();
        if (clonedInventory == null) {
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.VINVENTORY_ERROR, "%id%", id);
            return;
        }
        clonedInventory.setId(id);
        try {
            this.plugin.getInventoryManager().getInventoryListeners().forEach(listener -> listener.onInventoryPreOpen(player, clonedInventory, page, objects));
            InventoryResult result = clonedInventory.preOpenInventory(this.plugin, player, page, objects);
            if (result == InventoryResult.SUCCESS) {
                clonedInventory.postOpen(this.plugin, player, page, objects);
                org.bukkit.inventory.Inventory spigotInventory = clonedInventory.getSpigotInventory();
                player.openInventory(spigotInventory);
                this.plugin.getInventoryManager().getInventoryListeners().forEach(listener -> listener.onInventoryPostOpen(player, clonedInventory));
            } else if (result == InventoryResult.SUCCESS_ASYNC) {
                clonedInventory.postOpen(this.plugin, player, page, objects);
            } else if (result == InventoryResult.ERROR) {
                this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.VINVENTORY_ERROR, "%id%", id);
            }
        }
        catch (InventoryOpenException exception) {
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.VINVENTORY_ERROR, "%id%", id);
            exception.printStackTrace();
        }
    }

    @Override
    protected void onInventoryClick(InventoryClickEvent event, Player player) {
        if (event.getClickedInventory() == null) {
            return;
        }
        InventoryHolder holder = CompatibilityUtil.getTopInventory(player).getHolder();
        if (holder instanceof VInventory) {
            VInventory inventory = (VInventory)holder;
            event.setCancelled(inventory.isDisableClick());
            if (event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
                event.setCancelled(inventory.isDisablePlayerInventoryClick());
                inventory.onInventoryClick(event, this.plugin, player);
                this.handleClick(true, player, inventory, event);
            } else {
                inventory.onInventoryClick(event, this.plugin, player);
                this.handleClick(false, player, inventory, event);
            }
        }
    }

    private void handleClick(boolean inPlayerInventory, Player player, VInventory inventory, InventoryClickEvent event) {
        if (Config.enableCooldownClick && this.cooldownClick.getOrDefault(player.getUniqueId(), 0L) > System.currentTimeMillis()) {
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.CLICK_COOLDOWN, new Object[0]);
            return;
        }
        this.cooldownClick.put(player.getUniqueId(), System.currentTimeMillis() + Config.cooldownClickMilliseconds);
        ItemButton button = (inPlayerInventory ? inventory.getPlayerInventoryItems() : inventory.getItems()).getOrDefault(event.getSlot(), null);
        if (button != null) {
            this.plugin.getInventoryManager().getInventoryListeners().forEach(listener -> listener.onButtonClick(player, button));
            button.onClick(event);
        }
    }

    @Override
    protected void onInventoryClose(InventoryCloseEvent event, Player player) {
        if (player.isDead()) {
            return;
        }
        InventoryHolder holder = CompatibilityUtil.getTopInventory((InventoryEvent)event).getHolder();
        if (holder instanceof VInventory) {
            VInventory inventory = (VInventory)holder;
            this.plugin.getInventoryManager().getInventoryListeners().forEach(listener -> listener.onInventoryClose(player, inventory));
            inventory.onPreClose(event, this.plugin, player);
        }
    }

    @Override
    protected void onInventoryDrag(InventoryDragEvent event, Player player) {
        InventoryHolder holder = CompatibilityUtil.getTopInventory((InventoryEvent)event).getHolder();
        if (holder instanceof VInventory) {
            ((VInventory)holder).onDrag(event, this.plugin, player);
        }
    }

    @Override
    public void onPickUp(EntityPickupItemEvent event, Player player) {
        InventoryDefault inventoryDefault;
        Inventory menu;
        VInventory vInventory;
        InventoryHolder holder = CompatibilityUtil.getTopInventory(player).getHolder();
        if (holder instanceof VInventory && (vInventory = (VInventory)holder) instanceof InventoryDefault && (menu = (inventoryDefault = (InventoryDefault)vInventory).getMenuInventory()) != null && menu.shouldCancelItemPickup()) {
            event.setCancelled(true);
        }
    }

    @Override
    protected void onDeath(PlayerDeathEvent event, Player player) {
        InventoryDefault inventoryDefault;
        Inventory menu;
        VInventory vInventory;
        InventoryHolder holder = CompatibilityUtil.getTopInventory(player).getHolder();
        if (holder instanceof VInventory && (vInventory = (VInventory)holder) instanceof InventoryDefault && (menu = (inventoryDefault = (InventoryDefault)vInventory).getMenuInventory()) != null && menu.cleanInventory()) {
            event.getDrops().clear();
            InventoriesPlayer inventoriesPlayer = this.plugin.getInventoriesPlayer();
            List<ItemStack> savedItems = inventoriesPlayer.getInventory(player.getUniqueId());
            inventoriesPlayer.clearInventorie(player.getUniqueId());
            if (event.getKeepInventory()) {
                player.getInventory().clear();
                for (ItemStack itemStack : savedItems) {
                    if (itemStack == null) continue;
                    player.getInventory().addItem(new ItemStack[]{itemStack});
                }
                return;
            }
            event.getDrops().addAll(savedItems);
        }
    }

    private Optional<VInventory> getInventory(int id) {
        return Optional.ofNullable(this.inventories.getOrDefault(id, null));
    }

    public void close() {
        this.close(v -> !v.isClose());
    }

    public void close(Predicate<VInventory> predicate) {
        if (!this.plugin.isEnabled()) {
            Bukkit.getOnlinePlayers().forEach(player -> {
                VInventory vInventory;
                InventoryHolder holder = CompatibilityUtil.getTopInventory(player).getHolder();
                if (holder instanceof VInventory && predicate.test(vInventory = (VInventory)holder) && player.isOnline()) {
                    player.closeInventory();
                }
            });
            return;
        }
        Bukkit.getOnlinePlayers().forEach(player -> this.plugin.getScheduler().runAtEntity((Entity)player, task -> {
            VInventory vInventory;
            InventoryHolder holder = CompatibilityUtil.getTopInventory(player).getHolder();
            if (holder instanceof VInventory && predicate.test(vInventory = (VInventory)holder) && player.isOnline()) {
                player.closeInventory();
            }
        }));
    }

    @Override
    protected void onConnect(PlayerJoinEvent event, Player player) {
        if (player.getName().equals("Maxlego08")) {
            this.plugin.getScheduler().runAtEntityLater((Entity)player, w -> this.message((MenuPlugin)this.plugin, (CommandSender)player, "&aLe serveur utilise &2zMenu v" + this.plugin.getDescription().getVersion(), new Object[0]), 20L);
        }
    }

    @Override
    protected void onQuit(PlayerQuitEvent event, Player player) {
        this.cooldownClick.remove(player.getUniqueId());
    }
}

