/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.inventory.inventories;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.engine.InventoryResult;
import fr.maxlego08.menu.api.engine.ItemButton;
import fr.maxlego08.menu.api.exceptions.InventoryOpenException;
import fr.maxlego08.menu.api.pattern.Pattern;
import fr.maxlego08.menu.api.requirement.RefreshRequirement;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.hooks.folialib.impl.PlatformScheduler;
import fr.maxlego08.menu.hooks.folialib.wrapper.task.WrappedTask;
import fr.maxlego08.menu.inventory.VInventory;
import fr.maxlego08.menu.zcore.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryDefault
extends VInventory
implements InventoryEngine {
    private final Map<Integer, TimerTask> timers = new ConcurrentHashMap<Integer, TimerTask>();
    private Inventory inventory;
    private List<Inventory> oldInventories = new ArrayList<Inventory>();
    private List<Button> buttons = Collections.emptyList();
    private int maxPage = 1;
    private boolean isAsync = false;
    private List<Button> updatedButtons = Collections.emptyList();

    @Override
    public InventoryResult openInventory(ZMenuPlugin main, Player player, int page, Object ... args) throws InventoryOpenException {
        this.inventory = (Inventory)args[0];
        InventoryResult result = this.inventory.openInventory(player, this);
        if (result != InventoryResult.SUCCESS) {
            return result;
        }
        this.oldInventories = this.extractOldInventories(args);
        Collection<Pattern> patterns = this.inventory.getPatterns();
        this.maxPage = Math.max(1, this.inventory.getMaxPage(patterns, player, args));
        ArrayList<Button> computedButtons = new ArrayList<Button>();
        for (Pattern pattern : patterns) {
            computedButtons.addAll(this.inventory.sortPatterns(pattern, page, args));
        }
        computedButtons.addAll(this.inventory.sortButtons(page, args));
        this.buttons = computedButtons;
        ArrayList<Button> clickableUpdates = new ArrayList<Button>();
        boolean async = false;
        for (Button button : computedButtons) {
            if (button.updateOnClick()) {
                clickableUpdates.add(button);
            }
            if (async || !button.isOpenAsync()) continue;
            async = true;
        }
        this.updatedButtons = clickableUpdates;
        this.isAsync = async;
        InventoryManager manager = this.plugin.getInventoryManager();
        manager.setPlayerPage((OfflinePlayer)player, page, this.maxPage);
        PlatformScheduler scheduler = this.plugin.getScheduler();
        Consumer<WrappedTask> runnable = w -> {
            ItemStack builtItem;
            Placeholders placeholders = new Placeholders();
            for (Button button : this.buttons) {
                button.onInventoryOpen(player, this, placeholders);
            }
            String inventoryName = this.getMessage(this.inventory.getName(player, this, placeholders), "%page%", page, "%maxPage%", this.maxPage, "%max-page%", this.maxPage);
            Player targetPlayer = this.getTargetPlayer();
            if (this.inventory.getType() == InventoryType.CHEST) {
                super.createMetaInventory(super.papi(placeholders.parse(inventoryName), (OfflinePlayer)targetPlayer, false), this.inventory.size());
            } else {
                super.createMetaInventory(super.papi(placeholders.parse(inventoryName), (OfflinePlayer)targetPlayer, false), this.inventory.getType());
            }
            if (this.inventory.getFillItemStack() != null && (builtItem = this.inventory.getFillItemStack().build(player)) != null) {
                ItemStack[] contents = super.getSpigotInventory().getContents();
                for (int slot = 0; slot < contents.length; ++slot) {
                    this.addItem(slot, builtItem.clone());
                }
            }
            for (Button button : this.buttons) {
                this.buildButton(button);
            }
            if (this.isAsync) {
                scheduler.runAtEntity((Entity)player, w2 -> player.openInventory(this.getSpigotInventory()));
            }
        };
        if (this.isAsync) {
            scheduler.runAsync(runnable);
            return InventoryResult.SUCCESS_ASYNC;
        }
        runnable.accept(null);
        return InventoryResult.SUCCESS;
    }

    @Override
    public void postOpen(ZMenuPlugin plugin, Player player, int page, Object[] objects) {
        this.inventory.postOpenInventory(player, this);
    }

    @Override
    protected void onClose(InventoryCloseEvent event, ZMenuPlugin plugin, Player player) {
        this.inventory.closeInventory(player, this);
        this.buttons.forEach(button -> button.onInventoryClose(player, this));
    }

    @Override
    protected void onDrag(InventoryDragEvent event, ZMenuPlugin plugin, Player player) {
        this.buttons.forEach(button -> button.onDrag(event, player, this));
    }

    @Override
    public void onInventoryClick(InventoryClickEvent event, ZMenuPlugin plugin, Player player) {
        this.buttons.forEach(button -> button.onInventoryClick(event, player, this));
    }

    @Override
    public void buildButton(Button button) {
        if (button == null) {
            return;
        }
        Player targetPlayer = this.getTargetPlayer();
        if (button.hasCustomRender()) {
            button.onRender(targetPlayer, this);
            return;
        }
        if ((button = button.getDisplayButton(this, this.player)) == null) {
            return;
        }
        if (button.hasPermission()) {
            Placeholders placeholders = new Placeholders();
            if (!button.checkPermission(targetPlayer, this, placeholders)) {
                if (button.hasElseButton()) {
                    Button elseButton = button.getElseButton();
                    this.buildButton(elseButton);
                }
            } else {
                this.displayButton(button);
            }
        } else {
            this.displayButton(button);
        }
    }

    @Override
    public void displayButton(Button button) {
        Player targetPlayer = this.getTargetPlayer();
        PlatformScheduler scheduler = this.plugin.getScheduler();
        if (button.hasSpecialRender()) {
            Consumer<WrappedTask> runnable = w -> button.onRender(targetPlayer, this);
            if (this.isAsync) {
                scheduler.runAtEntity((Entity)this.player, runnable);
            } else {
                runnable.accept(null);
            }
        } else {
            Consumer<WrappedTask> runnable = w -> {
                int slot = button.getRealSlot(button.isPlayerInventory() ? 36 : this.inventory.size(), this.page);
                this.displayFinalButton(button, slot);
            };
            if (this.isAsync) {
                scheduler.runAtEntity((Entity)this.player, runnable);
            } else {
                runnable.accept(null);
            }
        }
    }

    @Override
    public void displayFinalButton(Button button, int ... slots) {
        Player targetPlayer = this.getTargetPlayer();
        ItemStack itemStack = button.getCustomItemStack(targetPlayer);
        if (itemStack == null) {
            return;
        }
        for (int slot : slots) {
            boolean needRefresh;
            int maxSlotSize;
            if (slot < 0) {
                Logger.info("slot is negative ! (" + slot + ") Button: " + button.getName() + " in inventory " + this.inventory.getFileName(), Logger.LogType.ERROR);
                continue;
            }
            int n = maxSlotSize = button.isPlayerInventory() ? 36 : this.inventory.size();
            if (slot >= maxSlotSize) {
                Logger.info("slot is out of range ! (" + slot + ") Button: " + button.getName() + " in inventory " + this.inventory.getFileName(), Logger.LogType.ERROR);
                continue;
            }
            ItemButton itemButton = this.addItem(button.isPlayerInventory(), slot, itemStack);
            if (button.isClickable()) {
                itemButton.setClick(event -> {
                    if (event.getClick() == ClickType.DOUBLE_CLICK) {
                        return;
                    }
                    event.setCancelled(true);
                    button.onClick(this.player, (InventoryClickEvent)event, this, slot, new Placeholders());
                    if (button.isRefreshOnClick()) {
                        this.cancel(slot);
                        this.buildButton(button.getMasterParentButton());
                    }
                    this.updatedButtons.forEach(this::buildButton);
                });
                itemButton.setLeftClick(event -> button.onLeftClick(this.player, (InventoryClickEvent)event, this, slot));
                itemButton.setRightClick(event -> button.onRightClick(this.player, (InventoryClickEvent)event, this, slot));
                itemButton.setMiddleClick(event -> button.onMiddleClick(this.player, (InventoryClickEvent)event, this, slot));
            }
            if (!button.hasRefreshRequirement() && !button.isUpdated()) continue;
            RefreshRequirement refreshRequirement = button.hasRefreshRequirement() ? button.getRefreshRequirement() : null;
            boolean bl = needRefresh = refreshRequirement != null && refreshRequirement.needRefresh(this.player, button, this, new Placeholders());
            if (!needRefresh && !button.isUpdated()) continue;
            long interval = refreshRequirement != null ? (long)refreshRequirement.getUpdateInterval() : (long)this.inventory.getUpdateInterval();
            TimerTask timerTask = this.scheduleFix(this.plugin, interval, (task, canRun) -> {
                if (!canRun.booleanValue()) {
                    return;
                }
                if (this.isClose()) {
                    task.cancel();
                    return;
                }
                TimerTask tTask = this.timers.get(slot);
                if (!task.equals(tTask)) {
                    task.cancel();
                    return;
                }
                if (refreshRequirement != null && refreshRequirement.canRefresh(this.player, button, this, new Placeholders())) {
                    this.cancel(slot);
                    this.updateItemMeta(itemStack, button, refreshRequirement, slot);
                } else if (button.isUpdated()) {
                    this.handleUpdatedButton(button, itemStack, slot);
                }
            });
            this.timers.put(slot, timerTask);
        }
    }

    @Override
    public void cancel(int slot) {
        TimerTask task = this.timers.remove(slot);
        if (task != null) {
            task.cancel();
        }
    }

    @Override
    public Inventory getMenuInventory() {
        return this.inventory;
    }

    @Override
    public List<Inventory> getOldInventories() {
        return this.oldInventories == null ? new ArrayList() : this.oldInventories;
    }

    @Override
    public int getMaxPage() {
        return this.maxPage;
    }

    @Override
    public void setMaxPage(int maxPage) {
        this.maxPage = maxPage;
    }

    @Override
    public List<Button> getButtons() {
        return this.buttons;
    }

    private void updateItemMeta(ItemStack itemStack, Button button, RefreshRequirement refreshRequirement, int slot) {
        boolean updated = this.applyMetaUpdates(button, itemStack, refreshRequirement.isRefreshLore(), refreshRequirement.isRefreshName());
        if (!updated) {
            return;
        }
        this.getSpigotInventory().setItem(slot, itemStack);
        if (refreshRequirement.isRefreshButton()) {
            this.buildButton(button.getMasterParentButton());
        }
    }

    private void handleUpdatedButton(Button button, ItemStack itemStack, int slot) {
        Button masterButton = button.getMasterParentButton();
        if (button.isUpdatedMasterButton()) {
            this.cancel(slot);
            this.buildButton(masterButton);
            return;
        }
        if (!this.applyMetaUpdates(button, itemStack, true, true)) {
            return;
        }
        this.getSpigotInventory().setItem(slot, itemStack);
    }

    private boolean applyMetaUpdates(Button button, ItemStack itemStack, boolean refreshLore, boolean refreshName) {
        String displayName;
        List<String> lore;
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        Player targetPlayer = this.getTargetPlayer();
        if (refreshLore && !(lore = button.buildLore(targetPlayer)).isEmpty()) {
            this.plugin.getMetaUpdater().updateLore(itemMeta, this.papi(lore, (OfflinePlayer)targetPlayer, false), button.getItemStack().getLoreType());
        }
        if (refreshName && (displayName = button.buildDisplayName(targetPlayer)) != null) {
            this.plugin.getMetaUpdater().updateDisplayName(itemMeta, this.papi(displayName, (OfflinePlayer)targetPlayer, false), targetPlayer);
        }
        itemStack.setItemMeta(itemMeta);
        return true;
    }

    private List<Inventory> extractOldInventories(Object[] args) {
        Object object;
        if (args.length < 2 || !((object = args[1]) instanceof List)) {
            return new ArrayList<Inventory>();
        }
        List inventories = (List)object;
        List castedInventories = inventories;
        return new ArrayList<Inventory>(castedInventories);
    }

    private Player getTargetPlayer() {
        if (this.inventory == null || this.player == null) {
            return this.player;
        }
        String targetPlaceholder = this.inventory.getTargetPlayerNamePlaceholder();
        if (targetPlaceholder == null || targetPlaceholder.isEmpty()) {
            return this.player;
        }
        String targetName = this.papi(targetPlaceholder, (OfflinePlayer)this.player, false);
        if (targetName == null || targetName.isEmpty()) {
            return this.player;
        }
        Player targetPlayer = Bukkit.getPlayer((String)targetName);
        return targetPlayer != null ? targetPlayer : this.player;
    }
}

