/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader;

import fr.maxlego08.menu.ZCommand;
import fr.maxlego08.menu.ZCommandArgument;
import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.command.Command;
import fr.maxlego08.menu.api.command.CommandArgument;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.utils.Loader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class CommandLoader
implements Loader<Command> {
    private final Plugin plugin;
    private final ZMenuPlugin menuPlugin;

    public CommandLoader(Plugin plugin, ZMenuPlugin menuPlugin) {
        this.plugin = plugin;
        this.menuPlugin = menuPlugin;
    }

    @Override
    public Command load(YamlConfiguration configuration, String path, Object ... args) throws InventoryException {
        File file = (File)args[0];
        String command = configuration.getString(path + "command");
        String permission = configuration.getString(path + "permission");
        String inventory = configuration.getString(path + "inventory");
        String denyMessage = configuration.getString(path + "deny-message", null);
        List aliases = configuration.getStringList(path + "aliases");
        List<Action> commandActions = this.menuPlugin.getButtonManager().loadActions(configuration.getList(path + "actions", new ArrayList()), path, file);
        ArrayList<CommandArgument> arguments = new ArrayList<CommandArgument>();
        List listValues = configuration.getList(path + "arguments", new ArrayList());
        if (this.isListOfMap(listValues)) {
            List mapList = configuration.getMapList(path + "arguments");
            mappedArguments = new ArrayList<ZCommandArgument>(mapList.size());
            for (Map map : mapList) {
                ArrayList<String> autoCompletions;
                String inventoryName;
                String argument = (String)map.get("name");
                String string = inventoryName = map.containsKey("inventory") ? (String)map.get("inventory") : null;
                boolean bl = map.containsKey("isRequired") ? (Boolean)map.get("isRequired") : (isRequired = !map.containsKey("is-required") || (Boolean)map.get("is-required") != false);
                performMainAction = map.containsKey("performMainAction") ? (Boolean)map.get("performMainAction") : !map.containsKey("perform-main-action") || (Boolean)map.get("perform-main-action") != false;
                String argumentType = map.containsKey("type") ? (String)map.get("type") : "STRING";
                ArrayList<Map<String, Object>> elements = map.containsKey("actions") ? (List)map.get("actions") : new ArrayList();
                List<Action> actions = this.menuPlugin.getButtonManager().loadActions(elements, path, file);
                List list = autoCompletions = map.containsKey("auto-completion") ? (List)map.get("auto-completion") : new ArrayList();
                String defaultValue = map.containsKey("defaultValue") ? (String)map.get("defaultValue") : (map.containsKey("default-value") ? (String)map.get("default-value") : null);
                mappedArguments.add(new ZCommandArgument(argumentType, argument, inventoryName, isRequired, performMainAction, actions, autoCompletions, defaultValue));
            }
            arguments = mappedArguments;
        } else {
            List strings = configuration.getStringList(path + "arguments");
            if (!strings.isEmpty()) {
                this.plugin.getLogger().warning("/" + command + " (in file " + file.getPath() + ") command uses the old argument system. Please update your configuration ! (https://docs.zmenu.dev/configurations/commands) Your command will still work properly but it is advisable to update it.");
                mappedArguments = new ArrayList(strings.size());
                for (String arg : strings) {
                    String inventoryName = null;
                    String argument = arg;
                    isRequired = true;
                    performMainAction = true;
                    if (arg.contains(",")) {
                        String[] values = arg.split(",");
                        argument = values[0];
                        if (values.length >= 2) {
                            isRequired = Boolean.parseBoolean(values[1]);
                        }
                        if (values.length == 3) {
                            inventoryName = values[2];
                        }
                    }
                    mappedArguments.add(new ZCommandArgument("STRING", argument, inventoryName, isRequired, performMainAction, new ArrayList<Action>(), new ArrayList<String>(), null));
                }
                arguments = mappedArguments;
            }
        }
        ArrayList<Command> subCommands = new ArrayList<Command>();
        ConfigurationSection configurationSection = configuration.getConfigurationSection(path + "sub-commands");
        if (configurationSection != null) {
            for (String key : configurationSection.getKeys(false)) {
                Command subCommand = this.load(configuration, path + "sub-commands." + key + ".", args);
                if (subCommand == null || subCommand.command() == null) continue;
                subCommands.add(subCommand);
            }
        }
        return new ZCommand(this.plugin, command, aliases, permission, inventory, arguments, commandActions, subCommands, denyMessage, path, file);
    }

    @Override
    public void save(Command object, YamlConfiguration configuration, String path, File file, Object ... objects) {
        configuration.set(path + "command", (Object)object.command());
        configuration.set(path + "permission", (Object)object.permission());
        configuration.set(path + "inventory", (Object)object.inventory());
        configuration.set(path + "aliases", object.aliases());
        configuration.set(path + "arguments", object.arguments());
        configuration.set(path + "deny-message", (Object)object.denyMessage());
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isListOfMap(List<?> list) {
        for (Object item : list) {
            if (item instanceof Map) continue;
            return false;
        }
        return !list.isEmpty();
    }
}

