/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader;

import fr.maxlego08.menu.ZMenuItemStack;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.attribute.Attribute;
import fr.maxlego08.menu.api.attribute.IAttribute;
import fr.maxlego08.menu.api.enchantment.Enchantments;
import fr.maxlego08.menu.api.enchantment.MenuEnchantment;
import fr.maxlego08.menu.api.enums.MenuItemRarity;
import fr.maxlego08.menu.api.exceptions.ItemEnchantException;
import fr.maxlego08.menu.api.itemstack.Banner;
import fr.maxlego08.menu.api.itemstack.Firework;
import fr.maxlego08.menu.api.itemstack.LeatherArmor;
import fr.maxlego08.menu.api.itemstack.Potion;
import fr.maxlego08.menu.api.itemstack.TrimConfiguration;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.api.utils.LoreType;
import fr.maxlego08.menu.api.utils.TrimHelper;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionType;

public class MenuItemStackLoader
extends ZUtils
implements Loader<MenuItemStack> {
    private final InventoryManager manager;

    public MenuItemStackLoader(InventoryManager manager) {
        this.manager = manager;
    }

    @Override
    public MenuItemStack load(YamlConfiguration configuration, String path, Object ... objects) {
        File file = (File)objects[0];
        ZMenuItemStack menuItemStack = new ZMenuItemStack(this.manager, file.getPath(), path);
        menuItemStack.setMaterial(configuration.getString(path + "material", null));
        menuItemStack.setData(configuration.getString(path + "data", "0"));
        menuItemStack.setDurability(configuration.getInt(path + "durability", 0));
        menuItemStack.setAmount(configuration.getString(path + "amount", "1"));
        menuItemStack.setTargetPlayer(configuration.getString(path + "target", null));
        menuItemStack.setUrl(configuration.getString(path + "url", null));
        this.loadLeather(menuItemStack, configuration, path);
        this.loadPotions(menuItemStack, configuration, path);
        this.loadBanner(menuItemStack, configuration, path);
        this.loadFireworks(menuItemStack, configuration, path);
        this.loadLore(menuItemStack, configuration, path);
        menuItemStack.setDisplayName(configuration.getString(path + "name", configuration.getString(path + "display_name", configuration.getString(path + "display-name", null))));
        menuItemStack.setCenterName(configuration.getBoolean(path + "center-name", false));
        menuItemStack.setCenterLore(configuration.getBoolean(path + "center-lore", false));
        try {
            menuItemStack.setLoreType(LoreType.valueOf(configuration.getString(path + "lore-type", LoreType.REPLACE.name()).toUpperCase()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        menuItemStack.setGlowing(configuration.getBoolean(path + "glow"));
        menuItemStack.setModelID(configuration.getString(path + "modelID", configuration.getString(path + "model-id", configuration.getString(path + "modelId", configuration.getString(path + "customModelId", configuration.getString(path + "customModelData", configuration.getString("model_data", configuration.getString("custom-model-id", configuration.getString("custom-model-data", configuration.getString("model-data", "0"))))))))));
        this.loadTranslation(menuItemStack, configuration, path);
        this.loadEnchantements(menuItemStack, configuration, path, file);
        List flagStrings = configuration.getStringList(path + "flags");
        ArrayList<ItemFlag> flags = new ArrayList<ItemFlag>(flagStrings.size());
        for (String flagName : flagStrings) {
            flags.add(this.getFlag(flagName));
        }
        menuItemStack.setFlags(flags);
        this.loadAttributes(menuItemStack, configuration, path);
        if (NmsVersion.getCurrentVersion().isNewItemStackAPI()) {
            this.loadNewItemStacks(menuItemStack, configuration, path, file);
        }
        if (NmsVersion.getCurrentVersion().isNewHeadApi()) {
            this.loadTrims(menuItemStack, configuration, path, file);
        }
        if (NmsVersion.getCurrentVersion().isNewItemModelAPI()) {
            menuItemStack.setItemModel(configuration.getString(path + "item-model"));
        }
        return menuItemStack;
    }

    private void loadLore(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path) {
        Object object;
        List<String> lore = configuration.getStringList(path + "lore");
        if (lore.isEmpty() && (object = configuration.get(path + "lore", null)) instanceof String) {
            String loreString = (String)object;
            lore = Arrays.asList(loreString.split("\n"));
        }
        menuItemStack.setLore(lore);
    }

    private void loadLeather(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path) {
        try {
            Material material = Material.valueOf((String)configuration.getString(path + "material", "").toUpperCase());
            String materialName = material.toString();
            if (materialName.startsWith("LEATHER_")) {
                Color armorColor = this.getColor(configuration, path + "color", Color.fromRGB((int)160, (int)101, (int)64));
                String type = materialName.replace("LEATHER_", "");
                menuItemStack.setLeatherArmor(new LeatherArmor(LeatherArmor.ArmorType.valueOf(type), armorColor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadAttributes(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path) {
        List attributesFromConfig;
        ArrayList<IAttribute> attributeModifiers = new ArrayList<IAttribute>();
        if (configuration.contains(path + "attributes") && (attributesFromConfig = configuration.getList(path + "attributes")) != null) {
            for (Map attributeMap : attributesFromConfig) {
                attributeModifiers.add(Attribute.deserialize(attributeMap));
            }
        }
        menuItemStack.setAttributes(attributeModifiers);
        menuItemStack.setClearDefaultAttributes(configuration.getBoolean(path + "clear-default-attributes", true));
    }

    private void loadEnchantements(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path, File file) {
        Enchantments helperEnchantments = this.manager.getEnchantments();
        List enchants = configuration.getStringList(path + "enchants");
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (String enchantString : enchants) {
            try {
                int level;
                String[] splitEnchant = enchantString.split(",");
                if (splitEnchant.length == 1) {
                    throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString + " for file " + file.getAbsolutePath() + " with path " + path);
                }
                String enchant = splitEnchant[0];
                try {
                    level = Integer.parseInt(splitEnchant[1]);
                }
                catch (NumberFormatException e) {
                    throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString + " for file " + file.getAbsolutePath() + " with path " + path);
                }
                Optional<MenuEnchantment> optional = helperEnchantments.getEnchantments(enchant);
                if (optional.isEmpty()) {
                    throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString + " for file " + file.getAbsolutePath() + " with path " + path);
                }
                enchantments.put(optional.get().enchantment(), level);
            }
            catch (ItemEnchantException e) {
                e.printStackTrace();
            }
        }
        menuItemStack.setEnchantments(enchantments);
    }

    private void loadPotions(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path) {
        if (configuration.contains(path + "potion")) {
            Color potionColor = this.getColor(configuration, path + "color", null);
            PotionType type = PotionType.valueOf((String)configuration.getString(path + "potion", "REGEN").toUpperCase());
            int level = configuration.getInt(path + "level", 1);
            boolean splash = configuration.getBoolean(path + "splash", false);
            boolean extended = configuration.getBoolean(path + "extended", false);
            boolean arrow = configuration.getBoolean(path + "arrow", false);
            Potion potion = new Potion(type, level, splash, extended, arrow);
            potion.setColor(potionColor);
            menuItemStack.setPotion(potion);
        }
    }

    private void loadBanner(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path) {
        if (configuration.contains(path + "banner")) {
            DyeColor dyeColor = DyeColor.valueOf((String)configuration.getString(path + "banner", "WHITE").toUpperCase());
            List stringPattern = configuration.getStringList(path + "patterns");
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String string : stringPattern) {
                String[] split = string.split(":");
                if (split.length != 2) continue;
                patterns.add(new Pattern(DyeColor.valueOf((String)split[0]), PatternType.valueOf((String)split[1])));
            }
            menuItemStack.setBanner(new Banner(dyeColor, patterns));
        }
    }

    private void loadFireworks(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path) {
        ConfigurationSection section;
        if (configuration.contains(path + "firework") && (section = configuration.getConfigurationSection(path + "firework")) != null) {
            boolean isStar = section.getBoolean("star", false);
            FireworkEffect.Builder builder = FireworkEffect.builder();
            builder.flicker(section.getBoolean("flicker"));
            builder.trail(section.getBoolean("trail"));
            builder.with(FireworkEffect.Type.valueOf((String)section.getString("type", "BALL")));
            builder.withColor(this.getColors(section, "colors"));
            builder.withFade(this.getColors(section, "fadeColors"));
            menuItemStack.setFirework(new Firework(isStar, builder.build()));
        }
    }

    private void loadTranslation(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path) {
        this.loadTranslatedName(menuItemStack, configuration, path);
        this.loadTranslatedLore(menuItemStack, configuration, path);
    }

    private void loadTranslatedLore(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path) {
        String loadString;
        HashMap<String, List<String>> translatedLore = new HashMap<String, List<String>>();
        String string = configuration.contains(path + "translatedLore") ? "translatedLore" : (loadString = configuration.contains(path + "translated-lore") ? "translated-lore" : null);
        if (loadString != null) {
            configuration.getMapList(path + loadString).forEach(map -> {
                if (map.containsKey("locale") && map.containsKey("lore")) {
                    String locale = (String)map.get("locale");
                    List name = (List)map.get("lore");
                    translatedLore.put(locale.toLowerCase(), name);
                }
            });
        }
        menuItemStack.setTranslatedLore(translatedLore);
    }

    private void loadTranslatedName(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path) {
        String loadString;
        HashMap<String, String> translatedDisplayName = new HashMap<String, String>();
        String string = configuration.contains(path + "translatedName") ? "translatedName" : (loadString = configuration.contains(path + "translated-name") ? "translated-name" : null);
        if (loadString != null) {
            configuration.getMapList(path + loadString).forEach(map -> {
                if (map.containsKey("locale") && map.containsKey("name")) {
                    String locale = (String)map.get("locale");
                    String name = (String)map.get("name");
                    translatedDisplayName.put(locale.toLowerCase(), name);
                }
            });
        }
        menuItemStack.setTranslatedDisplayName(translatedDisplayName);
    }

    private Boolean getOrNull(Object o) {
        return o instanceof Boolean ? (Boolean)o : null;
    }

    private void loadNewItemStacks(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path, File file) {
        String equippedModel;
        String itemModelString;
        String tooltypestyleString;
        menuItemStack.setMaxStackSize(configuration.getInt(path + "max-stack-size", 0));
        menuItemStack.setMaxDamage(configuration.getInt(path + "max-damage", 0));
        menuItemStack.setDamage(configuration.getInt(path + "damage", 0));
        menuItemStack.setRepairCost(configuration.getInt(path + "repair-cost", 0));
        menuItemStack.setUnbreakableEnabled(this.getOrNull(configuration.get(path + "unbreakable", null)));
        menuItemStack.setUnbreakableShowInTooltip(this.getOrNull(configuration.get(path + "unbreakable-show-in-tooltip", null)));
        menuItemStack.setFireResistant(this.getOrNull(configuration.get(path + "fire-resistant", null)));
        menuItemStack.setHideTooltip(this.getOrNull(configuration.get(path + "hide-tooltip", null)));
        menuItemStack.setHideAdditionalTooltip(this.getOrNull(configuration.get(path + "hide-additional-tooltip", null)));
        menuItemStack.setEnchantmentGlint(this.getOrNull(configuration.get(path + "enchantment-glint", null)));
        menuItemStack.setEnchantmentShowInTooltip(this.getOrNull(configuration.get(path + "enchantment-show-in-tooltip", null)));
        menuItemStack.setAttributeShowInTooltip(this.getOrNull(configuration.get(path + "attribute-show-in-tooltip", null)));
        String rarityString = configuration.getString("item-rarity", null);
        if (rarityString != null) {
            menuItemStack.setItemRarity(MenuItemRarity.valueOf(rarityString.toUpperCase()));
        }
        if ((tooltypestyleString = configuration.getString(path + "tooltip-style", null)) != null) {
            menuItemStack.setToolTipStyle(tooltypestyleString);
        }
        if ((itemModelString = configuration.getString(path + "item-model", null)) != null) {
            menuItemStack.setItemModel(itemModelString);
        }
        if ((equippedModel = configuration.getString(path + "equipped-model", null)) != null) {
            menuItemStack.setEquippedModel(equippedModel);
        }
    }

    private void loadTrims(ZMenuItemStack menuItemStack, YamlConfiguration configuration, String path, File file) {
        boolean enableTrim = configuration.getBoolean(path + "trim.enable", false);
        if (enableTrim) {
            TrimMaterial trimMaterial;
            TrimHelper trimHelper = new TrimHelper();
            TrimPattern trimPattern = trimHelper.getTrimPatterns().get(configuration.getString(path + "trim.pattern", "").toLowerCase());
            if (trimPattern == null) {
                enableTrim = false;
                Bukkit.getLogger().severe("Trim pattern " + configuration.getString(path + "trim.pattern", "") + " was not found for item " + file.getAbsolutePath());
            }
            if ((trimMaterial = trimHelper.getTrimMaterials().get(configuration.getString(path + "trim.material", "").toLowerCase())) == null) {
                enableTrim = false;
                Bukkit.getLogger().severe("Trim material " + configuration.getString(path + "trim.material", "") + " was not found for item " + file.getAbsolutePath());
            }
            menuItemStack.setTrimConfiguration(new TrimConfiguration(enableTrim, trimMaterial, trimPattern));
        }
    }

    private Color getColor(YamlConfiguration configuration, String key, Color def) {
        String[] split = configuration.getString(key, "").split(",");
        try {
            if (split.length == 3) {
                return Color.fromRGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2]));
            }
            if (split.length == 4) {
                return Color.fromARGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2]), (int)Integer.parseInt(split[3]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return def;
    }

    private List<Color> getColors(ConfigurationSection section, String key) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String color : section.getStringList(key)) {
            String[] split = color.split(",");
            if (split.length == 3) {
                colors.add(Color.fromRGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2])));
                continue;
            }
            if (split.length != 4) continue;
            colors.add(Color.fromARGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2]), (int)Integer.parseInt(split[3])));
        }
        return colors;
    }

    @Override
    public void save(MenuItemStack item, YamlConfiguration configuration, String path, File file, Object ... objects) {
        Color leatherArmorColor;
        configuration.set(path + "material", (Object)item.getMaterial());
        if (item.getDisplayName() != null) {
            configuration.set(path + "name", (Object)item.getDisplayName());
        }
        if (!item.getLore().isEmpty()) {
            configuration.set(path + "lore", item.getLore());
        }
        if (item.isGlowing()) {
            configuration.set(path + "glow", (Object)item.isGlowing());
        }
        if (item.getModelID() != null && !item.getModelID().equalsIgnoreCase("0")) {
            configuration.set(path + "model-id", (Object)item.getModelID());
        }
        try {
            if (Integer.parseInt(item.getData()) > 0) {
                configuration.set(path + "data", (Object)item.getData());
            }
        }
        catch (Exception ignored) {
            configuration.set(path + "data", (Object)item.getData());
        }
        if (item.getDurability() > 0) {
            configuration.set(path + "durability", (Object)item.getDurability());
        }
        if (item.getAmount() != null) {
            try {
                int value = Integer.parseInt(item.getAmount());
                if (value > 1) {
                    configuration.set(path + "amount", (Object)value);
                }
            }
            catch (Exception exception) {
                configuration.set(path + "amount", (Object)item.getAmount());
            }
        }
        if (item.getUrl() != null) {
            configuration.set(path + "url", (Object)item.getUrl());
        }
        Potion potion = item.getPotion();
        Firework firework = item.getFirework();
        LeatherArmor leatherArmor = item.getLeatherArmor();
        Banner banner = item.getBanner();
        if (potion != null) {
            Color potionColor = potion.getColor();
            configuration.set(path + "potion", (Object)potion.getType().toString());
            if (potion.getLevel() != 0) {
                configuration.set(path + "level", (Object)potion.getLevel());
            }
            if (potion.isSplash()) {
                configuration.set(path + "splash", (Object)true);
            }
            if (potion.hasExtendedDuration()) {
                configuration.set(path + "extended", (Object)true);
            }
            if (potionColor != null) {
                configuration.set("color", (Object)(potionColor.getAlpha() + "," + potionColor.getRed() + "," + potionColor.getGreen() + "," + potionColor.getBlue()));
            }
        }
        if (firework != null) {
            ConfigurationSection fireworkSection = configuration.createSection(path + "firework");
            FireworkEffect effect = firework.getEffect();
            ArrayList stringColors = new ArrayList();
            effect.getColors().forEach(color -> stringColors.add(color.getAlpha() + "," + color.getRed() + "," + color.getGreen() + "," + color.getBlue()));
            ArrayList stringFadeColors = new ArrayList();
            effect.getColors().forEach(color -> stringFadeColors.add(color.getAlpha() + "," + color.getRed() + "," + color.getGreen() + "," + color.getBlue()));
            fireworkSection.set("star", (Object)firework.isStar());
            fireworkSection.set("flicker", (Object)effect.hasFlicker());
            fireworkSection.set("trail", (Object)effect.hasTrail());
            fireworkSection.set("type", (Object)effect.getType().toString());
            fireworkSection.set("colors", (Object)stringColors);
            fireworkSection.set("fadeColors", stringFadeColors);
        }
        if (leatherArmor != null && (leatherArmorColor = leatherArmor.getColor()) != null) {
            configuration.set("color", (Object)(leatherArmorColor.getAlpha() + "," + leatherArmorColor.getRed() + "," + leatherArmorColor.getGreen() + "," + leatherArmorColor.getBlue()));
        }
        if (banner != null) {
            List<Pattern> patterns = banner.getPatterns();
            configuration.set(path + "banner", (Object)banner.getBaseColor().toString());
            if (patterns != null && !patterns.isEmpty()) {
                ArrayList<CallSite> stringPatterns = new ArrayList<CallSite>();
                for (Pattern p : patterns) {
                    stringPatterns.add((CallSite)((Object)(String.valueOf(p.getColor()) + ":" + String.valueOf(p.getPattern()))));
                }
                configuration.set(path + "patterns", stringPatterns);
            }
        }
        if (item.getEnchantments() != null && !item.getEnchantments().isEmpty()) {
            ArrayList stringEnchantments = new ArrayList(item.getEnchantments().size());
            item.getEnchantments().forEach((enchantment, level) -> stringEnchantments.add(enchantment.getName() + "," + level));
            configuration.set(path + "enchants", stringEnchantments);
        }
        if (item.getFlags() != null && !item.getFlags().isEmpty()) {
            ArrayList<String> flags = new ArrayList<String>(item.getFlags().size());
            for (ItemFlag flag : item.getFlags()) {
                flags.add(flag.toString());
            }
            configuration.set(path + "flags", flags);
        }
        try {
            configuration.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

