/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader;

import fr.maxlego08.menu.ZMenuItemStack;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.button.ButtonOption;
import fr.maxlego08.menu.api.button.DefaultButtonValue;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.enums.PlaceholderAction;
import fr.maxlego08.menu.api.event.events.ButtonLoadEvent;
import fr.maxlego08.menu.api.exceptions.InventoryButtonException;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.loader.ButtonLoader;
import fr.maxlego08.menu.api.loader.PermissibleLoader;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.RefreshRequirement;
import fr.maxlego08.menu.api.requirement.Requirement;
import fr.maxlego08.menu.api.requirement.data.ActionPlayerData;
import fr.maxlego08.menu.api.requirement.permissible.PermissionPermissible;
import fr.maxlego08.menu.api.requirement.permissible.PlaceholderPermissible;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.api.utils.OpenLink;
import fr.maxlego08.menu.api.utils.TypedMapAccessor;
import fr.maxlego08.menu.hooks.xseries.XSound;
import fr.maxlego08.menu.loader.ActionPlayerDataLoader;
import fr.maxlego08.menu.loader.MenuItemStackLoader;
import fr.maxlego08.menu.loader.OpenLinkLoader;
import fr.maxlego08.menu.loader.RefreshRequiementLoader;
import fr.maxlego08.menu.loader.RequirementLoader;
import fr.maxlego08.menu.loader.permissible.PlaceholderPermissibleLoader;
import fr.maxlego08.menu.requirement.permissible.ZPermissionPermissible;
import fr.maxlego08.menu.requirement.permissible.ZPlaceholderPermissible;
import fr.maxlego08.menu.sound.ZSoundOption;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ZButtonLoader
extends ZUtils
implements Loader<Button> {
    private final MenuPlugin plugin;
    private final File file;
    private final int inventorySize;
    private final Map<Character, List<Integer>> matrix;

    public ZButtonLoader(MenuPlugin plugin, File file, int inventorySize, Map<Character, List<Integer>> matrix) {
        this.plugin = plugin;
        this.file = file;
        this.inventorySize = inventorySize;
        this.matrix = matrix;
    }

    @Override
    public Button load(YamlConfiguration configuration, String path, Object ... objects) throws InventoryException {
        List consolePermissionCommands;
        List consoleLeftCommands;
        List consoleRightCommands;
        List consoleCommands;
        List rightCommands;
        List leftCommands;
        List orPermissions;
        String permission;
        String sound;
        List slotsAsString;
        List<Integer> slots;
        int slot;
        int page;
        String buttonType = configuration.getString(path + "type", "NONE");
        String buttonName = (String)objects[0];
        DefaultButtonValue defaultButtonValue = objects.length == 2 ? (DefaultButtonValue)objects[1] : new DefaultButtonValue(this.inventorySize, this.matrix, this.file);
        ConfigurationSection patternSection = configuration.getConfigurationSection(path + "pattern");
        if (patternSection != null) {
            MenuPlugin patternPlugin;
            HashMap<String, Object> mapPlaceholders = new HashMap<String, Object>();
            patternSection.getKeys(false).forEach(key -> mapPlaceholders.put((String)key, patternSection.get(key)));
            String fileName = configuration.getString(path + "pattern.fileName", configuration.getString(path + "pattern.file-name"));
            String pluginName = configuration.getString(path + "pattern.pluginName", configuration.getString(path + "pattern.plugin-name", null));
            MenuPlugin menuPlugin = patternPlugin = pluginName != null ? Bukkit.getPluginManager().getPlugin(pluginName) : this.plugin;
            if (patternPlugin == null) {
                throw new InventoryButtonException("Impossible to load the pattern " + fileName);
            }
            File patternFile = new File(patternPlugin.getDataFolder(), "patterns/" + fileName + ".yml");
            if (!patternFile.exists()) {
                throw new InventoryButtonException("Impossible to load the pattern " + fileName + ", file doesnt exist");
            }
            mapPlaceholders.putAll(this.plugin.getGlobalPlaceholders());
            YamlConfiguration patternConfiguration = this.loadAndReplaceConfiguration(patternFile, mapPlaceholders);
            Button patternButton = this.load(patternConfiguration, "button.", buttonName);
            this.loadViewRequirements(patternButton, configuration, path, this.file);
            if (configuration.contains(path + "else")) {
                DefaultButtonValue elseDefaultButtonValue = new DefaultButtonValue(this.inventorySize, this.matrix, this.file);
                Button elseButton = this.load(configuration, path + "else.", buttonName + ".else", elseDefaultButtonValue);
                patternButton.setElseButton(elseButton);
                if (elseButton != null) {
                    elseButton.setParentButton(patternButton);
                }
            }
            return patternButton;
        }
        ButtonManager buttonManager = this.plugin.getButtonManager();
        Optional<ButtonLoader> optional = buttonManager.getLoader(buttonType);
        if (optional.isEmpty()) {
            throw new InventoryButtonException("Impossible to find the type " + buttonType + " for the button " + path + " in inventory " + this.file.getAbsolutePath());
        }
        MenuItemStackLoader itemStackLoader = new MenuItemStackLoader(this.plugin.getInventoryManager());
        ButtonLoader loader = optional.get();
        Button button = loader.load(configuration, path, defaultButtonValue);
        if (button == null) {
            throw new InventoryButtonException("Impossible to find the type " + buttonType + " for the button " + path + " in inventory " + this.file.getAbsolutePath());
        }
        button.setPlugin(this.plugin);
        try {
            String slotString = configuration.getString(path + "slot", String.valueOf(defaultButtonValue.getSlot()));
            if (slotString.contains("-")) {
                String[] strings = slotString.split("-");
                page = Integer.parseInt(strings[0]);
                slot = Integer.parseInt(strings[1]);
            } else {
                slot = this.parseInt(configuration.getString(path + "slot", null), defaultButtonValue.getSlot());
                page = this.parseInt(configuration.getString(path + "page", null), defaultButtonValue.getPage());
            }
        }
        catch (Exception ignored) {
            slot = this.parseInt(configuration.getString(path + "slot", null), defaultButtonValue.getSlot());
            page = this.parseInt(configuration.getString(path + "page", null), defaultButtonValue.getPage());
        }
        page = Math.max(page, 1);
        if (slot != defaultButtonValue.getSlot() || slot == 0) {
            slot += (page - 1) * this.inventorySize;
        }
        if ((slots = ButtonLoader.loadSlot(slotsAsString = configuration.getStringList(path + "slots"))).isEmpty()) {
            slots = defaultButtonValue.getSlots();
        } else {
            int finalPage = page;
            ArrayList<Integer> adjustedSlots = new ArrayList<Integer>(slots.size());
            for (Integer specialSlot : slots) {
                adjustedSlots.add(specialSlot + (finalPage - 1) * this.inventorySize);
            }
            slots = adjustedSlots;
        }
        char currentChar = buttonName.charAt(0);
        if (this.matrix.containsKey(Character.valueOf(currentChar)) && (slots = this.matrix.get(Character.valueOf(currentChar))).size() == 1) {
            slot = slots.getFirst();
            slots = new ArrayList<Integer>();
        }
        if (slots.isEmpty()) {
            button.setSlot(slot);
        } else {
            button.setSlots(slots);
        }
        button.setPage(page);
        button.setPermanent(configuration.getBoolean(path + "isPermanent", configuration.getBoolean(path + "is-permanent", defaultButtonValue.isPermanent())));
        button.setUpdateOnClick(configuration.getBoolean(path + "updateOnClick", configuration.getBoolean(path + "update-on-click", defaultButtonValue.isUpdateOnClick())));
        button.setCloseInventory(configuration.getBoolean(path + "closeInventory", configuration.getBoolean(path + "close-inventory", defaultButtonValue.isCloseInventory())));
        ZMenuItemStack itemStack = (ZMenuItemStack)itemStackLoader.load(configuration, path + "item.", this.file);
        button.setItemStack(itemStack);
        button.setButtonName(buttonName);
        button.setMessages(configuration.getStringList(path + "messages"));
        String playerHead = configuration.getString(path + "playerHead", configuration.getString(path + "player-head", configuration.getString(path + "item.playerHead", configuration.getString(path + "item.player-head", defaultButtonValue.getPlayerHead()))));
        if (playerHead != null) {
            if (NmsVersion.nmsVersion.isNewMaterial()) {
                itemStack.setMaterial("PLAYER_HEAD");
            } else {
                itemStack.setMaterial("SKULL_ITEM");
                itemStack.setData("3");
            }
            button.setPlayerHead(playerHead);
        }
        button.setUpdated(configuration.getBoolean(path + "update", defaultButtonValue.isUpdate()));
        button.setMasterButtonUpdated(configuration.getBoolean(path + "updateMasterButton", configuration.getBoolean(path + "update-master-button", defaultButtonValue.isUpdateMasterButton())));
        button.setRefreshOnClick(configuration.getBoolean(path + "refreshOnClick", configuration.getBoolean(path + "refresh-on-click", defaultButtonValue.isRefreshOnClick())));
        button.setUseCache(configuration.getBoolean(path + "useCache", configuration.getBoolean(path + "use-cache", defaultButtonValue.isUseCache())));
        button.setOpenAsync(configuration.getBoolean(path + "openAsync", configuration.getBoolean(path + "open-async", false)));
        String loadString = null;
        if (configuration.contains(path + "openLink")) {
            loadString = "openLink";
        } else if (configuration.contains(path + "open-link")) {
            loadString = "open-link";
        }
        if (configuration.contains(path + loadString)) {
            OpenLinkLoader loaderLink = new OpenLinkLoader(this.plugin);
            button.setOpenLink((OpenLink)loaderLink.load(configuration, path + loadString + ".", new Object[0]));
        }
        Optional optionalXSound = (sound = configuration.getString(path + "sound", null)) == null || sound.isEmpty() ? Optional.empty() : XSound.of(sound);
        String categoryName = configuration.getString(path + "sound-category", configuration.getString(path + "category", XSound.Category.MASTER.name()));
        float pitch = Float.parseFloat(configuration.getString(path + "pitch", "1.0f"));
        float volume = Float.parseFloat(configuration.getString(path + "volume", "1.0f"));
        if (optionalXSound.isPresent()) {
            XSound xSound = (XSound)optionalXSound.get();
            button.setSoundOption(new ZSoundOption(xSound, categoryName, null, pitch, volume, false));
        } else {
            button.setSoundOption(new ZSoundOption(null, categoryName, sound, pitch, volume, true));
        }
        ActionPlayerDataLoader loaderActions = new ActionPlayerDataLoader(this.plugin.getStorageManager());
        ArrayList<ActionPlayerData> actionPlayerDatas = new ArrayList<ActionPlayerData>();
        if (configuration.isConfigurationSection(path + "datas")) {
            for (String key2 : configuration.getConfigurationSection(path + "datas.").getKeys(false)) {
                ActionPlayerData actionPlayerData = (ActionPlayerData)loaderActions.load(configuration, path + "datas." + key2 + ".", new Object[0]);
                actionPlayerDatas.add(actionPlayerData);
            }
        }
        button.setDatas(actionPlayerDatas);
        List permissions = configuration.getStringList(path + "permission");
        if (permissions.isEmpty()) {
            permissions = configuration.getStringList(path + "permissions");
        }
        if (!permissions.isEmpty()) {
            ArrayList<PermissionPermissible> mappedPermissions = new ArrayList<PermissionPermissible>(permissions.size());
            for (String permissionValue : permissions) {
                mappedPermissions.add(new ZPermissionPermissible(permissionValue));
            }
            button.setPermissions(mappedPermissions);
        }
        if ((permission = configuration.getString(path + "permission", null)) != null) {
            button.getPermissions().add(new ZPermissionPermissible(permission));
        }
        if ((orPermissions = configuration.getStringList(path + "orPermission")).isEmpty()) {
            orPermissions = configuration.getStringList(path + "or-permission");
        }
        if (orPermissions.isEmpty()) {
            orPermissions = configuration.getStringList(path + "orPermissions");
        }
        if (orPermissions.isEmpty()) {
            orPermissions = configuration.getStringList(path + "or-permissions");
        }
        ArrayList<PermissionPermissible> mappedOrPermissions = new ArrayList<PermissionPermissible>(orPermissions.size());
        for (String permissionValue : orPermissions) {
            mappedOrPermissions.add(new ZPermissionPermissible(permissionValue));
        }
        button.setOrPermissions(mappedOrPermissions);
        if (configuration.contains(path + "else")) {
            DefaultButtonValue elseDefaultButtonValue = new DefaultButtonValue(this.inventorySize, this.matrix, this.file);
            elseDefaultButtonValue.setSlot(slot);
            elseDefaultButtonValue.setSlots(slots);
            elseDefaultButtonValue.setPage(page);
            elseDefaultButtonValue.setPermanent(button.isPermanent());
            elseDefaultButtonValue.setUseCache(button.isUseCache());
            elseDefaultButtonValue.setUpdate(button.isUpdated());
            elseDefaultButtonValue.setUpdateMasterButton(button.isUpdatedMasterButton());
            elseDefaultButtonValue.setUpdateOnClick(button.updateOnClick());
            Button elseButton = this.load(configuration, path + "else.", buttonName + ".else", elseDefaultButtonValue);
            button.setElseButton(elseButton);
            if (elseButton != null) {
                elseButton.setParentButton(button);
            }
        }
        PlaceholderPermissibleLoader permissibleLoader = new PlaceholderPermissibleLoader(this.plugin.getButtonManager());
        List placeholderMaps = configuration.getList(path + "placeholders", new ArrayList());
        ArrayList<PlaceholderPermissible> placeholders = new ArrayList<PlaceholderPermissible>();
        for (Map map : placeholderMaps) {
            PlaceholderPermissible permissible = (PlaceholderPermissible)((PermissibleLoader)permissibleLoader).load(path + "placeholders", new TypedMapAccessor(map), this.file);
            if (permissible == null || !permissible.isValid()) {
                Logger.info("A placeholder is invalid in the placeholder list of the button " + path + " in file " + this.file.getAbsolutePath(), Logger.LogType.ERROR);
                continue;
            }
            placeholders.add(permissible);
        }
        String placeholder = configuration.getString(path + "placeHolder", configuration.getString(path + "placeholder", null));
        PlaceholderAction placeholderAction = PlaceholderAction.from(configuration.getString(path + "action", null));
        String placeholderValue = configuration.getString(path + "value", null);
        String targetPlayer = configuration.getString(path + "target", null);
        boolean mathExpression = configuration.getBoolean(path + "math");
        if (placeholderAction != null && placeholderValue != null && placeholder != null) {
            placeholders.add(new ZPlaceholderPermissible(placeholderAction, placeholder, placeholderValue, targetPlayer, new ArrayList<Action>(), new ArrayList<Action>(), mathExpression));
        }
        button.setPlaceholders(placeholders);
        List commands = configuration.getStringList(path + "commands");
        if (commands.isEmpty()) {
            commands = configuration.getStringList(path + "playerCommands");
        }
        if (commands.isEmpty()) {
            commands = configuration.getStringList(path + "player-commands");
        }
        if ((leftCommands = configuration.getStringList(path + "leftCommands")).isEmpty()) {
            leftCommands = configuration.getStringList(path + "left-commands");
        }
        if (leftCommands.isEmpty()) {
            leftCommands = configuration.getStringList(path + "leftPlayerCommands");
        }
        if (leftCommands.isEmpty()) {
            leftCommands = configuration.getStringList(path + "left-player-commands");
        }
        if ((rightCommands = configuration.getStringList(path + "rightCommands")).isEmpty()) {
            rightCommands = configuration.getStringList(path + "right-commands");
        }
        if (rightCommands.isEmpty()) {
            rightCommands = configuration.getStringList(path + "rightPlayerCommands");
        }
        if (rightCommands.isEmpty()) {
            rightCommands = configuration.getStringList(path + "right-player-commands");
        }
        if ((consoleCommands = configuration.getStringList(path + "consoleCommands")).isEmpty()) {
            consoleCommands = configuration.getStringList(path + "console-commands");
        }
        if ((consoleRightCommands = configuration.getStringList(path + "consoleRightCommands")).isEmpty()) {
            consoleRightCommands = configuration.getStringList(path + "console-right-commands");
        }
        if ((consoleLeftCommands = configuration.getStringList(path + "consoleLeftCommands")).isEmpty()) {
            consoleLeftCommands = configuration.getStringList(path + "console-left-commands");
        }
        if ((consolePermissionCommands = configuration.getStringList(path + "consolePermissionCommands")).isEmpty()) {
            consolePermissionCommands = configuration.getStringList(path + "console-permission-commands");
        }
        String consolePermission = configuration.getString(path + "consolePermission", configuration.getString(path + "console-permission"));
        button.setCommands(commands);
        button.setLeftCommands(leftCommands);
        button.setRightCommands(rightCommands);
        button.setConsoleCommands(consoleCommands);
        button.setConsoleRightCommands(consoleRightCommands);
        button.setConsoleLeftCommands(consoleLeftCommands);
        button.setConsolePermissionCommands(consolePermissionCommands);
        button.setConsolePermission(consolePermission);
        this.loadViewRequirements(button, configuration, path, this.file);
        this.loadClickRequirements(button, configuration, path, this.file);
        this.loadRefreshRequirements(button, configuration, path, this.file);
        List<Action> actions = buttonManager.loadActions(configuration.getList(path + "actions", new ArrayList()), path + "actions", this.file);
        button.setActions(actions);
        InventoryManager inventoryManager = this.plugin.getInventoryManager();
        ArrayList<ButtonOption> buttonOptions = new ArrayList<ButtonOption>();
        for (Map.Entry<Plugin, List<Class<? extends ButtonOption>>> entry : inventoryManager.getOptions().entrySet()) {
            for (Class<? extends ButtonOption> optionClass : entry.getValue()) {
                ButtonOption instance = this.createInstance(entry.getKey(), optionClass);
                if (instance == null) continue;
                buttonOptions.add(instance);
            }
        }
        buttonOptions.forEach(option -> option.loadButton(button, configuration, path, inventoryManager, buttonManager, itemStackLoader, this.file));
        button.setOptions(buttonOptions);
        ButtonLoadEvent buttonLoadEvent = new ButtonLoadEvent(configuration, path, buttonManager, loader, button);
        if (Config.enableFastEvent) {
            inventoryManager.getFastEvents().forEach(event -> event.onButtonLoad(buttonLoadEvent));
        } else {
            buttonLoadEvent.call();
        }
        return button;
    }

    private void loadClickRequirements(Button button, YamlConfiguration configuration, String path, File file) throws InventoryException {
        String string;
        String[] sectionStrings = new String[]{"click_requirement.", "click-requirement.", "click_requirements.", "click-requirements.", "clicks_requirement.", "clicks-requirement.", "clicks_requirements.", "clicks-requirements."};
        ConfigurationSection section = null;
        String sectionString = "";
        String[] stringArray = sectionStrings;
        int n = stringArray.length;
        for (int i = 0; i < n && (section = configuration.getConfigurationSection(path + (sectionString = (string = stringArray[i])))) == null; ++i) {
        }
        if (section == null) {
            return;
        }
        RequirementLoader loader = new RequirementLoader(this.plugin);
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (String key : section.getKeys(false)) {
            requirements.add((Requirement)loader.load(configuration, path + sectionString + key + ".", file));
        }
        button.setClickRequirements(requirements);
    }

    private void loadViewRequirements(Button button, YamlConfiguration configuration, String path, File file) throws InventoryException {
        String requirementPath;
        RequirementLoader loader = new RequirementLoader(this.plugin);
        String string = configuration.isConfigurationSection(path + "view_requirement.") ? "view_requirement." : (requirementPath = configuration.isConfigurationSection(path + "view-requirement.") ? "view-requirement." : null);
        if (requirementPath == null) {
            return;
        }
        button.setViewRequirement((Requirement)loader.load(configuration, path + requirementPath, file));
    }

    private void loadRefreshRequirements(Button button, YamlConfiguration configuration, String path, File file) throws InventoryException {
        String requirementPath;
        RefreshRequiementLoader loader = new RefreshRequiementLoader(this.plugin);
        String string = configuration.isConfigurationSection(path + "refresh_requirements.") ? "refresh_requirements." : (requirementPath = configuration.isConfigurationSection(path + "refresh-requirements.") ? "refresh-requirements." : null);
        if (requirementPath == null) {
            return;
        }
        button.setRefreshRequirement((RefreshRequirement)loader.load(configuration, path + requirementPath, file));
    }

    @Override
    public void save(Button object, YamlConfiguration configuration, String path, File file, Object ... objects) {
    }

    private ButtonOption createInstance(Plugin plugin, Class<? extends ButtonOption> aClass) {
        try {
            Constructor<? extends ButtonOption> constructor = aClass.getConstructor(Plugin.class);
            return constructor.newInstance(plugin);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

