/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader.deluxemenu;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.button.DefaultButtonValue;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.event.events.ButtonLoadEvent;
import fr.maxlego08.menu.api.exceptions.InventoryButtonException;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.loader.ButtonLoader;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.Permissible;
import fr.maxlego08.menu.api.requirement.Requirement;
import fr.maxlego08.menu.api.requirement.permissible.PermissionPermissible;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.loader.MenuItemStackLoader;
import fr.maxlego08.menu.loader.deluxemenu.DeluxeMenuCommandUtils;
import fr.maxlego08.menu.requirement.ZRequirement;
import fr.maxlego08.menu.requirement.permissible.ZPermissionPermissible;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.inventory.ClickType;

public class ButtonDeluxeMenuLoader
extends DeluxeMenuCommandUtils
implements Loader<Button> {
    private final ZMenuPlugin plugin;
    private final File file;
    private final int inventorySize;

    public ButtonDeluxeMenuLoader(ZMenuPlugin plugin, File file, int inventorySize) {
        this.plugin = plugin;
        this.file = file;
        this.inventorySize = inventorySize;
    }

    @Override
    public Button load(YamlConfiguration configuration, String path, Object ... objects) throws InventoryException {
        String permission;
        Requirement requirement;
        ConfigurationSection middleClickRequirement;
        ConfigurationSection shiftRightClickRequirement;
        ConfigurationSection shiftLeftClickRequirement;
        ConfigurationSection rightClickRequirementSection;
        List slotsAsString;
        List<Integer> slots;
        int slot;
        int page;
        String buttonType = "NONE";
        String buttonName = (String)objects[0];
        DefaultButtonValue defaultButtonValue = objects.length == 2 ? (DefaultButtonValue)objects[1] : new DefaultButtonValue(this.inventorySize, new HashMap<Character, List<Integer>>(), this.file);
        ButtonManager buttonManager = this.plugin.getButtonManager();
        Optional<ButtonLoader> optional = buttonManager.getLoader(buttonType);
        if (optional.isEmpty()) {
            throw new InventoryButtonException("Impossible to find the type " + buttonType + " for the button " + path + " in inventory " + this.file.getAbsolutePath());
        }
        MenuItemStackLoader itemStackLoader = new MenuItemStackLoader(this.plugin.getInventoryManager());
        ButtonLoader loader = optional.get();
        Button button = loader.load(configuration, path, defaultButtonValue);
        button.setPlugin(this.plugin);
        try {
            String slotString = configuration.getString(path + "slot", String.valueOf(defaultButtonValue.getSlot()));
            if (slotString.contains("-")) {
                String[] strings = slotString.split("-");
                page = Integer.parseInt(strings[0]);
                slot = Integer.parseInt(strings[1]);
            } else {
                slot = this.parseInt(configuration.getString(path + "slot", null), defaultButtonValue.getSlot());
                page = this.parseInt(configuration.getString(path + "page", null), defaultButtonValue.getPage());
            }
        }
        catch (Exception ignored) {
            slot = this.parseInt(configuration.getString(path + "slot", null), defaultButtonValue.getSlot());
            page = this.parseInt(configuration.getString(path + "page", null), defaultButtonValue.getPage());
        }
        page = Math.max(page, 1);
        if (slot != defaultButtonValue.getSlot() || slot == 0) {
            slot += (page - 1) * this.inventorySize;
        }
        if ((slots = ButtonLoader.loadSlot(slotsAsString = configuration.getStringList(path + "slots"))).isEmpty()) {
            slots = defaultButtonValue.getSlots();
        }
        button.setSlots(slots);
        button.setSlot(slot);
        button.setPage(page);
        InventoryManager inventoryManager = this.plugin.getInventoryManager();
        MenuItemStack itemStack = (MenuItemStack)itemStackLoader.load(configuration, path + ".", this.file);
        button.setItemStack(itemStack);
        button.setButtonName(buttonName);
        List clickCommands = configuration.getStringList(path + "click_commands");
        List leftClickCommands = configuration.getStringList(path + "left_click_commands");
        List rightClickCommands = configuration.getStringList(path + "right_click_commands");
        List middleClickCommands = configuration.getStringList(path + "middle_click_commands");
        List shiftLeftClickCommands = configuration.getStringList(path + "shift_left_click_commands");
        List shiftRightClickCommands = configuration.getStringList(path + "shift_right_click_commands");
        List<Action> actions = this.loadActions(inventoryManager, this.plugin.getCommandManager(), this.plugin, clickCommands);
        List<Action> leftActions = this.loadActions(inventoryManager, this.plugin.getCommandManager(), this.plugin, leftClickCommands);
        List<Action> rightActions = this.loadActions(inventoryManager, this.plugin.getCommandManager(), this.plugin, rightClickCommands);
        List<Action> middleActions = this.loadActions(inventoryManager, this.plugin.getCommandManager(), this.plugin, middleClickCommands);
        List<Action> shiftLeftActions = this.loadActions(inventoryManager, this.plugin.getCommandManager(), this.plugin, shiftLeftClickCommands);
        List<Action> shiftRightActions = this.loadActions(inventoryManager, this.plugin.getCommandManager(), this.plugin, shiftRightClickCommands);
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        ConfigurationSection leftClickRequirementSection = configuration.getConfigurationSection(path + "left_click_requirement");
        if (leftClickRequirementSection != null) {
            Requirement requirement2 = this.loadRequirement(leftActions.isEmpty() ? actions : leftActions, leftClickRequirementSection, ClickType.LEFT);
            requirements.add(requirement2);
        }
        if ((rightClickRequirementSection = configuration.getConfigurationSection(path + "right_click_requirement")) != null) {
            Requirement requirement3 = this.loadRequirement(rightActions.isEmpty() ? actions : rightActions, rightClickRequirementSection, ClickType.RIGHT);
            requirements.add(requirement3);
        }
        if ((shiftLeftClickRequirement = configuration.getConfigurationSection(path + "shift_left_click_requirement")) != null) {
            Requirement requirement4 = this.loadRequirement(shiftLeftActions, shiftLeftClickRequirement, ClickType.SHIFT_LEFT);
            requirements.add(requirement4);
        }
        if ((shiftRightClickRequirement = configuration.getConfigurationSection(path + "shift_right_click_requirement")) != null) {
            Requirement requirement5 = this.loadRequirement(shiftRightActions, shiftRightClickRequirement, ClickType.SHIFT_RIGHT);
            requirements.add(requirement5);
        }
        if ((middleClickRequirement = configuration.getConfigurationSection(path + "middle_click_requirement")) != null) {
            Requirement requirement6 = this.loadRequirement(middleActions, middleClickRequirement, ClickType.SHIFT_RIGHT);
            requirements.add(requirement6);
        }
        if (requirements.isEmpty()) {
            List<Action> globalActions;
            List<Action> list = leftActions.isEmpty() ? (rightActions.isEmpty() ? actions : rightActions) : (globalActions = leftActions);
            if (!globalActions.isEmpty()) {
                requirement = new ZRequirement(0, new ArrayList<Permissible>(), new ArrayList<Action>(), globalActions, Config.allClicksType);
                requirements.add(requirement);
            }
        }
        button.setClickRequirements(requirements);
        ConfigurationSection viewRequirementSection = configuration.getConfigurationSection(path + "view_requirement");
        if (viewRequirementSection != null) {
            requirement = this.loadRequirement(new ArrayList<Action>(), viewRequirementSection, new ClickType[0]);
            button.setViewRequirement(requirement);
        }
        button.setUpdated(configuration.getBoolean(path + "update", defaultButtonValue.isUpdate()));
        button.setPriority(configuration.getInt(path + "priority", -1));
        List permissions = configuration.getStringList(path + "permission");
        List list = permissions = permissions.isEmpty() ? configuration.getStringList(path + "permissions") : permissions;
        if (permissions.isEmpty() && (permission = configuration.getString(path + "permission", null)) != null) {
            permissions.add(permission);
        }
        ArrayList<PermissionPermissible> mappedPermissions = new ArrayList<PermissionPermissible>(permissions.size());
        for (String permissionValue : permissions) {
            mappedPermissions.add(new ZPermissionPermissible(permissionValue));
        }
        button.setPermissions(mappedPermissions);
        List orPermissions = configuration.getStringList(path + "orPermission");
        List resolvedOrPermissions = orPermissions.isEmpty() ? configuration.getStringList(path + "orPermissions") : orPermissions;
        ArrayList<PermissionPermissible> mappedOrPermissions = new ArrayList<PermissionPermissible>(resolvedOrPermissions.size());
        for (String permissionValue : resolvedOrPermissions) {
            mappedOrPermissions.add(new ZPermissionPermissible(permissionValue));
        }
        button.setOrPermissions(mappedOrPermissions);
        ButtonLoadEvent buttonLoadEvent = new ButtonLoadEvent(configuration, path, buttonManager, loader, button);
        if (Config.enableFastEvent) {
            inventoryManager.getFastEvents().forEach(event -> event.onButtonLoad(buttonLoadEvent));
        } else {
            buttonLoadEvent.call();
        }
        return button;
    }

    private Requirement loadRequirement(List<Action> actions, ConfigurationSection configurationSection, ClickType ... clickTypes) {
        List<Object> permissibles = new ArrayList();
        ConfigurationSection configurationSectionRequirements = configurationSection.getConfigurationSection("requirements");
        if (configurationSectionRequirements != null) {
            permissibles = this.loadPermissibles(this.plugin.getInventoryManager(), this.plugin.getCommandManager(), this.plugin, configurationSectionRequirements);
        }
        List<Action> denyActions = this.loadActions(this.plugin.getInventoryManager(), this.plugin.getCommandManager(), this.plugin, configurationSection.getStringList("deny_commands"));
        return new ZRequirement(configurationSection.getInt("minimum_requirements", permissibles.size()), permissibles, denyActions, actions, Arrays.asList(clickTypes));
    }

    @Override
    public void save(Button object, YamlConfiguration configuration, String path, File file, Object ... objects) {
    }
}

