/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.loader.deluxemenu;

import fr.maxlego08.menu.ZInventory;
import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.exceptions.InventorySizeException;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.Permissible;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.loader.MenuItemStackLoader;
import fr.maxlego08.menu.loader.deluxemenu.ButtonDeluxeMenuLoader;
import fr.maxlego08.menu.loader.deluxemenu.DeluxeMenuCommandUtils;
import fr.maxlego08.menu.requirement.ZRequirement;
import fr.maxlego08.menu.zcore.logger.Logger;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class InventoryDeluxeMenuLoader
extends DeluxeMenuCommandUtils
implements Loader<Inventory> {
    private final ZMenuPlugin plugin;

    public InventoryDeluxeMenuLoader(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Inventory load(YamlConfiguration configuration, String path, Object ... objects) throws InventoryException {
        ConfigurationSection configurationSection;
        ZInventory inventory;
        File file = (File)objects[0];
        String name = configuration.getString("name", configuration.getString("menu_title", configuration.getString("title")));
        name = name == null ? "" : name;
        int size = configuration.getInt("size", 54);
        if (size % 9 != 0) {
            throw new InventorySizeException("Size " + size + " is not valid for inventory " + file.getAbsolutePath());
        }
        ArrayList<Button> buttons = new ArrayList<Button>();
        ButtonDeluxeMenuLoader loader = new ButtonDeluxeMenuLoader(this.plugin, file, size);
        ConfigurationSection section = configuration.getConfigurationSection("items.");
        if (section != null) {
            for (Object buttonPath : section.getKeys(false)) {
                try {
                    buttons.add((Button)loader.load(configuration, "items." + (String)buttonPath + ".", buttonPath));
                }
                catch (Exception exception) {
                    Logger.info(exception.getMessage(), Logger.LogType.ERROR);
                }
            }
        } else if (Config.enableDebug) {
            Logger.info("items section was not found in " + file.getAbsolutePath(), Logger.LogType.ERROR);
        }
        ArrayList copiedButtons = new ArrayList(buttons);
        for (Button button : copiedButtons) {
            if (button.getPriority() < 0) continue;
            ArrayList<Button> sameButtons = new ArrayList<Button>();
            for (Button currentButton : buttons) {
                if (currentButton.getSlot() != button.getSlot() || currentButton.getPriority() < 0) continue;
                sameButtons.add(currentButton);
            }
            if (sameButtons.size() < 2) continue;
            buttons.removeAll(sameButtons);
            sameButtons.sort(Comparator.comparingInt(Button::getPriority).reversed());
            LinkedList queue = new LinkedList(sameButtons);
            Button lastButton = (Button)queue.poll();
            while (!queue.isEmpty()) {
                Button currentButton = (Button)queue.poll();
                currentButton.setElseButton(lastButton);
                lastButton = currentButton;
            }
            buttons.add(lastButton);
        }
        String fileName = this.getFileNameWithoutExtension(file);
        try {
            Class classz = (Class)objects[1];
            Constructor constructor = classz.getDeclaredConstructor(Plugin.class, String.class, String.class, Integer.TYPE, List.class);
            Plugin plugin = (Plugin)objects[2];
            inventory = (ZInventory)constructor.newInstance(plugin, name, fileName, size, buttons);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            inventory = new ZInventory(this.plugin, name, fileName, size, buttons);
        }
        inventory.setUpdateInterval(configuration.getInt(path + "update_interval", 1) * 1000);
        inventory.setClearInventory(false);
        inventory.setFile(file);
        inventory.setTargetPlayerNamePlaceholder("%player_name%");
        ArrayList<Action> actions = new ArrayList();
        List<Permissible> permissibles = new ArrayList<Permissible>();
        if (configuration.contains("open_commands")) {
            actions = this.loadActions(this.plugin.getInventoryManager(), this.plugin.getCommandManager(), this.plugin, configuration.getStringList("open_commands"));
        }
        if (configuration.contains("open_requirement") && configuration.isConfigurationSection("open_requirement") && (configurationSection = configuration.getConfigurationSection("open_requirement.requirements")) != null) {
            permissibles = this.loadPermissibles(this.plugin.getInventoryManager(), this.plugin.getCommandManager(), this.plugin, configurationSection);
        }
        ZRequirement requirement = new ZRequirement(configuration.getInt("open_requirement.minimum_requirements", permissibles.size()), permissibles, new ArrayList<Action>(), actions, new ArrayList<ClickType>());
        inventory.setOpenRequirement(requirement);
        if (Config.enableDebug) {
            this.plugin.getLogger().warning("The inventory " + file.getPath() + " is a DeluxeMenus configuration! It is advisable to redo your configuration with zMenu!");
        }
        return inventory;
    }

    @Override
    public void save(Inventory object, YamlConfiguration configuration, String path, File file, Object ... objects) {
        MenuItemStackLoader itemStackLoader = new MenuItemStackLoader(this.plugin.getInventoryManager());
        configuration.set("name", (Object)object.getName());
        configuration.set("size", (Object)object.size());
        if (object.getFillItemStack() != null) {
            itemStackLoader.save(object.getFillItemStack(), configuration, "fillItem.", file, new Object[0]);
        }
    }
}

