/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.pattern;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.checker.InventoryRequirementType;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.pattern.Pattern;
import fr.maxlego08.menu.api.pattern.PatternManager;
import fr.maxlego08.menu.loader.PatternLoader;
import fr.maxlego08.menu.zcore.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.configuration.file.YamlConfiguration;

public class ZPatternManager
implements PatternManager {
    private final ZMenuPlugin plugin;
    private final Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public ZPatternManager(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Collection<Pattern> getPatterns() {
        return this.patterns.values();
    }

    @Override
    public Optional<Pattern> getPattern(String name) {
        return Optional.ofNullable(this.patterns.getOrDefault(name, null));
    }

    @Override
    public void registerPattern(Pattern pattern) {
        this.patterns.put(pattern.name(), pattern);
    }

    @Override
    public void unregisterPattern(Pattern pattern) {
        this.patterns.remove(pattern.name());
    }

    @Override
    public Pattern loadPattern(File file) throws InventoryException {
        PatternLoader loader = new PatternLoader(this.plugin);
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Pattern pattern = (Pattern)loader.load(yamlConfiguration, "", file);
        if (pattern != null) {
            this.patterns.put(pattern.name(), pattern);
            if (Config.enableInformationMessage) {
                Logger.info(file.getPath() + " loaded successfully !", Logger.LogType.INFO);
            }
            this.plugin.getInventoryManager().loadElement(InventoryRequirementType.PATTERN, pattern.name());
        }
        return pattern;
    }

    @Override
    public void loadPatterns() {
        File folder = new File(this.plugin.getDataFolder(), "patterns");
        if (!folder.exists()) {
            folder.mkdir();
        }
        try (Stream<Path> stream = Files.walk(Paths.get(folder.getPath(), new String[0]), new FileVisitOption[0]);){
            stream.skip(1L).map(Path::toFile).filter(File::isFile).filter(file -> file.getName().endsWith(".yml")).forEach(file -> {
                try {
                    this.loadPattern((File)file);
                }
                catch (InventoryException inventoryException) {
                    inventoryException.printStackTrace();
                }
            });
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

