/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.players;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.maxlego08.menu.api.players.Data;
import fr.maxlego08.menu.players.ZData;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PlayerDataLoader {
    public static Map<UUID, List<Data>> loadPlayerData(String path) throws IOException {
        HashMap<UUID, List<Data>> result = new HashMap<UUID, List<Data>>();
        Gson gson = new Gson();
        JsonObject root = JsonParser.parseReader((Reader)new FileReader(path)).getAsJsonObject();
        JsonObject players = root.getAsJsonObject("players");
        for (Map.Entry entry : players.entrySet()) {
            UUID uuid = UUID.fromString((String)entry.getKey());
            JsonObject playerObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            JsonObject datas = playerObject.getAsJsonObject("datas");
            ArrayList<ZData> dataList = new ArrayList<ZData>();
            for (Map.Entry dataEntry : datas.entrySet()) {
                String jsonString = ((JsonElement)dataEntry.getValue()).getAsString();
                JsonObject inner = JsonParser.parseString((String)jsonString).getAsJsonObject();
                String key = inner.get("key").getAsString();
                long expiredAt = inner.get("expiredAt").getAsLong();
                String value = inner.get("value").getAsString();
                dataList.add(new ZData(key, value, expiredAt));
            }
            result.put(uuid, dataList);
        }
        return result;
    }
}

