/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.players;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.interfaces.ReturnConsumer;
import fr.maxlego08.menu.api.players.Data;
import fr.maxlego08.menu.api.players.DataManager;
import fr.maxlego08.menu.api.players.PlayerData;
import fr.maxlego08.menu.api.storage.StorageManager;
import fr.maxlego08.menu.api.storage.dto.DataDTO;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.api.utils.OfflinePlayerCache;
import fr.maxlego08.menu.placeholder.LocalPlaceholder;
import fr.maxlego08.menu.players.PlayerDataLoader;
import fr.maxlego08.menu.players.ZPlayerData;
import fr.maxlego08.menu.zcore.utils.builder.TimerBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ZDataManager
implements DataManager {
    private final Map<UUID, ZPlayerData> players = new HashMap<UUID, ZPlayerData>();
    private final ZMenuPlugin plugin;
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private long lastSave;

    public ZDataManager(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Optional<PlayerData> getPlayer(UUID uniqueId) {
        return Optional.ofNullable(this.players.getOrDefault(uniqueId, null));
    }

    @Override
    public PlayerData getOrCreate(UUID uniqueId) {
        Optional<PlayerData> optional = this.getPlayer(uniqueId);
        if (optional.isPresent()) {
            return optional.get();
        }
        ZPlayerData data = new ZPlayerData(this.plugin.getStorageManager(), uniqueId);
        this.players.put(uniqueId, data);
        return data;
    }

    @Override
    public void addData(UUID uniqueId, Data data) {
        PlayerData playerData = this.getOrCreate(uniqueId);
        playerData.addData(data);
    }

    @Override
    public Optional<Data> getData(UUID uniqueId, String key) {
        Optional<PlayerData> optional = this.getPlayer(uniqueId);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        PlayerData playerData = optional.get();
        return playerData.getData(key);
    }

    public List<String> getKeys(String[] args) {
        if (args.length != 4) {
            return new ArrayList<String>();
        }
        try {
            String playerName = args[2];
            OfflinePlayer offlinePlayer = OfflinePlayerCache.get(playerName);
            Optional<PlayerData> optional = this.getPlayer(offlinePlayer.getUniqueId());
            if (optional.isEmpty()) {
                return new ArrayList<String>();
            }
            PlayerData playerData = optional.get();
            ArrayList<String> keys = new ArrayList<String>(playerData.getDatas().size());
            for (Data data : playerData.getDatas()) {
                keys.add(data.getKey());
            }
            return keys;
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    @Override
    public void clearAll() {
        this.players.clear();
        this.plugin.getStorageManager().clearData();
    }

    @Override
    public void clearPlayer(UUID uniqueId) {
        this.players.remove(uniqueId);
        this.plugin.getStorageManager().clearData(uniqueId);
    }

    @Override
    public void loadDefaultValues() {
        YamlConfiguration configuration;
        ConfigurationSection configurationSection;
        File file = new File(this.plugin.getDataFolder(), "default_values.yml");
        if (!file.exists()) {
            this.plugin.saveResource("default_values.yml", false);
        }
        if ((configurationSection = (configuration = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("values")) == null) {
            return;
        }
        this.defaultValues.clear();
        configurationSection.getKeys(false).forEach(key -> this.defaultValues.put((String)key, configuration.getString("values." + key)));
    }

    @Override
    public void loadPlayers() {
        List<DataDTO> playerDatas = this.plugin.getStorageManager().loadPlayers();
        for (DataDTO dto : playerDatas) {
            ZPlayerData playerData = this.players.computeIfAbsent(dto.player_id(), uuid -> new ZPlayerData(this.plugin.getStorageManager(), (UUID)uuid));
            playerData.setData(dto);
        }
    }

    @Override
    public List<String> getKeys() {
        HashSet<String> strings = new HashSet<String>();
        strings.addAll(this.defaultValues.keySet());
        for (PlayerData playerData : this.players.values()) {
            for (Data data : playerData.getDatas()) {
                strings.add(data.getKey());
            }
        }
        return new ArrayList<String>(strings);
    }

    @Override
    public void clearKey(String key) {
        this.players.values().forEach(e -> e.removeData(key));
        this.plugin.getStorageManager().clearData(key);
    }

    public void registerPlaceholder(LocalPlaceholder localPlaceholder) {
        localPlaceholder.register("player_key_exist_", (offlinePlayer, key) -> {
            Optional<PlayerData> optional = this.getPlayer(offlinePlayer.getUniqueId());
            if (optional.isEmpty()) {
                return "false";
            }
            PlayerData playerData = optional.get();
            return String.valueOf(playerData.containsKey((String)key));
        });
        localPlaceholder.register("player_value_", (offlinePlayer, key) -> this.handlePlaceholder((OfflinePlayer)offlinePlayer, (String)key, data -> data.getValue().toString()));
        localPlaceholder.register("player_expire_format_", (offlinePlayer, key) -> this.handlePlaceholder((OfflinePlayer)offlinePlayer, (String)key, data -> {
            if (data.getExpiredAt() <= 0L) {
                return Message.PLACEHOLDER_NEVER.getMessage();
            }
            long seconds = Math.abs(System.currentTimeMillis() - data.getExpiredAt()) / 1000L;
            return TimerBuilder.getStringTime(seconds);
        }));
        localPlaceholder.register("player_expire_", (offlinePlayer, key) -> this.handlePlaceholder((OfflinePlayer)offlinePlayer, (String)key, data -> String.valueOf(data.getExpiredAt())));
        localPlaceholder.register("player_is_expired_", (offlinePlayer, key) -> {
            Optional<PlayerData> optional = this.getPlayer(offlinePlayer.getUniqueId());
            if (optional.isEmpty()) {
                return "true";
            }
            PlayerData playerData = optional.get();
            Optional<Data> optionalData = playerData.getData((String)key);
            return optionalData.map(data -> String.valueOf(data.isExpired())).orElse("true");
        });
    }

    private String handlePlaceholder(OfflinePlayer offlinePlayer, String key, ReturnConsumer<Data, String> consumer) {
        Optional<PlayerData> optional = this.getPlayer(offlinePlayer.getUniqueId());
        if (optional.isEmpty()) {
            return this.getDefaultKey(key);
        }
        PlayerData playerData = optional.get();
        Optional<Data> optionalData = playerData.getData(key);
        return optionalData.isPresent() ? consumer.accept(optionalData.get()) : this.getDefaultKey(key);
    }

    private String getDefaultKey(String key) {
        return this.defaultValues.containsKey(key) ? this.defaultValues.get(key) : "Key '" + key + "' doesn't exist for this player";
    }

    @Override
    public void convertOldDatas(CommandSender sender) {
        StorageManager manager = this.plugin.getStorageManager();
        try {
            Map<UUID, List<Data>> datas = PlayerDataLoader.loadPlayerData(String.valueOf(this.plugin.getDataFolder()) + "/players.json");
            datas.forEach((uuid, playerData) -> playerData.forEach(data -> manager.upsertData((UUID)uuid, (Data)data)));
            this.plugin.getLogger().info("Loaded " + datas.size() + " players.");
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

