/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.players.inventory;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.players.inventory.InventoriesPlayer;
import fr.maxlego08.menu.api.players.inventory.InventoryPlayer;
import fr.maxlego08.menu.api.storage.dto.InventoryDTO;
import fr.maxlego08.menu.players.inventory.ZInventoryPlayer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class ZInventoriesPlayer
implements InventoriesPlayer {
    private final Map<UUID, InventoryPlayer> inventories = new HashMap<UUID, InventoryPlayer>();
    private final ZMenuPlugin plugin;
    private long lastSave;

    public ZInventoriesPlayer(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void storeInventory(Player player) {
        if (this.hasSavedInventory(player.getUniqueId())) {
            return;
        }
        ZInventoryPlayer inventoryPlayer = new ZInventoryPlayer(this.plugin);
        inventoryPlayer.storeInventory(player);
        this.inventories.put(player.getUniqueId(), inventoryPlayer);
        this.plugin.getStorageManager().storeInventory(player.getUniqueId(), inventoryPlayer);
    }

    private void restoreInventory(Player player, BiConsumer<InventoryPlayer, Player> restoreAction) {
        Optional<InventoryPlayer> optional = this.getPlayerInventory(player.getUniqueId());
        if (optional.isPresent()) {
            InventoryPlayer inventoryPlayer = optional.get();
            restoreAction.accept(inventoryPlayer, player);
            this.inventories.remove(player.getUniqueId());
            this.plugin.getStorageManager().removeInventory(player.getUniqueId());
        }
    }

    @Override
    public void giveInventory(Player player) {
        this.restoreInventory(player, InventoryPlayer::giveInventory);
    }

    @Override
    public void forceGiveInventory(Player player) {
        this.restoreInventory(player, InventoryPlayer::forceGiveInventory);
    }

    @Override
    public boolean hasSavedInventory(UUID uniqueId) {
        return this.inventories.containsKey(uniqueId);
    }

    @Override
    public Optional<InventoryPlayer> getPlayerInventory(UUID uniqueId) {
        return Optional.ofNullable(this.inventories.getOrDefault(uniqueId, null));
    }

    @Override
    public List<ItemStack> getInventory(UUID uniqueId) {
        Optional<InventoryPlayer> optional = this.getPlayerInventory(uniqueId);
        if (optional.isPresent()) {
            InventoryPlayer inventoryPlayer = optional.get();
            return inventoryPlayer.getItemStacks();
        }
        return Collections.emptyList();
    }

    @Override
    public void clearInventorie(UUID uniqueId) {
        this.inventories.remove(uniqueId);
        this.plugin.getStorageManager().removeInventory(uniqueId);
    }

    @EventHandler
    public void onDisconnect(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.hasSavedInventory(player.getUniqueId())) {
            this.forceGiveInventory(player);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.hasSavedInventory(player.getUniqueId())) {
            this.giveInventory(player);
        }
    }

    @Override
    public void loadInventories() {
        HashMap<UUID, ZInventoryPlayer> loadedInventories = new HashMap<UUID, ZInventoryPlayer>();
        for (InventoryDTO inventory : this.plugin.getStorageManager().loadInventories()) {
            String[] serializedItems;
            ZInventoryPlayer inventoryPlayer = new ZInventoryPlayer(this.plugin);
            for (String serializedItem : serializedItems = inventory.inventory().split(";")) {
                String[] parts = serializedItem.split(":");
                if (parts.length != 2 || parts[0].isEmpty() || parts[1].isEmpty()) continue;
                try {
                    int slot = Integer.parseInt(parts[0]);
                    inventoryPlayer.getItems().put(slot, parts[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            loadedInventories.put(inventory.player_id(), inventoryPlayer);
        }
        this.inventories.putAll(loadedInventories);
    }
}

