/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.players.inventory;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.players.inventory.InventoryPlayer;
import fr.maxlego08.menu.zcore.utils.nms.ItemStackUtils;
import fr.maxlego08.menu.zcore.utils.nms.NMSUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ZInventoryPlayer
implements InventoryPlayer {
    private final int MAX_INVENTORY_SIZE = 36;
    private final Map<Integer, String> items = new HashMap<Integer, String>();
    private final ZMenuPlugin plugin;

    public ZInventoryPlayer(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void storeInventory(Player player) {
        PlayerInventory playerInventory = player.getInventory();
        ItemStack[] content = playerInventory.getContents();
        for (int slot = 0; slot != 36; ++slot) {
            this.clear(slot, playerInventory, content);
        }
        if (!NMSUtils.isOneHand()) {
            this.clear(40, playerInventory, content);
        }
    }

    private void clear(int slot, PlayerInventory playerInventory, ItemStack[] content) {
        ItemStack itemStack = content[slot];
        if (itemStack != null) {
            this.items.put(slot, ItemStackUtils.serializeItemStack(itemStack));
        }
        playerInventory.clear(slot);
    }

    @Override
    public void giveInventory(Player player) {
        PlayerInventory playerInventory = player.getInventory();
        this.items.forEach((slot, encodedItemStack) -> playerInventory.setItem(slot.intValue(), ItemStackUtils.deserializeItemStack(encodedItemStack)));
    }

    @Override
    public void forceGiveInventory(Player player) {
        PlayerInventory playerInventory = player.getInventory();
        for (int slot = 0; slot <= 36; ++slot) {
            if (this.items.containsKey(slot)) {
                playerInventory.setItem(slot, ItemStackUtils.deserializeItemStack(this.items.get(slot)));
                continue;
            }
            if (!this.plugin.getDupeManager().isDupeItem(playerInventory.getItem(slot))) continue;
            playerInventory.setItem(slot, null);
        }
    }

    @Override
    public void setItems(Map<Integer, ItemStack> items) {
        HashMap<Integer, String> encodedItems = new HashMap<Integer, String>();
        for (Map.Entry<Integer, ItemStack> entry : items.entrySet()) {
            encodedItems.put(entry.getKey(), ItemStackUtils.serializeItemStack(entry.getValue()));
        }
        this.setItemsFromEncode(encodedItems);
    }

    @Override
    public void setItemsFromEncode(Map<Integer, String> items) {
        this.items.clear();
        this.items.putAll(items);
    }

    @Override
    public void setItems(List<ItemStack> items) {
        this.items.clear();
        for (int slot = 0; slot != Math.min(items.size(), 36); ++slot) {
            ItemStack itemStack = items.get(slot);
            if (itemStack == null) continue;
            this.items.put(slot, ItemStackUtils.serializeItemStack(itemStack));
        }
    }

    @Override
    public String toInventoryString() {
        StringBuilder builder = new StringBuilder();
        this.items.forEach((slot, itemStack) -> builder.append(slot).append(":").append((String)itemStack).append(";"));
        String result = builder.toString();
        return result.isEmpty() ? result : result.substring(0, result.length() - 1);
    }

    @Override
    public List<ItemStack> getItemStacks() {
        ArrayList<ItemStack> deserialized = new ArrayList<ItemStack>(this.items.size());
        for (String encoded : this.items.values()) {
            deserialized.add(ItemStackUtils.deserializeItemStack(encoded));
        }
        return deserialized;
    }

    @Override
    public Map<Integer, String> getItems() {
        return this.items;
    }
}

