/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.requirement;

import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.requirement.Permissible;
import fr.maxlego08.menu.api.requirement.RefreshRequirement;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.List;
import org.bukkit.entity.Player;

public class ZRefreshRequirement
implements RefreshRequirement {
    private final List<Permissible> enablePermissibles;
    private final List<Permissible> permissibles;
    private final boolean isTask;
    private final boolean isRefreshLore;
    private final boolean isRefreshName;
    private final boolean isRefreshButton;
    private final int updateInterval;

    public ZRefreshRequirement(List<Permissible> enablePermissibles, List<Permissible> permissibles, boolean isTask, boolean isRefreshLore, boolean isRefreshName, boolean isRefreshButton, int updateInterval) {
        this.enablePermissibles = enablePermissibles;
        this.permissibles = permissibles;
        this.isTask = isTask;
        this.isRefreshLore = isRefreshLore;
        this.isRefreshName = isRefreshName;
        this.isRefreshButton = isRefreshButton;
        this.updateInterval = updateInterval;
    }

    @Override
    public List<Permissible> getRequirements() {
        return this.permissibles;
    }

    @Override
    public List<Permissible> getEnableRequirements() {
        return this.enablePermissibles;
    }

    @Override
    public boolean isTask() {
        return this.isTask;
    }

    @Override
    public boolean isRefreshLore() {
        return this.isRefreshLore;
    }

    @Override
    public boolean isRefreshName() {
        return this.isRefreshName;
    }

    @Override
    public boolean isRefreshButton() {
        return this.isRefreshButton;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public boolean needRefresh(Player player, Button button, InventoryEngine inventory, Placeholders placeholders) {
        for (Permissible permissible : this.enablePermissibles) {
            if (permissible.hasPermission(player, button, inventory, placeholders)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canRefresh(Player player, Button button, InventoryEngine inventory, Placeholders placeholders) {
        for (Permissible permissible : this.permissibles) {
            if (permissible.hasPermission(player, button, inventory, placeholders)) continue;
            return false;
        }
        return true;
    }
}

