/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.requirement.checker;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.checker.InventoryLoadRequirement;
import fr.maxlego08.menu.api.checker.InventoryRequirementType;
import fr.maxlego08.menu.api.loader.ButtonLoader;
import fr.maxlego08.menu.api.pattern.Pattern;
import fr.maxlego08.menu.requirement.checker.ConfigurationChecker;
import java.io.File;
import java.util.HashMap;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class InventoryRequirementChecker
extends ConfigurationChecker {
    public InventoryRequirementChecker(ZMenuPlugin plugin) {
        super(plugin);
    }

    public Optional<InventoryLoadRequirement> canLoadInventory(YamlConfiguration configuration, Plugin plugin, File file, Class<? extends Inventory> classz) {
        InventoryLoadRequirement inventoryLoadRequirement = new InventoryLoadRequirement(plugin, configuration, classz, file);
        this.checkPatterns(configuration, inventoryLoadRequirement);
        this.checkOpenRequirement(configuration, inventoryLoadRequirement);
        this.checkButtons(configuration, inventoryLoadRequirement);
        return inventoryLoadRequirement.canLoad() ? Optional.empty() : Optional.of(inventoryLoadRequirement);
    }

    private void checkPatterns(YamlConfiguration configuration, InventoryLoadRequirement inventoryLoadRequirement) {
        for (String patternName : configuration.getStringList("patterns")) {
            Optional<Pattern> optional = this.patternManager.getPattern(patternName);
            if (!optional.isEmpty()) continue;
            inventoryLoadRequirement.addRequirement(InventoryRequirementType.PATTERN, patternName);
        }
    }

    private void checkOpenRequirement(YamlConfiguration configuration, InventoryLoadRequirement inventoryLoadRequirement) {
        String openRequirementKey;
        String string = configuration.contains("open_requirement") ? "open_requirement" : (openRequirementKey = configuration.contains("open-requirement") ? "open-requirement" : null);
        if (openRequirementKey != null && configuration.contains(openRequirementKey) && configuration.isConfigurationSection(openRequirementKey + ".")) {
            this.checkRequirement(configuration, openRequirementKey + ".", inventoryLoadRequirement);
        }
    }

    private void checkButtons(YamlConfiguration configuration, InventoryLoadRequirement inventoryLoadRequirement) {
        ConfigurationSection section = configuration.getConfigurationSection("items.");
        if (section != null) {
            section.getKeys(false).forEach(buttonPath -> this.checkButton(configuration, inventoryLoadRequirement, "items." + buttonPath + "."));
        }
    }

    private void checkButton(YamlConfiguration configuration, InventoryLoadRequirement inventoryLoadRequirement, String path) {
        Optional<ButtonLoader> optional;
        String buttonType = configuration.getString(path + "type", "NONE");
        ConfigurationSection patternSection = configuration.getConfigurationSection(path + "pattern");
        if (patternSection != null) {
            File patternFile;
            ZMenuPlugin patternPlugin;
            HashMap<String, Object> mapPlaceholders = new HashMap<String, Object>();
            patternSection.getKeys(false).forEach(key -> mapPlaceholders.put((String)key, patternSection.get(key)));
            String fileName = configuration.getString(path + "pattern.fileName", configuration.getString(path + "pattern.file-name"));
            String pluginName = configuration.getString(path + "pattern.pluginName", configuration.getString(path + "pattern.plugin-name", null));
            ZMenuPlugin zMenuPlugin = patternPlugin = pluginName != null ? Bukkit.getPluginManager().getPlugin(pluginName) : this.plugin;
            if (patternPlugin != null && (patternFile = new File(patternPlugin.getDataFolder(), "patterns/" + fileName + ".yml")).exists()) {
                mapPlaceholders.putAll(this.plugin.getGlobalPlaceholders());
                YamlConfiguration patternConfiguration = this.loadAndReplaceConfiguration(patternFile, mapPlaceholders);
                this.checkButton(patternConfiguration, inventoryLoadRequirement, "button.");
                return;
            }
        }
        if ((optional = this.buttonManager.getLoader(buttonType)).isEmpty()) {
            inventoryLoadRequirement.addRequirement(InventoryRequirementType.BUTTON, buttonType);
        }
        this.checkAction(configuration, path + "actions", inventoryLoadRequirement);
        this.checkClickRequirements(configuration, inventoryLoadRequirement, path);
        this.checkViewRequirement(configuration, inventoryLoadRequirement, path);
        if (configuration.contains(path + "else")) {
            this.checkButton(configuration, inventoryLoadRequirement, path + "else.");
        }
    }

    private void checkClickRequirements(YamlConfiguration configuration, InventoryLoadRequirement inventoryLoadRequirement, String path) {
        String string;
        String[] sectionStrings = new String[]{"click_requirement.", "click-requirement.", "click_requirements.", "click-requirements.", "clicks_requirement.", "clicks-requirement.", "clicks_requirements.", "clicks-requirements."};
        ConfigurationSection section = null;
        String sectionString = "";
        String[] stringArray = sectionStrings;
        int n = stringArray.length;
        for (int i = 0; i < n && (section = configuration.getConfigurationSection(path + (sectionString = (string = stringArray[i])))) == null; ++i) {
        }
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            this.checkRequirement(configuration, path + sectionString + key + ".", inventoryLoadRequirement);
        }
    }

    private void checkViewRequirement(YamlConfiguration configuration, InventoryLoadRequirement inventoryLoadRequirement, String path) {
        String requirementPath;
        String string = configuration.isConfigurationSection(path + "view_requirement.") ? "view_requirement." : (requirementPath = configuration.isConfigurationSection(path + "view-requirement.") ? "view-requirement." : null);
        if (requirementPath == null) {
            return;
        }
        this.checkRequirement(configuration, path + requirementPath, inventoryLoadRequirement);
    }
}

