/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.requirement.permissible;

import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.permissible.CurrencyPermissible;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.hooks.currencies.Currencies;
import java.math.BigDecimal;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ZCurrencyPermissible
extends CurrencyPermissible {
    private final Currencies currencies;
    private final String amount;
    private final String economyName;

    public ZCurrencyPermissible(List<Action> denyActions, List<Action> successActions, Currencies currencies, String amount, String economyName) {
        super(denyActions, successActions);
        this.currencies = currencies;
        this.amount = amount;
        this.economyName = economyName;
    }

    @Override
    public String getAmount() {
        return this.amount;
    }

    @Override
    public Currencies getCurrency() {
        return this.currencies;
    }

    @Override
    public boolean hasPermission(Player player, Button button, InventoryEngine inventory, Placeholders placeholders) {
        String result = inventory.getPlugin().parse(player, placeholders.parse(this.amount));
        BigDecimal bigDecimal = new BigDecimal(result);
        BigDecimal amount = this.currencies.getBalance((OfflinePlayer)player, this.economyName == null ? "default" : this.economyName);
        return amount.compareTo(bigDecimal) >= 0;
    }

    @Override
    public boolean isValid() {
        return this.currencies != null && this.amount != null;
    }
}

