/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.requirement.permissible;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.enums.PlaceholderAction;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.permissible.PlaceholderPermissible;
import fr.maxlego08.menu.api.utils.OfflinePlayerCache;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.hooks.exp4j.ExpressionBuilder;
import fr.maxlego08.menu.zcore.logger.Logger;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ZPlaceholderPermissible
extends PlaceholderPermissible {
    private final PlaceholderAction action;
    private final String placeholder;
    private final String value;
    private final String targetPlayer;
    private final boolean enableMathExpression;

    public ZPlaceholderPermissible(PlaceholderAction action, String placeholder, String value, String targetPlayer, List<Action> denyActions, List<Action> successActions, boolean enableMathExpression) {
        super(denyActions, successActions);
        this.action = action;
        this.placeholder = placeholder;
        this.value = value;
        this.targetPlayer = targetPlayer;
        this.enableMathExpression = enableMathExpression;
    }

    @Override
    public boolean hasPermission(Player player, Button button, InventoryEngine inventoryEngine, Placeholders placeholders) {
        String resultAsString;
        String valueAsString;
        MenuPlugin plugin = inventoryEngine.getPlugin();
        if (this.targetPlayer == null || this.targetPlayer.equalsIgnoreCase("null")) {
            valueAsString = plugin.parse(player, placeholders.parse(this.placeholder));
            resultAsString = plugin.parse(player, placeholders.parse(this.value));
        } else {
            OfflinePlayer offlinePlayer = OfflinePlayerCache.get(plugin.parse(player, placeholders.parse(this.targetPlayer)));
            valueAsString = plugin.parse((OfflinePlayer)(offlinePlayer.hasPlayedBefore() ? offlinePlayer : player), placeholders.parse(this.placeholder));
            resultAsString = plugin.parse((OfflinePlayer)(offlinePlayer.hasPlayedBefore() ? offlinePlayer : player), placeholders.parse(this.value));
        }
        if (this.action.equals((Object)PlaceholderAction.BOOLEAN)) {
            try {
                return Boolean.valueOf(valueAsString) == Boolean.valueOf(resultAsString);
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.action.isString()) {
            return switch (this.action) {
                case PlaceholderAction.EQUALS_STRING -> valueAsString.equals(resultAsString);
                case PlaceholderAction.DIFFERENT_STRING -> {
                    if (!valueAsString.equals(resultAsString)) {
                        yield true;
                    }
                    yield false;
                }
                case PlaceholderAction.EQUALSIGNORECASE_STRING -> valueAsString.equalsIgnoreCase(resultAsString);
                case PlaceholderAction.CONTAINS_STRING -> valueAsString.contains(resultAsString);
                default -> false;
            };
        }
        try {
            double currentValue;
            double value;
            if (this.enableMathExpression) {
                value = new ExpressionBuilder(valueAsString).build().evaluate();
                currentValue = new ExpressionBuilder(resultAsString).build().evaluate();
            } else {
                value = Double.parseDouble(valueAsString.replace(",", "."));
                currentValue = Double.parseDouble(resultAsString.replace(",", "."));
            }
            return switch (this.action) {
                case PlaceholderAction.EQUAL_TO -> {
                    if (value == currentValue) {
                        yield true;
                    }
                    yield false;
                }
                case PlaceholderAction.LOWER -> {
                    if (value < currentValue) {
                        yield true;
                    }
                    yield false;
                }
                case PlaceholderAction.LOWER_OR_EQUAL -> {
                    if (value <= currentValue) {
                        yield true;
                    }
                    yield false;
                }
                case PlaceholderAction.SUPERIOR -> {
                    if (value > currentValue) {
                        yield true;
                    }
                    yield false;
                }
                case PlaceholderAction.SUPERIOR_OR_EQUAL -> {
                    if (value >= currentValue) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }
        catch (Exception exception) {
            if (Config.enableDebug) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public PlaceholderAction getPlaceholderAction() {
        return this.action;
    }

    @Override
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isValid() {
        if (this.value == null) {
            Logger.info("Value is null !", Logger.LogType.WARNING);
        }
        if (this.action == null) {
            Logger.info("Action is null !", Logger.LogType.WARNING);
        }
        if (this.placeholder == null) {
            Logger.info("Placeholder is null !", Logger.LogType.WARNING);
        }
        return this.value != null && this.action != null && this.placeholder != null;
    }
}

