/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.website;

import fr.maxlego08.menu.zcore.utils.ElapsedTime;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class DownloadFile
extends ZUtils {
    public void download(Plugin plugin, CommandSender sender, String link) {
        String fileName = this.generateRandomString(5);
        File folder = this.getFolder(plugin);
        File output = new File(folder, fileName + ".zip");
        ElapsedTime downloadTime = new ElapsedTime("download");
        downloadTime.start();
        try {
            int bytesRead;
            URL url = new URL(link);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(output);
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            fileOutputStream.close();
            downloadTime.endDisplay(true);
            sender.sendMessage("\u00a7fT\u00e9l\u00e9chargement termin\u00e9. Unzip en cours.");
            ElapsedTime unzipFile = new ElapsedTime("unzip");
            unzipFile.start();
            File folderOutput = new File(folder, fileName);
            folderOutput.mkdir();
            this.unzipFolder(output.toPath(), folderOutput.toPath());
            unzipFile.endDisplay(true);
            sender.sendMessage("\u00a7fUnzip termin\u00e9.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getFolder(Plugin plugin) {
        File folder = new File(plugin.getDataFolder(), "download");
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    public void unzipFolder(Path source, Path target) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(source.toFile().toPath(), new OpenOption[0]));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = zipEntry.getName().endsWith(File.separator) || zipEntry.getName().endsWith("/");
                Path newPath = this.zipSlipProtect(zipEntry, target);
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }
}

