/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerSkin {
    private static final Map<String, String> textures = new HashMap<String, String>();
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private static Field valueField;
    private static Field signatureField;
    private static String gameProfileMethodName;

    public static String getTexture(Player player) {
        if (textures.containsKey(player.getName())) {
            return textures.get(player.getName());
        }
        String[] textures = PlayerSkin.getFromPlayer(player);
        try {
            String texture = textures[0];
            PlayerSkin.textures.put(player.getName(), texture);
            return texture;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTexture(String name) {
        if (textures.containsKey(name)) {
            return textures.get(name);
        }
        Player player = Bukkit.getPlayer((String)name);
        if (player != null) {
            return PlayerSkin.getTexture(player);
        }
        pool.execute(() -> {
            String[] textures = PlayerSkin.getFromName(name);
            try {
                String texture = textures[0];
                textures.put(name, texture);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return null;
    }

    public static String[] getFromPlayer(Player playerBukkit) {
        GameProfile profile = PlayerSkin.getProfile(playerBukkit);
        if (profile.getProperties().get((Object)"textures").iterator().hasNext()) {
            Property property = (Property)profile.getProperties().get((Object)"textures").iterator().next();
            try {
                String texture = (String)valueField.get(property);
                String signature = (String)signatureField.get(property);
                return new String[]{texture, signature};
            }
            catch (Exception exception) {
                String texture = property.getValue();
                String signature = property.getSignature();
                return new String[]{texture, signature};
            }
        }
        return PlayerSkin.getFromName(playerBukkit.getName());
    }

    public static String[] getFromName(String name) {
        try {
            URL url_0 = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
            InputStreamReader reader_0 = new InputStreamReader(url_0.openStream());
            String uuid = new JsonParser().parse((Reader)reader_0).getAsJsonObject().get("id").getAsString();
            URL url_1 = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            InputStreamReader reader_1 = new InputStreamReader(url_1.openStream());
            JsonObject textureProperty = new JsonParser().parse((Reader)reader_1).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
            String texture = textureProperty.get("value").getAsString();
            String signature = textureProperty.get("signature").getAsString();
            return new String[]{texture, signature};
        }
        catch (IOException e) {
            return null;
        }
    }

    public static GameProfile getProfile(Player player) {
        try {
            Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            return (GameProfile)entityPlayer.getClass().getMethod(PlayerSkin.getMethodName(entityPlayer), new Class[0]).invoke(entityPlayer, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public static String getMethodName(Object entityPlayer) {
        if (gameProfileMethodName == null) {
            for (Method method : entityPlayer.getClass().getMethods()) {
                if (method.getParameterCount() != 0 || !method.getReturnType().toString().contains("com.mojang.authlib.GameProfile")) continue;
                gameProfileMethodName = method.getName();
            }
        }
        return gameProfileMethodName != null ? gameProfileMethodName : "getProfile";
    }

    static {
        try {
            valueField = Property.class.getDeclaredField("value");
            signatureField = Property.class.getDeclaredField("signature");
            valueField.setAccessible(true);
            signatureField.setAccessible(true);
        }
        catch (NoSuchFieldException exception) {
            exception.printStackTrace();
        }
    }
}

