/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.attribute;

import fr.maxlego08.menu.api.attribute.IAttribute;
import fr.maxlego08.menu.hooks.nbtapi.NBT;
import fr.maxlego08.menu.hooks.nbtapi.iface.ReadWriteNBT;
import fr.maxlego08.menu.hooks.nbtapi.iface.ReadWriteNBTCompoundList;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class AttributeApplier {
    private final List<IAttribute> attributes;

    public AttributeApplier(List<IAttribute> attributes) {
        this.attributes = attributes;
    }

    public void apply(ItemStack itemStack) {
        if (this.attributes.isEmpty()) {
            return;
        }
        NBT.modify(itemStack, nbt -> {
            ReadWriteNBTCompoundList attributeModifiers = nbt.getCompoundList("AttributeModifiers");
            for (IAttribute attribute : this.attributes) {
                ReadWriteNBT compound = attributeModifiers.addCompound();
                compound.setString("Name", attribute.getName());
                compound.setUUID("UUID", attribute.getUuid());
                compound.setString("AttributeName", "minecraft:" + attribute.getType().getKey());
                compound.setDouble("Amount", attribute.getAmount());
                if (attribute.getSlot() == null) continue;
                compound.setString("Slot", attribute.getSlot().name().toLowerCase());
            }
        });
    }
}

