/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.builder;

import fr.maxlego08.menu.api.utils.Message;

public class TimerBuilder {
    private static final long SECOND = 1L;
    private static final long MINUTE = 60L;
    private static final long HOUR = 3600L;
    private static final long DAY = 86400L;
    private static final long MONTH = 2592000L;
    private static final long YEAR = 31536000L;

    public static String getStringTime(long second) {
        if (second < 60L) {
            return TimerBuilder.getFormatLongSecondes(second * 1000L);
        }
        if (second < 3600L) {
            return TimerBuilder.getFormatLongMinutes(second * 1000L);
        }
        if (second < 86400L) {
            return TimerBuilder.getFormatLongHours(second * 1000L);
        }
        if (second < 2592000L) {
            return TimerBuilder.getFormatLongDays(second * 1000L);
        }
        if (second < 31536000L) {
            return TimerBuilder.getFormatLongMonths(second * 1000L);
        }
        return TimerBuilder.getFormatLongYears(second * 1000L);
    }

    public static String getFormatLongYears(long millis) {
        long totalSecs = millis / 1000L;
        long years = totalSecs / 31536000L;
        long months = totalSecs % 31536000L / 2592000L;
        long days = totalSecs % 2592000L / 86400L;
        long hours = totalSecs % 86400L / 3600L;
        long minutes = totalSecs % 3600L / 60L;
        long seconds = totalSecs % 60L;
        String msg = Message.TIME_YEAR.msg();
        msg = msg.replace("%second%", (seconds <= 1L ? Message.FORMAT_SECOND : Message.FORMAT_SECONDS).msg());
        msg = msg.replace("%minute%", (minutes <= 1L ? Message.FORMAT_MINUTE : Message.FORMAT_MINUTES).msg());
        msg = msg.replace("%hour%", (hours <= 1L ? Message.FORMAT_HOUR : Message.FORMAT_HOURS).msg());
        msg = msg.replace("%day%", (days <= 1L ? Message.FORMAT_DAY : Message.FORMAT_DAYS).msg());
        msg = msg.replace("%month%", (months <= 1L ? Message.FORMAT_MONTH : Message.FORMAT_MONTHS).msg());
        msg = msg.replace("%year%", (years <= 1L ? Message.FORMAT_YEAR : Message.FORMAT_YEARS).msg());
        return TimerBuilder.format(String.format(msg, years, months, days, hours, minutes, seconds));
    }

    public static String getFormatLongMonths(long millis) {
        long totalSecs = millis / 1000L;
        long months = totalSecs / 2592000L;
        long days = totalSecs % 2592000L / 86400L;
        long hours = totalSecs % 86400L / 3600L;
        long minutes = totalSecs % 3600L / 60L;
        long seconds = totalSecs % 60L;
        String msg = Message.TIME_MONTH.msg();
        msg = msg.replace("%second%", (seconds <= 1L ? Message.FORMAT_SECOND : Message.FORMAT_SECONDS).msg());
        msg = msg.replace("%minute%", (minutes <= 1L ? Message.FORMAT_MINUTE : Message.FORMAT_MINUTES).msg());
        msg = msg.replace("%hour%", (hours <= 1L ? Message.FORMAT_HOUR : Message.FORMAT_HOURS).msg());
        msg = msg.replace("%day%", (days <= 1L ? Message.FORMAT_DAY : Message.FORMAT_DAYS).msg());
        msg = msg.replace("%month%", (months <= 1L ? Message.FORMAT_MONTH : Message.FORMAT_MONTHS).msg());
        return TimerBuilder.format(String.format(msg, months, days, hours, minutes, seconds));
    }

    public static String getFormatLongDays(long millis) {
        long totalSecs = millis / 1000L;
        long days = totalSecs / 86400L;
        long hours = totalSecs % 86400L / 3600L;
        long minutes = totalSecs % 3600L / 60L;
        long seconds = totalSecs % 60L;
        String msg = Message.TIME_DAY.msg();
        msg = msg.replace("%second%", (seconds <= 1L ? Message.FORMAT_SECOND : Message.FORMAT_SECONDS).msg());
        msg = msg.replace("%minute%", (minutes <= 1L ? Message.FORMAT_MINUTE : Message.FORMAT_MINUTES).msg());
        msg = msg.replace("%hour%", (hours <= 1L ? Message.FORMAT_HOUR : Message.FORMAT_HOURS).msg());
        msg = msg.replace("%day%", (days <= 1L ? Message.FORMAT_DAY : Message.FORMAT_DAYS).msg());
        return TimerBuilder.format(String.format(msg, days, hours, minutes, seconds));
    }

    public static String getFormatLongHours(long millis) {
        long totalSecs = millis / 1000L;
        long hours = totalSecs / 3600L;
        long minutes = totalSecs % 3600L / 60L;
        long seconds = totalSecs % 60L;
        String msg = Message.TIME_HOUR.msg();
        msg = msg.replace("%second%", (seconds <= 1L ? Message.FORMAT_SECOND : Message.FORMAT_SECONDS).msg());
        msg = msg.replace("%minute%", (minutes <= 1L ? Message.FORMAT_MINUTE : Message.FORMAT_MINUTES).msg());
        msg = msg.replace("%hour%", (hours <= 1L ? Message.FORMAT_HOUR : Message.FORMAT_HOURS).msg());
        return TimerBuilder.format(String.format(msg, hours, minutes, seconds));
    }

    public static String getFormatLongMinutes(long millis) {
        long totalSecs = millis / 1000L;
        long minutes = totalSecs % 3600L / 60L;
        long seconds = totalSecs % 60L;
        String msg = Message.TIME_MINUTE.msg();
        msg = msg.replace("%second%", (seconds <= 1L ? Message.FORMAT_SECOND : Message.FORMAT_SECONDS).msg());
        msg = msg.replace("%minute%", (minutes <= 1L ? Message.FORMAT_MINUTE : Message.FORMAT_MINUTES).msg());
        return TimerBuilder.format(String.format(msg, minutes, seconds));
    }

    public static String getFormatLongSecondes(long millis) {
        long totalSecs = millis / 1000L;
        long seconds = totalSecs % 60L;
        String msg = Message.TIME_SECOND.msg();
        msg = msg.replace("%second%", (seconds <= 1L ? Message.FORMAT_SECOND : Message.FORMAT_SECONDS).msg());
        return TimerBuilder.format(String.format(msg, seconds));
    }

    public static String format(String message) {
        message = message.replace(" 00 " + Message.FORMAT_SECOND.msg(), "");
        message = message.replace(" 00 " + Message.FORMAT_MINUTE.msg(), "");
        message = message.replace(" 00 " + Message.FORMAT_HOUR.msg(), "");
        message = message.replace(" 00 " + Message.FORMAT_DAY.msg(), "");
        message = message.replace(" 00 " + Message.FORMAT_MONTH.msg(), "");
        message = message.replace(" 00 " + Message.FORMAT_YEAR.msg(), "");
        return message.trim();
    }
}

