/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.discord;

import fr.maxlego08.menu.zcore.utils.discord.DiscordWebhookComponent;
import fr.maxlego08.menu.zcore.utils.discord.ReturnConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public record DiscordConfigurationComponent(String webhookUrl, String avatarUrl, String username, List<?> json) {
    public void apply(ReturnConsumer<String, String> consumer, DiscordWebhookComponent discordWebhook) {
        if (this.username != null) {
            discordWebhook.setUsername(consumer.accept(this.username));
        }
        if (this.avatarUrl != null) {
            discordWebhook.setAvatarUrl(consumer.accept(this.avatarUrl));
        }
        if (this.json != null) {
            Object parsed = this.parseRecursively(this.json, consumer);
            if (parsed instanceof List) {
                discordWebhook.setJson((List)parsed);
            } else {
                discordWebhook.setJson(Collections.emptyList());
            }
        }
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public List<?> getJson() {
        return this.json;
    }

    private Object parseRecursively(Object obj, ReturnConsumer<String, String> consumer) {
        if (obj instanceof String) {
            return consumer.accept((String)obj);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object item : list) {
                newList.add(this.parseRecursively(item, consumer));
            }
            return newList;
        }
        if (obj instanceof Map) {
            HashMap map = new HashMap();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                map.put(entry.getKey(), this.parseRecursively(entry.getValue(), consumer));
            }
            return map;
        }
        return obj;
    }
}

