/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import fr.maxlego08.menu.zcore.ZPlugin;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectAdapter
extends TypeAdapter<PotionEffect> {
    private static final Type seriType = new TypeToken<Map<String, Object>>(){}.getType();
    private static final String TYPE = "effect";
    private static final String DURATION = "duration";
    private static final String AMPLIFIER = "amplifier";
    private static final String AMBIENT = "ambient";
    private final ZPlugin plugin;

    public PotionEffectAdapter(ZPlugin plugin) {
        this.plugin = plugin;
    }

    public void write(JsonWriter jsonWriter, PotionEffect potionEffect) throws IOException {
        if (potionEffect == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.value(this.getRaw(potionEffect));
    }

    public PotionEffect read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return this.fromRaw(jsonReader.nextString());
    }

    private String getRaw(PotionEffect potion) {
        Map serial = potion.serialize();
        return this.plugin.getGson().toJson((Object)serial);
    }

    private PotionEffect fromRaw(String raw) {
        Map keys = (Map)this.plugin.getGson().fromJson(raw, seriType);
        return new PotionEffect(PotionEffectType.getById((int)((Double)keys.get(TYPE)).intValue()), ((Double)keys.get(DURATION)).intValue(), ((Double)keys.get(AMPLIFIER)).intValue(), ((Boolean)keys.get(AMBIENT)).booleanValue());
    }
}

