/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.loader;

import fr.maxlego08.menu.api.exceptions.ItemEnchantException;
import fr.maxlego08.menu.api.exceptions.ItemFlagException;
import fr.maxlego08.menu.api.itemstack.Potion;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionType;

public class ItemStackLoader
extends ZUtils
implements Loader<ItemStack> {
    @Override
    public ItemStack load(YamlConfiguration configuration, String path, Object ... objects) {
        List flags;
        String displayName;
        int data = configuration.getInt(path + "data", 0);
        int amount = configuration.getInt(path + "amount", 1);
        short durability = (short)configuration.getInt(path + "durability", 0);
        int modelID = configuration.getInt(path + "modelID", configuration.getInt(path + "model-id", 0));
        Material material = null;
        int value = configuration.getInt(path + "material", 0);
        if (value != 0) {
            material = this.getMaterial(value);
        }
        if (material == null) {
            String str = configuration.getString(path + "material", null);
            if (str == null) {
                return null;
            }
            material = Material.getMaterial((String)str.toUpperCase());
        }
        if (modelID < 0) {
            modelID = 0;
        }
        ItemStack item = null;
        if (material == null || material.equals((Object)Material.AIR)) {
            return null;
        }
        item = new ItemStack(material, amount, (short)((byte)data));
        if (configuration.contains(path + "url")) {
            item = this.createSkull(configuration.getString(path + "url"));
        } else if (configuration.contains(path + "potion")) {
            PotionType type = PotionType.valueOf((String)configuration.getString(path + "potion", "REGEN").toUpperCase());
            int level = configuration.getInt(path + "level", 1);
            boolean splash = configuration.getBoolean(path + "splash", false);
            boolean extended = configuration.getBoolean(path + "extended", false);
            boolean arrow = configuration.getBoolean(path + "arrow", false);
            item = new Potion(type, level, splash, extended, arrow).toItemStack(amount);
        }
        if (item == null) {
            return null;
        }
        if (durability != 0) {
            item.setDurability(durability);
        }
        ItemMeta meta = item.getItemMeta();
        List tmpLore = configuration.getStringList(path + "lore");
        if (!tmpLore.isEmpty()) {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            lore.addAll(this.color(tmpLore));
            meta.setLore(lore);
        }
        if ((displayName = configuration.getString(path + "name", null)) != null) {
            meta.setDisplayName(this.color(displayName));
        }
        List enchants = configuration.getStringList(path + "enchants");
        boolean isGlowing = configuration.getBoolean(path + "glow");
        if (modelID > 0) {
            meta.setCustomModelData(Integer.valueOf(modelID));
        }
        if (!enchants.isEmpty()) {
            for (String enchantString : enchants) {
                try {
                    String[] splitEnchant = enchantString.split(",");
                    if (splitEnchant.length == 1) {
                        throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString);
                    }
                    int level = 0;
                    String enchant = splitEnchant[0];
                    try {
                        level = Integer.parseInt(splitEnchant[1]);
                    }
                    catch (NumberFormatException e) {
                        throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString);
                    }
                    Enchantment enchantment = Enchantment.getByName((String)enchant);
                    if (enchantment == null) {
                        throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString);
                    }
                    if (material.equals((Object)Material.ENCHANTED_BOOK)) {
                        ((EnchantmentStorageMeta)meta).addStoredEnchant(enchantment, level, true);
                        continue;
                    }
                    meta.addEnchant(enchantment, level, true);
                }
                catch (ItemEnchantException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(flags = configuration.getStringList(path + "flags")).isEmpty()) {
            for (String flagString : flags) {
                try {
                    ItemFlag flag = this.getFlag(flagString);
                    if (flag == null) {
                        throw new ItemFlagException("an error occurred while loading the flag " + flagString);
                    }
                    meta.addItemFlags(new ItemFlag[]{flag});
                }
                catch (ItemFlagException e) {
                    e.printStackTrace();
                }
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public void save(ItemStack item, YamlConfiguration configuration, String path, File file, Object ... objects) {
        ItemMeta meta;
        if (item == null) {
            Logger.info("Impossible de sauvegarder l'item car il est null ! Le path: " + path, Logger.LogType.ERROR);
            return;
        }
        configuration.set(path + "material", (Object)item.getType().name());
        if (item.getAmount() != 1) {
            configuration.set(path + "amount", (Object)item.getAmount());
        }
        if (NmsVersion.getCurrentVersion().isItemLegacy()) {
            if (item.getData().getData() != 0) {
                configuration.set(path + "data", (Object)item.getData().getData());
            }
            if (item.getDurability() != 0) {
                configuration.set(path + "durability", (Object)item.getDurability());
            }
        }
        if ((meta = item.getItemMeta()) != null) {
            ArrayList enchantList;
            if (meta.hasDisplayName()) {
                configuration.set(path + "name", (Object)this.colorReverse(meta.getDisplayName()));
            }
            if (meta.hasLore()) {
                configuration.set(path + "lore", this.colorReverse(Objects.requireNonNull(meta.getLore())));
            }
            if (!meta.getItemFlags().isEmpty()) {
                ArrayList<String> flags = new ArrayList<String>(meta.getItemFlags().size());
                for (ItemFlag flag : meta.getItemFlags()) {
                    flags.add(flag.name());
                }
                configuration.set(path + "flags", flags);
            }
            if (meta.hasEnchants()) {
                enchantList = new ArrayList();
                meta.getEnchants().forEach((enchant, level) -> enchantList.add(enchant.getName() + "," + level));
                configuration.set(path + "enchants", enchantList);
            }
            if (meta instanceof EnchantmentStorageMeta && ((EnchantmentStorageMeta)meta).hasStoredEnchants()) {
                enchantList = new ArrayList();
                ((EnchantmentStorageMeta)meta).getStoredEnchants().forEach((enchant, level) -> enchantList.add(enchant.getName() + "," + level));
                configuration.set(path + "enchants", enchantList);
            }
            if (NmsVersion.getCurrentVersion().isCustomModelData() && meta.hasCustomModelData()) {
                configuration.set(path + "model-id", (Object)meta.getCustomModelData());
            }
        }
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

