/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.toast;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.toast.ToastType;
import fr.maxlego08.menu.hooks.folialib.impl.PlatformScheduler;
import fr.maxlego08.menu.zcore.utils.toast.utils.ColorParser;
import fr.maxlego08.menu.zcore.utils.toast.versions.ServerVersion;
import fr.maxlego08.menu.zcore.utils.toast.versions.VersionType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class AdvancementHandler {
    private final MenuPlugin plugin;

    AdvancementHandler(@NotNull MenuPlugin plugin) {
        this.plugin = plugin;
    }

    void showToast(Collection<? extends Player> players, String icon, String message, ToastType style, Object modelData, String modelDataType, boolean glowing) {
        if (players.isEmpty()) {
            return;
        }
        NamespacedKey advancementKey = this.createAdvancement(icon, message, style, modelData, modelDataType, glowing);
        PlatformScheduler scheduler = this.plugin.getScheduler();
        for (Player player : players) {
            scheduler.runLater(() -> {
                this.grantAdvancement(p, advancementKey);
                scheduler.runLater(() -> this.revokeAdvancement(p, advancementKey), 10L);
            }, 1L);
        }
        scheduler.runLater(() -> Bukkit.getUnsafe().removeAdvancement(advancementKey), 40L);
    }

    void showToastToAll(String icon, String message, ToastType style, Object modelData, String modelDataType, boolean glowing) {
        this.showToast(Bukkit.getOnlinePlayers(), icon, message, style, modelData, modelDataType, glowing);
    }

    @NotNull
    private NamespacedKey legacyType(String icon, String message, ToastType style, Object modelData, boolean glowing, NamespacedKey advancementKey) {
        int modelDataInt = 0;
        if (modelData instanceof Integer) {
            modelDataInt = (Integer)modelData;
        } else if (modelData instanceof Float) {
            modelDataInt = ((Float)modelData).intValue();
        } else if (modelData instanceof String) {
            try {
                modelDataInt = Integer.parseInt(modelData.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String json = "{\n \"criteria\": {\n \"trigger\": {\n \"trigger\": \"minecraft:impossible\"\n }\n },\n \"display\": {\n \"icon\": {\n \"item\": \"minecraft:" + icon + "\",\n \"nbt\": \"{CustomModelData:" + modelDataInt + (glowing ? ",Enchantments:[{lvl:1,id:\\\"minecraft:protection\\\"}]" : "") + "}\"\n },\n \"title\": " + message + ",\n \"description\": {\n \"text\": \"\"\n },\n \"background\": \"minecraft:textures/gui/advancements/backgrounds/adventure.png\",\n \"frame\": \"" + style.toString().toLowerCase() + "\",\n \"announce_to_chat\": false,\n \"show_toast\": true,\n \"hidden\": true\n }\n}";
        Bukkit.getUnsafe().loadAdvancement(advancementKey, json);
        return advancementKey;
    }

    @NotNull
    private NamespacedKey middleType(String icon, String message, ToastType style, Object modelData, boolean glowing, NamespacedKey advancementKey) {
        int modelDataInt = 0;
        if (modelData instanceof Integer) {
            modelDataInt = (Integer)modelData;
        } else if (modelData instanceof Float) {
            modelDataInt = ((Float)modelData).intValue();
        } else if (modelData instanceof String) {
            try {
                modelDataInt = Integer.parseInt(modelData.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String json = "{\n \"criteria\": {\n   \"trigger\": {\n     \"trigger\": \"minecraft:impossible\"\n   }\n },\n \"display\": {\n   \"icon\": {\n     \"id\": \"minecraft:" + icon + "\",\n     \"components\": {\n       \"minecraft:custom_model_data\": " + modelDataInt + (glowing ? ",\n       \"minecraft:enchantments\": {\n         \"levels\": {\n           \"minecraft:protection\": 1\n         }\n       }" : "") + "\n     },\n     \"count\": 1\n   },\n   \"title\": " + message + ",\n   \"description\": {\n     \"text\": \"\"\n   },\n   \"background\": \"minecraft:textures/gui/advancements/backgrounds/adventure.png\",\n   \"frame\": \"" + style.toString().toLowerCase() + "\",\n   \"announce_to_chat\": false,\n   \"show_toast\": true,\n   \"hidden\": true\n }\n}";
        Bukkit.getUnsafe().loadAdvancement(advancementKey, json);
        return advancementKey;
    }

    @NotNull
    private NamespacedKey modernType(String icon, String message, ToastType style, Object modelData, String modelDataType, boolean glowing, NamespacedKey advancementKey) {
        if (modelDataType == null) {
            modelDataType = modelData instanceof String ? "string" : (modelData instanceof Float || modelData instanceof Double ? "float" : "integer");
        }
        String customModelData = "float".equals(modelDataType) || "integer".equals(modelDataType) ? "\"minecraft:custom_model_data\": {\n \"floats\": [" + String.valueOf(modelData) + "]\n }" : "\"minecraft:custom_model_data\": {\n \"strings\": [\n \"" + String.valueOf(modelData) + "\"\n ]\n }";
        String json = "{\n \"criteria\": {\n \"trigger\": {\n \"trigger\": \"minecraft:impossible\"\n }\n },\n \"display\": {\n \"icon\": {\n \"id\": \"minecraft:" + icon + "\",\n \"components\": {\n " + customModelData + (glowing ? ",\n \"minecraft:enchantments\": {\n \"minecraft:protection\": 1\n }" : "") + "\n },\n \"count\": 1\n },\n \"title\": " + message + ",\n \"description\": {\n \"text\": \"\"\n },\n \"background\": \"minecraft:textures/gui/advancements/backgrounds/adventure.png\",\n \"frame\": \"" + style.toString().toLowerCase() + "\",\n \"announce_to_chat\": false,\n \"show_toast\": true,\n \"hidden\": true\n }\n}";
        Bukkit.getUnsafe().loadAdvancement(advancementKey, json);
        return advancementKey;
    }

    @NotNull
    private NamespacedKey createAdvancement(String icon, String message, ToastType style, Object modelData, String modelDataType, boolean glowing) {
        String serverVersion = this.plugin.getServer().getVersion();
        List<Map<String, Object>> msgList = ColorParser.process(message);
        String json = ColorParser.formatToJsonString(msgList);
        json = json.replace("|", "\n");
        icon = icon.toLowerCase().replace("\u0130", "I").replace("\u0131", "i");
        UUID randomUUID = UUID.randomUUID();
        NamespacedKey advancementKey = new NamespacedKey((Plugin)this.plugin, "anelib_" + String.valueOf(randomUUID));
        VersionType versionType = ServerVersion.getVersionType(serverVersion);
        return switch (versionType) {
            case VersionType.LEGACY -> {
                if (modelData == null) {
                    modelData = 0;
                }
                yield this.legacyType(icon, json, style, modelData, glowing, advancementKey);
            }
            case VersionType.MIDDLE -> {
                if (modelData == null) {
                    modelData = 0;
                }
                yield this.middleType(icon, json, style, modelData, glowing, advancementKey);
            }
            default -> {
                if (modelData == null) {
                    modelData = "anemys";
                    modelDataType = "string";
                }
                yield this.modernType(icon, json, style, modelData, modelDataType, glowing, advancementKey);
            }
        };
    }

    private void grantAdvancement(Player p, NamespacedKey advancementKey) {
        p.getAdvancementProgress(Objects.requireNonNull(Bukkit.getAdvancement((NamespacedKey)advancementKey))).awardCriteria("trigger");
    }

    private void revokeAdvancement(Player p, NamespacedKey advancementKey) {
        p.getAdvancementProgress(Objects.requireNonNull(Bukkit.getAdvancement((NamespacedKey)advancementKey))).revokeCriteria("trigger");
    }
}

