/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.toast;

import fr.maxlego08.menu.api.utils.toast.ToastType;
import fr.maxlego08.menu.zcore.utils.toast.AdvancementHandler;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.entity.Player;

public class ToastBuilder {
    private final AdvancementHandler advancementHandler;
    private String icon = "paper";
    private String message = "Toast Message";
    private ToastType style = ToastType.TASK;
    private Object modelData;
    private Boolean glowing = false;
    private Collection<? extends Player> players;
    private boolean isToAll = false;
    private String modelDataType = null;

    ToastBuilder(AdvancementHandler advancementHandler) {
        this.advancementHandler = advancementHandler;
    }

    public ToastBuilder to(Collection<? extends Player> players) {
        this.players = players;
        this.isToAll = false;
        return this;
    }

    public ToastBuilder to(Player ... players) {
        this.players = Arrays.asList(players);
        this.isToAll = false;
        return this;
    }

    public ToastBuilder toAll() {
        this.isToAll = true;
        return this;
    }

    public ToastBuilder withIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public ToastBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    public ToastBuilder withStyle(ToastType style) {
        this.style = style;
        return this;
    }

    public ToastBuilder setGlowing(boolean glowing) {
        this.glowing = glowing;
        return this;
    }

    public ToastBuilder withModelData(Object modelData) {
        this.modelData = modelData;
        this.modelDataType = modelData instanceof String ? "string" : (modelData instanceof Float || modelData instanceof Double ? "float" : "integer");
        return this;
    }

    public ToastBuilder withModelData(Object modelData, String modelDataType) {
        this.modelData = modelData;
        this.modelDataType = modelDataType;
        return this;
    }

    public void show() {
        if (this.isToAll) {
            this.advancementHandler.showToastToAll(this.icon, this.message, this.style, this.modelData, this.modelDataType, this.glowing);
        } else {
            if (this.players == null || this.players.isEmpty()) {
                throw new IllegalStateException("[ERROR TOAST POP-UP] No player found!");
            }
            this.advancementHandler.showToast(this.players, this.icon, this.message, this.style, this.modelData, this.modelDataType, this.glowing);
        }
    }
}

