/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.zcore.utils.toast.utils;

import fr.maxlego08.menu.zcore.utils.toast.utils.ColorCode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ColorParser {
    private static final Pattern pattern = Pattern.compile("(#[0-9a-fA-F]{6})|(\u00a7[0-9a-fk-or])|(&[0-9a-fk-or])|([^\u00a7&#]+)");

    public static List<Map<String, Object>> process(String input) {
        input = ChatColor.translateAlternateColorCodes((char)'&', (String)input);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Matcher matcher = pattern.matcher(input);
        String color = null;
        HashSet<String> formats = new HashSet<String>();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            String formatCode = matcher.group(2);
            String text = matcher.group(4);
            if (hexColor != null) {
                color = hexColor;
                continue;
            }
            if (formatCode != null) {
                char code = formatCode.charAt(1);
                if (code == 'r') {
                    color = null;
                    formats.clear();
                    continue;
                }
                if ("0123456789abcdef".indexOf(code) != -1) {
                    color = ColorCode.getColorName(code);
                    continue;
                }
                formats.add(String.valueOf(code));
                continue;
            }
            if (text == null) continue;
            LinkedHashMap<String, Object> part = new LinkedHashMap<String, Object>();
            part.put("text", text);
            if (color != null) {
                part.put("color", color);
            }
            Iterator iterator = formats.iterator();
            while (iterator.hasNext()) {
                String f;
                switch (f = (String)iterator.next()) {
                    case "l": {
                        part.put("bold", true);
                        break;
                    }
                    case "o": {
                        part.put("italic", true);
                        break;
                    }
                    case "n": {
                        part.put("underlined", true);
                        break;
                    }
                    case "m": {
                        part.put("strikethrough", true);
                        break;
                    }
                    case "k": {
                        part.put("obfuscated", true);
                    }
                }
            }
            result.add(part);
        }
        return result;
    }

    public static String formatToJsonString(List<Map<String, Object>> msgList) {
        StringBuilder msgJson = new StringBuilder("[");
        for (int i = 0; i < msgList.size(); ++i) {
            msgJson.append(ColorParser.mapToJson(msgList.get(i)));
            if (i >= msgList.size() - 1) continue;
            msgJson.append(", ");
        }
        msgJson.append("]");
        return msgJson.toString();
    }

    private static String mapToJson(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder("{");
        int i = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\":");
            if (entry.getValue() instanceof String) {
                sb.append("\"").append(entry.getValue()).append("\"");
            } else {
                sb.append(entry.getValue());
            }
            if (i < map.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

