/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.checker.InventoryRequirementType;
import fr.maxlego08.menu.api.exceptions.ButtonAlreadyRegisterException;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.loader.ActionLoader;
import fr.maxlego08.menu.api.loader.ButtonLoader;
import fr.maxlego08.menu.api.loader.PermissibleLoader;
import fr.maxlego08.menu.api.requirement.Action;
import fr.maxlego08.menu.api.requirement.Permissible;
import fr.maxlego08.menu.api.requirement.Requirement;
import fr.maxlego08.menu.api.utils.Loader;
import fr.maxlego08.menu.api.utils.TypedMapAccessor;
import fr.maxlego08.menu.loader.RequirementLoader;
import fr.maxlego08.menu.loader.ZButtonLoader;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ZButtonManager
extends ZUtils
implements ButtonManager {
    private final ZMenuPlugin plugin;
    private final Map<String, List<ButtonLoader>> loaders = new HashMap<String, List<ButtonLoader>>();
    private final Map<String, PermissibleLoader> permissibles = new HashMap<String, PermissibleLoader>();
    private final Map<String, ActionLoader> actionsLoader = new HashMap<String, ActionLoader>();

    public ZButtonManager(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void register(ButtonLoader button) {
        ButtonLoader existingLoader = null;
        for (List<ButtonLoader> list : this.loaders.values()) {
            for (ButtonLoader loader : list) {
                if (!loader.getName().equalsIgnoreCase(button.getName())) continue;
                existingLoader = loader;
                break;
            }
            if (existingLoader == null) continue;
            break;
        }
        if (existingLoader != null) {
            ButtonLoader loader = existingLoader;
            throw new ButtonAlreadyRegisterException("Button " + button.getName() + " was already register in the " + loader.getPlugin().getName());
        }
        Plugin plugin = button.getPlugin();
        List list = this.loaders.getOrDefault(plugin.getName(), new ArrayList());
        list.add(button);
        this.loaders.put(plugin.getName(), list);
        this.plugin.getInventoryManager().loadElement(InventoryRequirementType.BUTTON, button.getName());
    }

    @Override
    public void unregister(ButtonLoader button) {
        String pluginName = button.getPlugin().getName();
        List buttonLoaders = this.loaders.getOrDefault(pluginName, new ArrayList());
        buttonLoaders.remove(button);
        this.loaders.put(pluginName, buttonLoaders);
    }

    @Override
    public void unregisters(Plugin plugin) {
        this.loaders.remove(plugin.getName());
    }

    @Override
    public Collection<ButtonLoader> getLoaders() {
        ArrayList<ButtonLoader> flattened = new ArrayList<ButtonLoader>();
        for (List<ButtonLoader> buttonLoaders : this.loaders.values()) {
            flattened.addAll(buttonLoaders);
        }
        return flattened;
    }

    @Override
    public Collection<ButtonLoader> getLoaders(Plugin plugin) {
        return this.loaders.getOrDefault(plugin.getName(), new ArrayList());
    }

    @Override
    public Optional<ButtonLoader> getLoader(String name) {
        for (ButtonLoader loader : this.getLoaders()) {
            if (!loader.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(loader);
        }
        return Optional.empty();
    }

    @Override
    public void registerPermissible(PermissibleLoader permissibleLoader) {
        this.permissibles.put(permissibleLoader.getKey().toLowerCase(), permissibleLoader);
        this.plugin.getInventoryManager().loadElement(InventoryRequirementType.PERMISSIBLE, permissibleLoader.getKey());
    }

    @Override
    public Map<String, PermissibleLoader> getPermissibles() {
        return this.permissibles;
    }

    @Override
    public Optional<PermissibleLoader> getPermission(String key) {
        return Optional.ofNullable(this.permissibles.getOrDefault(key.toLowerCase(), null));
    }

    @Override
    public void registerAction(ActionLoader actionLoader) {
        for (String value : actionLoader.getKeys()) {
            this.actionsLoader.put(value, actionLoader);
            this.plugin.getInventoryManager().loadElement(InventoryRequirementType.ACTION, value);
        }
    }

    @Override
    public Optional<ActionLoader> getActionLoader(String key) {
        return Optional.ofNullable(this.actionsLoader.getOrDefault(key.toLowerCase(), null));
    }

    @Override
    public List<Permissible> loadPermissible(List<Map<String, Object>> elements, String path, File file) {
        ArrayList<Permissible> permissibles = new ArrayList<Permissible>();
        for (Map<String, Object> map : elements) {
            Optional<PermissibleLoader> optional;
            Permissible permissible = null;
            String type = map.getOrDefault("type", null);
            if (type != null && (optional = this.getPermission(type)).isPresent()) {
                PermissibleLoader permissibleLoader = optional.get();
                permissible = permissibleLoader.load(path, new TypedMapAccessor(map), file);
            }
            if (permissible != null && permissible.isValid()) {
                permissibles.add(permissible);
                continue;
            }
            Logger.info("Error, an element is invalid in " + path + " for permissible", Logger.LogType.ERROR);
        }
        return permissibles;
    }

    @Override
    public List<Permissible> loadPermissible(YamlConfiguration configuration, String path, File file) {
        List elements = configuration.getList(path, new ArrayList());
        return this.loadPermissible(elements, path, file);
    }

    @Override
    public List<Action> loadActions(List<Map<String, Object>> elements, String path, File file) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Map<String, Object> map : elements) {
            String type = map.getOrDefault("type", null);
            if (type == null) {
                Logger.info("Error, an element is invalid in " + path + ", type is invalid", Logger.LogType.ERROR);
                continue;
            }
            Optional<ActionLoader> optional = this.getActionLoader(type);
            if (optional.isPresent()) {
                TypedMapAccessor accessor;
                ActionLoader actionLoader = optional.get();
                Action action = actionLoader.load(path, accessor = new TypedMapAccessor(map), file);
                if (action == null) continue;
                action.setDelay(accessor.getInt("delay", 0));
                action.setChance(accessor.getFloat("chance", 100.0f));
                actions.add(action);
                continue;
            }
            Logger.info("Error, an element is invalid in " + path + " with type " + type + ", he doesn't exist!", Logger.LogType.ERROR);
        }
        return actions;
    }

    @Override
    public List<Action> loadActions(YamlConfiguration configuration, String path, File file) {
        List elements = configuration.getList(path, new ArrayList());
        return this.loadActions(elements, path, file);
    }

    @Override
    public List<Requirement> loadRequirements(YamlConfiguration configuration, String path, File file) throws InventoryException {
        if (configuration == null) {
            return List.of();
        }
        ConfigurationSection section = configuration.getConfigurationSection(path);
        if (section == null) {
            return List.of();
        }
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (String key : section.getKeys(false)) {
            requirements.add(this.loadRequirement(configuration, path + "." + key + ".", file));
        }
        return requirements;
    }

    @Override
    public Requirement loadRequirement(YamlConfiguration configuration, String path, File file) throws InventoryException {
        RequirementLoader requirementLoader = new RequirementLoader(this.plugin);
        return (Requirement)requirementLoader.load(configuration, path, file);
    }

    @Override
    public List<String> getEmptyActions(List<Map<String, Object>> elements) {
        ArrayList<String> invalid = new ArrayList<String>();
        for (Map<String, Object> element : elements) {
            String type;
            Object typeObj = element.get("type");
            if (!(typeObj instanceof String) || !this.getActionLoader(type = (String)typeObj).isEmpty()) continue;
            invalid.add(type);
        }
        return invalid;
    }

    @Override
    public List<String> getEmptyPermissible(List<Map<String, Object>> elements) {
        ArrayList<String> invalid = new ArrayList<String>();
        for (Map<String, Object> element : elements) {
            String type;
            Object typeObj = element.get("type");
            if (!(typeObj instanceof String) || !this.getPermission(type = (String)typeObj).isEmpty()) continue;
            invalid.add(type);
        }
        return invalid;
    }

    @Override
    public Loader<Button> getLoaderButton(MenuPlugin menuPlugin, File file, int size, Map<Character, List<Integer>> matrix) {
        return new ZButtonLoader(menuPlugin, file, size, matrix);
    }
}

