/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.button.PaginateButton;
import fr.maxlego08.menu.api.button.SlotButton;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.engine.InventoryResult;
import fr.maxlego08.menu.api.pattern.Pattern;
import fr.maxlego08.menu.api.players.inventory.InventoriesPlayer;
import fr.maxlego08.menu.api.requirement.ConditionalName;
import fr.maxlego08.menu.api.requirement.Requirement;
import fr.maxlego08.menu.api.utils.CompatibilityUtil;
import fr.maxlego08.menu.api.utils.OpenWithItem;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.inventory.inventories.InventoryDefault;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ZInventory
extends ZUtils
implements Inventory {
    private final Plugin plugin;
    private final String name;
    private final String fileName;
    private final int size;
    private final List<Button> buttons;
    private final List<ConditionalName> conditionalNames = new ArrayList<ConditionalName>();
    private Map<String, String> translatedNames = new HashMap<String, String>();
    private List<Pattern> patterns = new ArrayList<Pattern>();
    private MenuItemStack fillItemStack;
    private int updateInterval;
    private File file;
    private boolean clearInventory;
    private boolean ItemPickupDisabled;
    private Requirement openRequirement;
    private OpenWithItem openWithItem;
    private InventoryType type = InventoryType.CHEST;
    private String targetPlayerNamePlaceholder;

    public ZInventory(Plugin plugin, String name, String fileName, int size, List<Button> buttons) {
        this.plugin = plugin;
        this.name = name;
        this.fileName = fileName;
        this.size = size;
        this.buttons = buttons;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(Player player, InventoryEngine inventoryDefault, Placeholders placeholders) {
        String locale;
        if (!this.conditionalNames.isEmpty()) {
            ConditionalName selected = null;
            int highestPriority = Integer.MIN_VALUE;
            for (ConditionalName conditionalName : this.conditionalNames) {
                if (!conditionalName.hasPermission(player, null, inventoryDefault, placeholders) || selected != null && conditionalName.priority() <= highestPriority) continue;
                selected = conditionalName;
                highestPriority = conditionalName.priority();
            }
            if (selected != null) {
                return selected.name();
            }
        }
        return (locale = this.findPlayerLocale(player)) == null ? this.name : this.translatedNames.getOrDefault(locale, this.name);
    }

    @Override
    public InventoryType getType() {
        return this.type;
    }

    public void setType(InventoryType type) {
        this.type = type;
    }

    @Override
    public boolean shouldCancelItemPickup() {
        return this.ItemPickupDisabled;
    }

    public void setCancelItemPickup(boolean ItemPickupDisabled) {
        this.ItemPickupDisabled = ItemPickupDisabled;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public Collection<Button> getButtons() {
        return Collections.unmodifiableCollection(this.buttons);
    }

    @Override
    public <T extends Button> List<T> getButtons(Class<T> type) {
        ArrayList<Button> filtered = new ArrayList<Button>();
        for (Button button : this.getButtons()) {
            if (!type.isAssignableFrom(button.getClass())) continue;
            filtered.add((Button)type.cast(button));
        }
        return filtered;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public int getMaxPage(Collection<Pattern> patterns, Player player, Object ... objects) {
        int slotsSize;
        ArrayList<Button> buttons = new ArrayList<Button>(this.buttons);
        patterns.forEach(pattern -> buttons.addAll(pattern.buttons()));
        int maxSlotInventory = -1;
        for (Button button : buttons) {
            if (button.isPlayerInventory()) continue;
            maxSlotInventory = Math.max(maxSlotInventory, button.getSlot());
        }
        int maxPageInventory = maxSlotInventory >= 0 ? maxSlotInventory / this.size + 1 : 1;
        int maxSlotPlayerInventory = -1;
        for (Button button : buttons) {
            if (!button.isPlayerInventory()) continue;
            maxSlotPlayerInventory = Math.max(maxSlotPlayerInventory, button.getSlot());
        }
        int maxPagePlayerInventory = maxSlotPlayerInventory >= 0 ? maxSlotPlayerInventory / 36 + 1 : 1;
        int maxPageFinal = Math.max(maxPageInventory, maxPagePlayerInventory);
        SlotButton selected = null;
        int maxPaginationSize = Integer.MIN_VALUE;
        for (Button button : buttons) {
            if (!(button instanceof PaginateButton)) continue;
            PaginateButton paginateButton = (PaginateButton)button;
            int paginationSize = paginateButton.getPaginationSize(player);
            if (selected != null && paginationSize <= maxPaginationSize) continue;
            selected = paginateButton;
            maxPaginationSize = paginationSize;
        }
        if (selected != null && (slotsSize = selected.getSlots().size()) > 0) {
            int calculated = (int)Math.ceil((double)maxPaginationSize / (double)slotsSize);
            return Math.max(maxPageFinal, calculated);
        }
        return maxPageFinal;
    }

    @Override
    public List<Button> sortButtons(int page, Object ... objects) {
        ArrayList<Button> sorted = new ArrayList<Button>();
        Iterator<Button> iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            Button button;
            int size = (button = iterator.next()).isPlayerInventory() ? 36 : this.size;
            int slot = button.getRealSlot(size, page);
            if (slot < 0 || slot >= size) continue;
            sorted.add(button);
        }
        return sorted;
    }

    @Override
    public List<Button> sortPatterns(Pattern pattern, int page, Object ... objects) {
        if (!pattern.enableMultiPage()) {
            return new ArrayList<Button>(pattern.buttons());
        }
        ArrayList<Button> sorted = new ArrayList<Button>();
        for (Button button : pattern.buttons()) {
            int slot = button.getRealSlot(this.size, page);
            if (slot < 0 || slot >= this.size) continue;
            sorted.add(button);
        }
        return sorted;
    }

    @Override
    public InventoryResult openInventory(Player player, InventoryEngine inventoryDefault) {
        if (this.openRequirement != null && !this.openRequirement.execute(player, null, inventoryDefault, new Placeholders())) {
            return InventoryResult.PERMISSION;
        }
        InventoriesPlayer inventoriesPlayer = inventoryDefault.getPlugin().getInventoriesPlayer();
        InventoryHolder holder = CompatibilityUtil.getTopInventory(player).getHolder();
        if (holder instanceof InventoryDefault) {
            InventoryDefault inventoryHolder = (InventoryDefault)holder;
            this.clearPlayerInventoryButtons(player, inventoryHolder);
            if (inventoryHolder.getMenuInventory().cleanInventory() && !this.clearInventory) {
                inventoriesPlayer.giveInventory(player);
            } else if (this.clearInventory) {
                inventoriesPlayer.storeInventory(player);
            }
        } else if (this.clearInventory) {
            inventoriesPlayer.storeInventory(player);
        }
        return InventoryResult.SUCCESS;
    }

    private void clearPlayerInventoryButtons(Player player, InventoryEngine inventoryDefault) {
        for (Button button : inventoryDefault.getButtons()) {
            if (!button.isPlayerInventory()) continue;
            for (int slot : button.getSlots()) {
                if (slot < 0 || slot > 36) continue;
                player.getInventory().setItem(slot, new ItemStack(Material.AIR));
            }
        }
    }

    @Override
    public void postOpenInventory(Player player, InventoryEngine inventoryDefault) {
    }

    @Override
    public void closeInventory(Player player, InventoryEngine inventoryDefault) {
        ZMenuPlugin.getInstance().getScheduler().runAtEntityLater((Entity)player, task -> {
            InventoryHolder newHolder = CompatibilityUtil.getTopInventory(player).getHolder();
            if (newHolder != null && !(newHolder instanceof InventoryDefault)) {
                this.clearPlayerInventoryButtons(player, inventoryDefault);
                if (this.clearInventory) {
                    InventoriesPlayer inventoriesPlayer = inventoryDefault.getPlugin().getInventoriesPlayer();
                    inventoriesPlayer.giveInventory(player);
                }
            }
        }, 1L);
    }

    @Override
    public MenuItemStack getFillItemStack() {
        return this.fillItemStack;
    }

    public void setFillItemStack(MenuItemStack fillItemStack) {
        this.fillItemStack = fillItemStack;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public boolean cleanInventory() {
        return this.clearInventory;
    }

    @Override
    public Requirement getOpenRequirement() {
        return this.openRequirement;
    }

    public void setOpenRequirement(Requirement openRequirement) {
        this.openRequirement = openRequirement;
    }

    @Override
    public OpenWithItem getOpenWithItem() {
        return this.openWithItem;
    }

    public void setOpenWithItem(OpenWithItem openWithItem) {
        this.openWithItem = openWithItem;
    }

    @Override
    public Map<String, String> getTranslatedNames() {
        return this.translatedNames;
    }

    public void setTranslatedNames(Map<String, String> translatedNames) {
        this.translatedNames = translatedNames;
    }

    @Override
    public List<ConditionalName> getConditionalNames() {
        return this.conditionalNames;
    }

    public void setClearInventory(boolean clearInventory) {
        this.clearInventory = clearInventory;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public String getTargetPlayerNamePlaceholder() {
        return this.targetPlayerNamePlaceholder;
    }

    public void setTargetPlayerNamePlaceholder(String targetPlaceholder) {
        this.targetPlayerNamePlaceholder = targetPlaceholder;
    }
}

