/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu;

import fr.maxlego08.menu.ZInventory;
import fr.maxlego08.menu.ZMenuItemStack;
import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.DialogManager;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.InventoryListener;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.InventoryOption;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.button.ButtonOption;
import fr.maxlego08.menu.api.checker.InventoryLoadRequirement;
import fr.maxlego08.menu.api.checker.InventoryRequirementType;
import fr.maxlego08.menu.api.command.CommandManager;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.enchantment.Enchantments;
import fr.maxlego08.menu.api.event.FastEvent;
import fr.maxlego08.menu.api.event.events.ButtonLoaderRegisterEvent;
import fr.maxlego08.menu.api.event.events.InventoryLoadEvent;
import fr.maxlego08.menu.api.event.events.PlayerOpenInventoryEvent;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.exceptions.InventoryFileNotFound;
import fr.maxlego08.menu.api.font.FontImage;
import fr.maxlego08.menu.api.itemstack.ItemStackSimilar;
import fr.maxlego08.menu.api.loader.MaterialLoader;
import fr.maxlego08.menu.api.loader.NoneLoader;
import fr.maxlego08.menu.api.utils.CompatibilityUtil;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.api.utils.MetaUpdater;
import fr.maxlego08.menu.api.utils.OfflinePlayerCache;
import fr.maxlego08.menu.api.utils.OpenWithItem;
import fr.maxlego08.menu.button.buttons.ZNoneButton;
import fr.maxlego08.menu.button.loader.BackLoader;
import fr.maxlego08.menu.button.loader.HomeLoader;
import fr.maxlego08.menu.button.loader.JumpLoader;
import fr.maxlego08.menu.button.loader.MainMenuLoader;
import fr.maxlego08.menu.button.loader.NextLoader;
import fr.maxlego08.menu.button.loader.PreviousLoader;
import fr.maxlego08.menu.button.loader.SwitchLoader;
import fr.maxlego08.menu.command.validators.BooleanArgumentValidator;
import fr.maxlego08.menu.command.validators.DoubleArgumentValidator;
import fr.maxlego08.menu.command.validators.EntityTypeArgumentValidator;
import fr.maxlego08.menu.command.validators.IntArgumentValidator;
import fr.maxlego08.menu.command.validators.LocationArgumentValidator;
import fr.maxlego08.menu.command.validators.MaterialArgumentValidator;
import fr.maxlego08.menu.command.validators.OnlinePlayerArgumentValidator;
import fr.maxlego08.menu.command.validators.PlayerArgumentValidator;
import fr.maxlego08.menu.command.validators.WorldArgumentValidator;
import fr.maxlego08.menu.hooks.dialogs.loader.body.ItemBodyLoader;
import fr.maxlego08.menu.hooks.dialogs.loader.body.PlainMessageBodyLoader;
import fr.maxlego08.menu.hooks.dialogs.loader.input.BooleanInputLoader;
import fr.maxlego08.menu.hooks.dialogs.loader.input.NumberRangeInputLoader;
import fr.maxlego08.menu.hooks.dialogs.loader.input.SingleOptionInputLoader;
import fr.maxlego08.menu.hooks.dialogs.loader.input.TextInputLoader;
import fr.maxlego08.menu.hooks.folialib.impl.PlatformScheduler;
import fr.maxlego08.menu.inventory.inventories.InventoryDefault;
import fr.maxlego08.menu.itemstack.FullSimilar;
import fr.maxlego08.menu.itemstack.ItemModelSimilar;
import fr.maxlego08.menu.itemstack.LoreSimilar;
import fr.maxlego08.menu.itemstack.MaterialSimilar;
import fr.maxlego08.menu.itemstack.ModelIdSimilar;
import fr.maxlego08.menu.itemstack.NameSimilar;
import fr.maxlego08.menu.loader.MenuItemStackLoader;
import fr.maxlego08.menu.loader.actions.ActionBarLoader;
import fr.maxlego08.menu.loader.actions.BookLoader;
import fr.maxlego08.menu.loader.actions.BroadcastLoader;
import fr.maxlego08.menu.loader.actions.BroadcastSoundLoader;
import fr.maxlego08.menu.loader.actions.ChatLoader;
import fr.maxlego08.menu.loader.actions.CloseLoader;
import fr.maxlego08.menu.loader.actions.ConnectLoader;
import fr.maxlego08.menu.loader.actions.ConsoleCommandLoader;
import fr.maxlego08.menu.loader.actions.CurrencyDepositLoader;
import fr.maxlego08.menu.loader.actions.CurrencyWithdrawLoader;
import fr.maxlego08.menu.loader.actions.DataLoader;
import fr.maxlego08.menu.loader.actions.DialogLoader;
import fr.maxlego08.menu.loader.actions.DiscordComponentV2Loader;
import fr.maxlego08.menu.loader.actions.DiscordLoader;
import fr.maxlego08.menu.loader.actions.InventoryLoader;
import fr.maxlego08.menu.loader.actions.LuckPermissionSetLoader;
import fr.maxlego08.menu.loader.actions.MessageLoader;
import fr.maxlego08.menu.loader.actions.PlayerCommandAsOPLoader;
import fr.maxlego08.menu.loader.actions.PlayerCommandLoader;
import fr.maxlego08.menu.loader.actions.RefreshInventoryLoader;
import fr.maxlego08.menu.loader.actions.RefreshLoader;
import fr.maxlego08.menu.loader.actions.ShopkeeperLoader;
import fr.maxlego08.menu.loader.actions.SoundLoader;
import fr.maxlego08.menu.loader.actions.TeleportLoader;
import fr.maxlego08.menu.loader.actions.TitleLoader;
import fr.maxlego08.menu.loader.actions.ToastLoader;
import fr.maxlego08.menu.loader.deluxemenu.InventoryDeluxeMenuLoader;
import fr.maxlego08.menu.loader.permissible.CuboidPermissibleLoader;
import fr.maxlego08.menu.loader.permissible.CurrencyPermissibleLoader;
import fr.maxlego08.menu.loader.permissible.ItemPermissibleLoader;
import fr.maxlego08.menu.loader.permissible.JobPermissibleLoader;
import fr.maxlego08.menu.loader.permissible.LuckPermPermissibleLoader;
import fr.maxlego08.menu.loader.permissible.PermissionPermissibleLoader;
import fr.maxlego08.menu.loader.permissible.PlaceholderPermissibleLoader;
import fr.maxlego08.menu.loader.permissible.PlayerNamePermissibleLoader;
import fr.maxlego08.menu.loader.permissible.RegexPermissibleLoader;
import fr.maxlego08.menu.requirement.checker.InventoryRequirementChecker;
import fr.maxlego08.menu.zcore.enums.EnumInventory;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.PlayerSkin;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.itemstack.MenuItemStackFormMap;
import fr.maxlego08.menu.zcore.utils.nms.ItemStackUtils;
import fr.maxlego08.menu.zcore.utils.nms.NMSUtils;
import fr.maxlego08.menu.zcore.utils.plugins.Plugins;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;

public class ZInventoryManager
extends ZUtils
implements InventoryManager {
    private final Map<String, List<Inventory>> inventories = new HashMap<String, List<Inventory>>();
    private final Map<Plugin, List<Class<? extends ButtonOption>>> buttonOptions = new HashMap<Plugin, List<Class<? extends ButtonOption>>>();
    private final Map<Plugin, List<Class<? extends InventoryOption>>> inventoryOptions = new HashMap<Plugin, List<Class<? extends InventoryOption>>>();
    private final List<InventoryListener> inventoryListeners = new ArrayList<InventoryListener>();
    private final List<MaterialLoader> loaders = new ArrayList<MaterialLoader>();
    private final ZMenuPlugin plugin;
    private final Map<UUID, Inventory> currentInventories = new HashMap<UUID, Inventory>();
    private final Map<Plugin, FastEvent> fastEventMap = new HashMap<Plugin, FastEvent>();
    private final Map<String, ItemStackSimilar> itemStackSimilarMap = new HashMap<String, ItemStackSimilar>();
    private final Map<UUID, Integer> playerPages = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> playerMaxPages = new HashMap<UUID, Integer>();
    private final List<InventoryLoadRequirement> inventoryLoadRequirements = new ArrayList<InventoryLoadRequirement>();

    public ZInventoryManager(ZMenuPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadButtons();
        this.plugin.getPatternManager().loadPatterns();
        this.loadInventories();
        DialogManager dialogManager = this.plugin.getDialogManager();
        if (dialogManager != null) {
            dialogManager.loadDialogs();
        }
        this.startOfflineTask(this.plugin.getConfig().getInt("cache-offline-player", 300));
    }

    private void startOfflineTask(int seconds) {
        if (seconds <= 0) {
            return;
        }
        this.plugin.getScheduler().runTimerAsync(OfflinePlayerCache::clearCache, (long)seconds, (long)seconds, TimeUnit.SECONDS);
    }

    @Override
    public MenuPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public MenuItemStack loadItemStack(YamlConfiguration configuration, String path, File file) {
        return new MenuItemStackLoader(this).load(configuration, path, file);
    }

    @Override
    public MenuItemStack loadItemStack(File file, String path, Map<String, Object> map) {
        return MenuItemStackFormMap.fromMap(this, file, path, map);
    }

    @Override
    public Inventory loadInventory(Plugin plugin, File file) throws InventoryException {
        return this.loadInventory(plugin, file, ZInventory.class);
    }

    @Override
    public Inventory loadInventory(Plugin plugin, String fileName) throws InventoryException {
        return this.loadInventory(plugin, fileName, ZInventory.class);
    }

    @Override
    public Inventory loadInventory(Plugin plugin, String fileName, Class<? extends Inventory> classz) throws InventoryException {
        File file = new File(plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            throw new InventoryFileNotFound("Cannot find " + plugin.getDataFolder().getAbsolutePath() + "/" + fileName);
        }
        return this.loadInventory(plugin, file, classz);
    }

    @Override
    public Inventory loadInventory(Plugin plugin, File file, Class<? extends Inventory> classz) throws InventoryException {
        YamlConfiguration configuration = this.loadAndReplaceConfiguration(file, this.plugin.getGlobalPlaceholders());
        boolean enableInventoryLoad = configuration.getBoolean("enable", true);
        if (!enableInventoryLoad) {
            if (Config.enableInformationMessage) {
                Logger.info("The inventory " + file.getPath() + " is disabled, so it will not be loaded.", Logger.LogType.WARNING);
            }
            return null;
        }
        InventoryRequirementChecker checker = new InventoryRequirementChecker(this.plugin);
        Optional<InventoryLoadRequirement> optional = checker.canLoadInventory(configuration, plugin, file, classz);
        if (optional.isPresent()) {
            if (Config.enableInformationMessage) {
                Logger.info("Cannot load inventory " + file.getPath() + ", inventory is waiting.", Logger.LogType.WARNING);
                InventoryLoadRequirement inventoryLoadRequirement = optional.get();
                plugin.getLogger().info("Inventory load requirement: " + inventoryLoadRequirement.getDisplayError());
            }
            this.inventoryLoadRequirements.add(optional.get());
            return null;
        }
        boolean isDeluxeMenu = configuration.contains("menu_title");
        ZUtils loader = isDeluxeMenu ? new InventoryDeluxeMenuLoader(this.plugin) : new fr.maxlego08.menu.loader.InventoryLoader(this.plugin);
        Inventory inventory = (Inventory)loader.load(configuration, "", file, classz, plugin);
        List inventories = this.inventories.getOrDefault(plugin.getName(), new ArrayList());
        inventories.add(inventory);
        this.inventories.put(plugin.getName(), inventories);
        if (Config.enableInformationMessage) {
            Logger.info(file.getPath() + " loaded successfully !", Logger.LogType.INFO);
        }
        InventoryLoadEvent inventoryLoadEvent = new InventoryLoadEvent(plugin, file, inventory);
        if (Config.enableFastEvent) {
            this.getFastEvents().forEach(event -> event.onInventoryLoad(inventoryLoadEvent));
        } else {
            inventoryLoadEvent.call();
        }
        return inventory;
    }

    @Override
    public Optional<Plugin> getPluginIgnoreCase(String pluginName) {
        if (pluginName == null) {
            return Optional.empty();
        }
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (!plugin.getName().equalsIgnoreCase(pluginName)) continue;
            return Optional.of(plugin);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Inventory> getInventory(String name) {
        if (name == null) {
            return Optional.empty();
        }
        for (Inventory inventory : this.getInventories()) {
            if (!inventory.getFileName().equalsIgnoreCase(name)) continue;
            return Optional.of(inventory);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Inventory> getInventory(Plugin plugin, String name) {
        if (name == null) {
            return Optional.empty();
        }
        for (Inventory inventory : this.getInventories(plugin)) {
            if (!inventory.getFileName().equalsIgnoreCase(name)) continue;
            return Optional.of(inventory);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Inventory> getInventory(String pluginName, String name) {
        Optional<Plugin> optional = this.getPluginIgnoreCase(pluginName);
        return optional.isEmpty() || name == null ? Optional.empty() : this.getInventory(optional.get(), name);
    }

    @Override
    public Collection<Inventory> getInventories() {
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>();
        for (List<Inventory> inventoryList : this.inventories.values()) {
            allInventories.addAll(inventoryList);
        }
        return allInventories;
    }

    @Override
    public Collection<Inventory> getInventories(Plugin plugin) {
        return plugin == null ? new ArrayList<Inventory>() : (Collection)this.inventories.getOrDefault(plugin.getName(), new ArrayList());
    }

    @Override
    public void deleteInventory(Inventory inventory) {
        String pluginName = inventory.getPlugin().getName();
        List inventories = this.inventories.getOrDefault(pluginName, new ArrayList());
        inventories.remove(inventory);
        this.inventories.put(pluginName, inventories);
    }

    @Override
    public boolean deleteInventory(String name) {
        Optional<Inventory> optional = this.getInventory(name);
        if (optional.isPresent()) {
            this.deleteInventory(optional.get());
            return false;
        }
        return false;
    }

    @Override
    public void deleteInventories(Plugin plugin) {
        this.inventories.remove(plugin.getName());
    }

    @Override
    public void openInventory(Player player, Inventory inventory) {
        this.openInventory(player, inventory, 1, new ArrayList<Inventory>());
    }

    @Override
    public void openInventory(Player player, Inventory inventory, int page) {
        this.openInventory(player, inventory, page, new ArrayList<Inventory>());
    }

    @Override
    public void openInventoryWithOldInventories(Player player, Inventory inventory, int page) {
        List<Inventory> oldInventories = new ArrayList<Inventory>();
        InventoryHolder inventoryHolder = player.getOpenInventory().getTopInventory().getHolder();
        if (inventoryHolder instanceof InventoryDefault) {
            InventoryDefault inventoryDefault = (InventoryDefault)inventoryHolder;
            Inventory fromInventory = inventoryDefault.getMenuInventory();
            oldInventories = inventoryDefault.getOldInventories();
            oldInventories.add(fromInventory);
        }
        this.openInventory(player, inventory, page, oldInventories);
    }

    @Override
    public void openInventory(Player player, Inventory inventory, int page, List<Inventory> oldInventories) {
        PlayerOpenInventoryEvent playerOpenInventoryEvent = new PlayerOpenInventoryEvent(player, inventory, page, oldInventories);
        if (Config.enableFastEvent) {
            this.getFastEvents().forEach(event -> event.onPlayerOpenInventory(playerOpenInventoryEvent));
        } else {
            playerOpenInventoryEvent.call();
        }
        if (playerOpenInventoryEvent.isCancelled()) {
            return;
        }
        page = playerOpenInventoryEvent.getPage();
        oldInventories = playerOpenInventoryEvent.getOldInventories();
        this.currentInventories.put(player.getUniqueId(), inventory);
        this.createInventory(this.plugin, player, EnumInventory.INVENTORY_DEFAULT, page, inventory, oldInventories);
    }

    @Override
    public void openInventory(Player player, Inventory inventory, int page, Inventory ... inventories) {
        ArrayList<Inventory> oldInventories = new ArrayList<Inventory>();
        Collections.addAll(oldInventories, inventories);
        this.openInventory(player, inventory, page, oldInventories);
    }

    @Override
    public void loadButtons() {
        ButtonManager buttonManager = this.plugin.getButtonManager();
        buttonManager.registerPermissible(new PlaceholderPermissibleLoader(buttonManager));
        buttonManager.registerPermissible(new PermissionPermissibleLoader(buttonManager));
        buttonManager.registerPermissible(new ItemPermissibleLoader(this.plugin));
        buttonManager.registerPermissible(new RegexPermissibleLoader(buttonManager));
        buttonManager.registerPermissible(new PlayerNamePermissibleLoader(buttonManager));
        buttonManager.registerPermissible(new CurrencyPermissibleLoader(buttonManager));
        buttonManager.registerPermissible(new CuboidPermissibleLoader(buttonManager));
        if (this.plugin.isEnable(Plugins.JOBS)) {
            buttonManager.registerPermissible(new JobPermissibleLoader(buttonManager));
        }
        if (this.plugin.isEnable(Plugins.LUCKPERMS)) {
            buttonManager.registerPermissible(new LuckPermPermissibleLoader(buttonManager));
        }
        buttonManager.registerAction(new BroadcastLoader(this.plugin));
        buttonManager.registerAction(new MessageLoader());
        buttonManager.registerAction(new BookLoader());
        buttonManager.registerAction(new SoundLoader());
        buttonManager.registerAction(new BroadcastSoundLoader());
        buttonManager.registerAction(new CloseLoader());
        buttonManager.registerAction(new ConnectLoader(this.plugin));
        buttonManager.registerAction(new DataLoader(this.plugin));
        buttonManager.registerAction(new InventoryLoader(this.plugin));
        buttonManager.registerAction(new ChatLoader());
        if (Config.enablePlayerCommandsAsOPAction) {
            buttonManager.registerAction(new PlayerCommandAsOPLoader());
        }
        buttonManager.registerAction(new PlayerCommandLoader());
        buttonManager.registerAction(new ConsoleCommandLoader());
        buttonManager.registerAction(new fr.maxlego08.menu.loader.actions.BackLoader(this.plugin));
        buttonManager.registerAction(new ShopkeeperLoader(this.plugin));
        buttonManager.registerAction(new TitleLoader());
        buttonManager.registerAction(new ActionBarLoader());
        buttonManager.registerAction(new RefreshLoader());
        buttonManager.registerAction(new RefreshInventoryLoader());
        buttonManager.registerAction(new DiscordLoader());
        buttonManager.registerAction(new DiscordComponentV2Loader());
        buttonManager.registerAction(new TeleportLoader(this.plugin));
        buttonManager.registerAction(new CurrencyWithdrawLoader());
        buttonManager.registerAction(new CurrencyDepositLoader());
        if (this.plugin.isEnable(Plugins.LUCKPERMS)) {
            buttonManager.registerAction(new LuckPermissionSetLoader());
        }
        buttonManager.registerAction(new ToastLoader(this.plugin));
        if (this.plugin.getDialogManager() != null) {
            buttonManager.registerAction(new DialogLoader(this.plugin, this.plugin.getDialogManager()));
        }
        buttonManager.register(new NoneLoader(this.plugin, ZNoneButton.class, "none"));
        buttonManager.register(new NoneLoader(this.plugin, ZNoneButton.class, "none_slot"));
        buttonManager.register(new NoneLoader(this.plugin, ZNoneButton.class, "perform_command"));
        buttonManager.register(new fr.maxlego08.menu.button.loader.InventoryLoader(this.plugin));
        buttonManager.register(new BackLoader(this.plugin));
        buttonManager.register(new HomeLoader(this.plugin));
        buttonManager.register(new NextLoader(this.plugin));
        buttonManager.register(new PreviousLoader(this.plugin));
        buttonManager.register(new MainMenuLoader(this.plugin));
        buttonManager.register(new JumpLoader(this.plugin));
        buttonManager.register(new SwitchLoader(this.plugin));
        buttonManager.register(new ItemBodyLoader(this.plugin));
        buttonManager.register(new PlainMessageBodyLoader(this.plugin));
        buttonManager.register(new TextInputLoader(this.plugin));
        buttonManager.register(new BooleanInputLoader(this.plugin));
        buttonManager.register(new NumberRangeInputLoader(this.plugin));
        buttonManager.register(new SingleOptionInputLoader(this.plugin));
        this.registerItemStackVerification(new FullSimilar());
        this.registerItemStackVerification(new LoreSimilar());
        this.registerItemStackVerification(new MaterialSimilar());
        this.registerItemStackVerification(new ModelIdSimilar());
        this.registerItemStackVerification(new NameSimilar());
        this.registerItemStackVerification(new ItemModelSimilar());
        ButtonLoaderRegisterEvent event = new ButtonLoaderRegisterEvent(buttonManager, this, this.plugin.getPatternManager());
        event.call();
        this.plugin.getWebsiteManager().loadButtons(buttonManager);
        CommandManager commandManager = this.plugin.getCommandManager();
        commandManager.registerArgumentValidator(new IntArgumentValidator());
        commandManager.registerArgumentValidator(new DoubleArgumentValidator());
        commandManager.registerArgumentValidator(new BooleanArgumentValidator());
        commandManager.registerArgumentValidator(new EntityTypeArgumentValidator());
        commandManager.registerArgumentValidator(new MaterialArgumentValidator(Message.COMMAND_ARGUMENT_MATERIAL));
        commandManager.registerArgumentValidator(new MaterialArgumentValidator(Message.COMMAND_ARGUMENT_BLOCK));
        commandManager.registerArgumentValidator(new OnlinePlayerArgumentValidator(this.plugin));
        commandManager.registerArgumentValidator(new PlayerArgumentValidator(this.plugin));
        commandManager.registerArgumentValidator(new LocationArgumentValidator(this.plugin));
        commandManager.registerArgumentValidator(new WorldArgumentValidator(this.plugin));
    }

    @Override
    public void loadInventories() {
        File file;
        this.playerMaxPages.clear();
        this.playerPages.clear();
        File folder = new File(this.plugin.getDataFolder(), "inventories");
        if (!folder.exists()) {
            folder.mkdir();
        }
        try (Stream<Path> stream = Files.walk(Paths.get(folder.getPath(), new String[0]), new FileVisitOption[0]);){
            Iterator iterator = stream.iterator();
            if (iterator.hasNext()) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                file = path.toFile();
                if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
                try {
                    this.loadInventory((Plugin)this.plugin, file);
                }
                catch (InventoryException exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        List<String> list = Config.specifyPathMenus;
        for (String s : list) {
            file = new File(s);
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            try {
                this.loadInventory((Plugin)this.plugin, file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.plugin.getWebsiteManager().loadInventories(this);
    }

    @Override
    public boolean registerMaterialLoader(MaterialLoader materialLoader) {
        Optional<MaterialLoader> optional = this.getMaterialLoader(materialLoader.getKey());
        if (optional.isPresent()) {
            return false;
        }
        this.loaders.add(materialLoader);
        return true;
    }

    @Override
    public Optional<MaterialLoader> getMaterialLoader(String key) {
        for (MaterialLoader loader : this.loaders) {
            if (!loader.getKey().equalsIgnoreCase(key)) continue;
            return Optional.of(loader);
        }
        return Optional.empty();
    }

    @Override
    public Collection<MaterialLoader> getMaterialLoader() {
        return Collections.unmodifiableCollection(this.loaders);
    }

    @Override
    public void openInventory(Player player, Plugin plugin, String inventoryName) {
        Optional<Inventory> optional = this.getInventory(plugin, inventoryName);
        if (optional.isEmpty()) {
            player.closeInventory();
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.INVENTORY_NOT_FOUND, "%name%", inventoryName, "%toName%", inventoryName, "%plugin%", plugin.getName());
            return;
        }
        this.openInventory(player, optional.get());
    }

    @Override
    public void openInventory(Player player, String pluginName, String inventoryName) {
        this.openInventory(player, pluginName, inventoryName, 1);
    }

    @Override
    public void openInventory(Player player, String pluginName, String inventoryName, int page) {
        Optional<Inventory> optional = this.getInventory(pluginName, inventoryName);
        if (optional.isEmpty()) {
            player.closeInventory();
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.INVENTORY_NOT_FOUND, "%name%", inventoryName, "%toName%", inventoryName, "%plugin%", pluginName);
            return;
        }
        this.openInventory(player, optional.get(), page);
    }

    @Override
    public void openInventory(Player player, String inventoryName, int page) {
        Optional<Inventory> optional = this.getInventory(inventoryName);
        if (optional.isEmpty()) {
            player.closeInventory();
            this.message((MenuPlugin)this.plugin, (CommandSender)player, Message.INVENTORY_NOT_FOUND, "%name%", inventoryName, "%toName%", inventoryName, "%plugin%", this.plugin.getName());
            return;
        }
        this.openInventory(player, optional.get(), page);
    }

    @Override
    public void openInventory(Player player, String inventoryName) {
        this.openInventory(player, inventoryName, 1);
    }

    @Override
    public void reloadInventory(Inventory inventory) {
        this.deleteInventory(inventory);
        try {
            this.loadInventory(inventory.getPlugin(), inventory.getFile());
        }
        catch (InventoryException e) {
            e.printStackTrace();
        }
    }

    @Override
    public MetaUpdater getMeta() {
        return this.plugin.getMetaUpdater();
    }

    @Override
    public Inventory loadInventoryOrSaveResource(Plugin plugin, String resourceName) throws InventoryException {
        File file = new File(plugin.getDataFolder(), resourceName);
        if (!file.exists()) {
            plugin.saveResource(resourceName, false);
        }
        return this.loadInventory(plugin, file);
    }

    @Override
    public Inventory loadInventoryOrSaveResource(Plugin plugin, String resourceName, Class<? extends Inventory> classz) throws InventoryException {
        File file = new File(plugin.getDataFolder(), resourceName);
        if (!file.exists()) {
            plugin.saveResource(resourceName, false);
        }
        return this.loadInventory(plugin, file, classz);
    }

    @Override
    public Optional<Inventory> getCurrentPlayerInventory(Player player) {
        return Optional.ofNullable(this.currentInventories.getOrDefault(player.getUniqueId(), null));
    }

    @Override
    public void unregisterListener(Plugin plugin) {
        this.fastEventMap.remove(plugin);
    }

    @Override
    public void registerFastEvent(Plugin plugin, FastEvent fastEvent) {
        this.fastEventMap.put(plugin, fastEvent);
    }

    @Override
    public Collection<FastEvent> getFastEvents() {
        return this.fastEventMap.values();
    }

    @Override
    public void sendInventories(CommandSender sender) {
        if (this.inventories.isEmpty()) {
            this.message((MenuPlugin)this.plugin, sender, Message.LIST_EMPTY, new Object[0]);
            return;
        }
        this.inventories.forEach((plugin, inventories) -> {
            ArrayList<String> fileNames = new ArrayList<String>(inventories.size());
            for (Inventory inventory : inventories) {
                fileNames.add(inventory.getFileName());
            }
            String inventoriesAsString = this.toList(fileNames, "\u00a78", "\u00a77");
            this.messageWO((MenuPlugin)this.plugin, sender, Message.LIST_INFO, "%plugin%", plugin, "%amount%", inventories.size(), "%inventories%", inventoriesAsString);
        });
    }

    @Override
    public void createNewInventory(CommandSender sender, String fileName, int inventorySize, String inventoryName) {
        fileName = fileName.replace(".yml", "");
        File file = new File(this.plugin.getDataFolder(), "inventories/" + fileName + ".yml");
        if (file.exists()) {
            this.message((MenuPlugin)this.plugin, sender, Message.INVENTORY_CREATE_ERROR_ALREADY, "%name%", fileName);
            return;
        }
        try {
            file.createNewFile();
        }
        catch (IOException exception) {
            this.message((MenuPlugin)this.plugin, sender, Message.INVENTORY_CREATE_ERROR_EXCEPTION, "%error%", exception.getMessage());
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.set("name", (Object)inventoryName);
        configuration.set("size", (Object)inventorySize);
        configuration.set("items", new ArrayList());
        try {
            configuration.save(file);
        }
        catch (IOException exception) {
            this.message((MenuPlugin)this.plugin, sender, Message.INVENTORY_CREATE_ERROR_EXCEPTION, "%error%", exception.getMessage());
        }
        this.message((MenuPlugin)this.plugin, sender, Message.INVENTORY_CREATE_SUCCESS, "%name%", fileName);
        try {
            this.loadInventory((Plugin)this.plugin, file);
        }
        catch (InventoryException exception) {
            this.message((MenuPlugin)this.plugin, sender, Message.INVENTORY_CREATE_ERROR_EXCEPTION, "%error%", exception.getMessage());
        }
    }

    @Override
    public void updateInventory(Player player) {
        this.plugin.getScheduler().runAtEntity((Entity)player, w -> {
            InventoryHolder holder = CompatibilityUtil.getTopInventory(player).getHolder();
            if (holder instanceof InventoryDefault) {
                InventoryDefault inventoryDefault = (InventoryDefault)holder;
                this.openInventory(player, inventoryDefault.getMenuInventory(), inventoryDefault.getPage(), inventoryDefault.getOldInventories());
            }
        });
    }

    @Override
    public void updateInventoryCurrentPage(Player player) {
        this.plugin.getScheduler().runAtEntity((Entity)player, w -> {
            InventoryHolder holder = CompatibilityUtil.getTopInventory(player).getHolder();
            if (holder instanceof InventoryDefault) {
                InventoryDefault inventoryDefault = (InventoryDefault)holder;
                this.openInventory(player, inventoryDefault.getMenuInventory(), this.getPage((OfflinePlayer)player), inventoryDefault.getOldInventories());
            }
        });
    }

    @Override
    public void updateInventory(Player player, Plugin plugin) {
        this.plugin.getScheduler().runAtEntity((Entity)player, w -> {
            InventoryDefault inventoryDefault;
            InventoryHolder holder = CompatibilityUtil.getTopInventory(player).getHolder();
            if (holder instanceof InventoryDefault && (inventoryDefault = (InventoryDefault)holder).getMenuInventory().getPlugin() == plugin) {
                this.openInventory(player, inventoryDefault.getMenuInventory(), inventoryDefault.getPage(), inventoryDefault.getOldInventories());
            }
        });
    }

    @Override
    public void saveItem(CommandSender sender, ItemStack itemStack, String name, String type) {
        Set names;
        YamlConfiguration configuration;
        ConfigurationSection configurationSection;
        File file = new File(this.plugin.getDataFolder(), "save_items.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        if ((configurationSection = (configuration = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("items.")) != null && (names = configurationSection.getKeys(false)).contains(name)) {
            this.message((MenuPlugin)this.plugin, sender, Message.SAVE_ERROR_NAME, new Object[0]);
            return;
        }
        MenuItemStackLoader loader = new MenuItemStackLoader(this);
        ZMenuItemStack menuItemStack = ZMenuItemStack.fromItemStack(this, itemStack);
        if (type.equalsIgnoreCase("yml")) {
            loader.save(menuItemStack, configuration, "items." + name + ".", file, new Object[0]);
        } else if (type.equalsIgnoreCase("base64")) {
            String base64 = ItemStackUtils.serializeItemStack(itemStack);
            configuration.set("items." + name + ".material", (Object)("base64:" + base64));
            try {
                configuration.save(file);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            this.message((MenuPlugin)this.plugin, sender, Message.SAVE_ERROR_TYPE, "%name%", name);
            return;
        }
        this.message((MenuPlugin)this.plugin, sender, Message.SAVE_SUCCESS, "%name%", name);
    }

    @EventHandler
    public void onQuid(PlayerQuitEvent event) {
        this.currentInventories.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        for (Inventory inventory : this.getInventories()) {
            OpenWithItem openWithItem = inventory.getOpenWithItem();
            if (openWithItem == null || !openWithItem.shouldTrigger(event)) continue;
            this.openInventory(event.getPlayer(), inventory);
        }
    }

    @Override
    public List<ClickType> loadClicks(List<String> loadClicks) {
        ArrayList<ClickType> clickTypes = new ArrayList<ClickType>();
        loadClicks.forEach(clickType -> {
            if (clickType == null) {
                return;
            }
            if (clickType.equalsIgnoreCase("all") || clickType.equalsIgnoreCase("any")) {
                clickTypes.addAll(Config.allClicksType);
            } else {
                try {
                    clickTypes.add(ClickType.valueOf((String)clickType.toUpperCase()));
                }
                catch (Exception ignored) {
                    Logger.info(clickType + " click type was not found.", Logger.LogType.ERROR);
                }
            }
        });
        return clickTypes;
    }

    @Override
    public void registerItemStackVerification(ItemStackSimilar itemStackSimilar) {
        this.itemStackSimilarMap.put(itemStackSimilar.getName().toLowerCase(), itemStackSimilar);
    }

    @Override
    public Optional<ItemStackSimilar> getItemStackVerification(String name) {
        return Optional.ofNullable(this.itemStackSimilarMap.getOrDefault(name.toLowerCase(), null));
    }

    @Override
    public Collection<ItemStackSimilar> getItemStackVerifications() {
        return this.itemStackSimilarMap.values();
    }

    @Override
    public PlatformScheduler getScheduler() {
        return this.plugin.getScheduler();
    }

    @Override
    public Optional<Class<? extends ButtonOption>> getOption(String name) {
        for (List<Class<? extends ButtonOption>> options : this.buttonOptions.values()) {
            for (Class<? extends ButtonOption> buttonOption : options) {
                if (!buttonOption.getName().equalsIgnoreCase(name)) continue;
                return Optional.of(buttonOption);
            }
        }
        return Optional.empty();
    }

    @Override
    public void registerOption(Plugin plugin, Class<? extends ButtonOption> buttonOption) {
        if (this.getOption(buttonOption.getName()).isPresent()) {
            return;
        }
        this.buttonOptions.computeIfAbsent(plugin, e -> new ArrayList()).add(buttonOption);
    }

    @Override
    public void unregisterOptions(Plugin plugin) {
        this.buttonOptions.remove(plugin);
    }

    @Override
    public Map<Plugin, List<Class<? extends ButtonOption>>> getOptions() {
        return this.buttonOptions;
    }

    @Override
    public void setPlayerPage(OfflinePlayer player, int page, int maxPage) {
        this.playerPages.put(player.getUniqueId(), page);
        this.playerMaxPages.put(player.getUniqueId(), maxPage);
    }

    @Override
    public int getPage(OfflinePlayer player) {
        return this.playerPages.getOrDefault(player.getUniqueId(), 0);
    }

    @Override
    public int getMaxPage(OfflinePlayer player) {
        return this.playerMaxPages.getOrDefault(player.getUniqueId(), 0);
    }

    @Override
    public InventoryDefault getFakeInventory() {
        InventoryDefault inventoryDefault = new InventoryDefault();
        inventoryDefault.setPlugin(this.plugin);
        return inventoryDefault;
    }

    @Override
    public Enchantments getEnchantments() {
        return this.plugin.getEnchantments();
    }

    @Override
    public FontImage getFontImage() {
        return this.plugin.getFontImage();
    }

    @Override
    public YamlConfiguration loadYamlConfiguration(File file) {
        return this.loadAndReplaceConfiguration(file, this.plugin.getGlobalPlaceholders());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadElement(InventoryRequirementType type, String value) {
        Iterator<InventoryLoadRequirement> iterator = this.inventoryLoadRequirements.iterator();
        while (iterator.hasNext()) {
            InventoryLoadRequirement inventoryLoadRequirement = iterator.next();
            inventoryLoadRequirement.removeRequirement(type, value);
            if (!inventoryLoadRequirement.canLoad()) continue;
            if (Config.enableInformationMessage) {
                Logger.info("Conditions are met to load the file " + inventoryLoadRequirement.getFile().getPath(), Logger.LogType.SUCCESS);
            }
            try {
                this.loadInventory(inventoryLoadRequirement.getPlugin(), inventoryLoadRequirement.getFile(), inventoryLoadRequirement.getClassz());
            }
            catch (InventoryException exception) {
                exception.printStackTrace();
            }
            finally {
                iterator.remove();
            }
        }
    }

    @Override
    public void registerInventoryOption(Plugin plugin, Class<? extends InventoryOption> inventoryOption) {
        if (this.getInventoryOption(inventoryOption.getName()).isPresent()) {
            return;
        }
        this.inventoryOptions.computeIfAbsent(plugin, e -> new ArrayList()).add(inventoryOption);
    }

    @Override
    public Map<Plugin, List<Class<? extends InventoryOption>>> getInventoryOptions() {
        return this.inventoryOptions;
    }

    @Override
    public Optional<Class<? extends InventoryOption>> getInventoryOption(String name) {
        for (List<Class<? extends InventoryOption>> options : this.inventoryOptions.values()) {
            for (Class<? extends InventoryOption> inventoryOption : options) {
                if (!inventoryOption.getName().equalsIgnoreCase(name)) continue;
                return Optional.of(inventoryOption);
            }
        }
        return Optional.empty();
    }

    @Override
    public void unregisterInventoryOptions(Plugin plugin) {
        this.inventoryOptions.remove(plugin);
    }

    @Override
    public void registerInventoryListener(InventoryListener inventoryListener) {
        this.inventoryListeners.add(inventoryListener);
    }

    @Override
    public void unregisterInventoryListener(InventoryListener inventoryListener) {
        this.inventoryListeners.remove(inventoryListener);
    }

    @Override
    public List<InventoryListener> getInventoryListeners() {
        return this.inventoryListeners;
    }

    @Override
    public ItemStack postProcessSkullItemStack(ItemStack itemStack, Button button, Player player) {
        String name = this.papi(this.plugin.parse(player, button.getPlayerHead().replace("%player%", player.getName())), (OfflinePlayer)player, true);
        if (!this.isMinecraftName(name)) {
            return itemStack;
        }
        if (NMSUtils.isNewHeadApi()) {
            OfflinePlayer offlinePlayer = OfflinePlayerCache.get(name);
            if (offlinePlayer != null) {
                SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                skullMeta.setOwnerProfile(offlinePlayer.getPlayerProfile().getTextures().isEmpty() ? (PlayerProfile)offlinePlayer.getPlayerProfile().update().join() : offlinePlayer.getPlayerProfile());
                itemStack.setItemMeta((ItemMeta)skullMeta);
            }
        } else {
            String texture = PlayerSkin.getTexture(name);
            if (texture == null) {
                SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                skullMeta.setOwner(name);
                itemStack.setItemMeta((ItemMeta)skullMeta);
            } else {
                this.applyTexture(itemStack, texture);
            }
        }
        return itemStack;
    }

    @Override
    public void sendMessage(CommandSender sender, Message message, Object ... args) {
        this.message((MenuPlugin)this.plugin, sender, message, args);
    }
}

