/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.ItemManager;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.mechanic.MechanicFactory;
import fr.maxlego08.menu.api.mechanic.MechanicListener;
import fr.maxlego08.menu.item.CustomItemData;
import fr.maxlego08.menu.mechanics.itemjoin.ItemJoinMechanicFactory;
import fr.maxlego08.menu.zcore.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ZItemManager
implements ItemManager {
    private final NamespacedKey itemIdKey;
    private final NamespacedKey ownerKey;
    private final MenuPlugin menuPlugin;
    private final Map<String, MechanicListener> mechanicListeners = new HashMap<String, MechanicListener>();
    private final Map<String, MechanicFactory> mechanicFactories = new HashMap<String, MechanicFactory>();
    private final Map<String, CustomItemData> customItems = new HashMap<String, CustomItemData>();

    public ZItemManager(ZMenuPlugin menuPlugin) {
        this.itemIdKey = new NamespacedKey((Plugin)menuPlugin, "item-id");
        this.ownerKey = new NamespacedKey((Plugin)menuPlugin, "owner");
        this.menuPlugin = menuPlugin;
    }

    private void loadMechanics() {
        this.registerMechanicFactory(new ItemJoinMechanicFactory(this.menuPlugin));
    }

    @Override
    public void loadAll() {
        this.loadMechanics();
        this.loadCustomItems();
    }

    @Override
    public void loadCustomItems() {
        block11: {
            File itemsFolder = new File(this.menuPlugin.getDataFolder(), "items");
            if (!itemsFolder.exists()) {
                if (itemsFolder.mkdirs()) {
                    Logger.info("Items folder created.");
                } else {
                    Logger.info("Failed to create items folder.", Logger.LogType.ERROR);
                }
            }
            try (Stream<Path> stream = Files.walk(Paths.get(itemsFolder.getPath(), new String[0]), new FileVisitOption[0]);){
                stream.skip(1L).map(Path::toFile).filter(File::isFile).filter(e -> e.getName().endsWith(".yml")).forEach(this::loadCustomItem);
            }
            catch (IOException exception) {
                if (!Config.enableDebug) break block11;
                Logger.info("Error while loading items: " + exception.getMessage(), Logger.LogType.ERROR);
            }
        }
    }

    @Override
    public void loadCustomItem(File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (String itemId : config.getKeys(false)) {
            String path = itemId + ".";
            MenuItemStack menuItemStack = this.menuPlugin.loadItemStack(config, path, file);
            if (menuItemStack != null) {
                HashSet<String> mechanicIds = new HashSet<String>();
                ConfigurationSection mechanicSection = config.getConfigurationSection(itemId + ".mechanics");
                if (mechanicSection != null) {
                    path = path + "mechanics.";
                    for (String mechanicId : mechanicSection.getKeys(false)) {
                        MechanicFactory factory = this.mechanicFactories.get(mechanicId);
                        if (factory != null) {
                            factory.parse(this.menuPlugin, itemId, mechanicSection.getConfigurationSection(mechanicId), config, file, path + mechanicId + ".");
                            mechanicIds.add(mechanicId);
                            continue;
                        }
                        Logger.info("No MechanicFactory found for mechanicId " + mechanicId + " in item " + itemId, Logger.LogType.WARNING);
                    }
                }
                this.customItems.put(itemId, new CustomItemData(menuItemStack, mechanicIds));
                continue;
            }
            if (!Config.enableDebug) continue;
            Logger.info("Impossible to load item " + itemId + " from file " + file.getName());
        }
    }

    @Override
    public void reloadCustomItems() {
        this.customItems.clear();
        for (MechanicFactory factory : this.mechanicFactories.values()) {
            factory.clearMechanics();
        }
        this.loadCustomItems();
    }

    @Override
    public boolean isCustomItem(String itemId) {
        return this.customItems.containsKey(itemId);
    }

    @Override
    public boolean isCustomItem(ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta() || !itemStack.getItemMeta().getPersistentDataContainer().has(this.itemIdKey)) {
            return false;
        }
        String itemId = (String)itemStack.getItemMeta().getPersistentDataContainer().get(this.itemIdKey, PersistentDataType.STRING);
        return this.isCustomItem(itemId);
    }

    @Override
    public Optional<String> getItemId(ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta() || !itemStack.getItemMeta().getPersistentDataContainer().has(this.itemIdKey)) {
            return Optional.empty();
        }
        String itemId = (String)itemStack.getItemMeta().getPersistentDataContainer().get(this.itemIdKey, PersistentDataType.STRING);
        if (itemId == null || !this.isCustomItem(itemId)) {
            return Optional.empty();
        }
        return Optional.of(itemId);
    }

    @Override
    public void registerListeners(Plugin plugin, String mechanicId, MechanicListener listener) {
        if (this.mechanicListeners.containsKey(mechanicId)) {
            Logger.info("Listener for mechanic " + mechanicId + " is already registered.", Logger.LogType.WARNING);
            return;
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)listener, plugin);
        this.mechanicListeners.put(mechanicId, listener);
    }

    @Override
    public void unloadListeners() {
        for (Listener listener : this.mechanicListeners.values()) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    @Override
    public void registerMechanicFactory(MechanicFactory factory) {
        if (this.mechanicFactories.containsKey(factory.getMechanicId())) {
            Logger.info("MechanicFactory " + factory.getMechanicId() + " is already registered.", Logger.LogType.WARNING);
            return;
        }
        this.mechanicFactories.put(factory.getMechanicId(), factory);
    }

    @Override
    public void giveItem(Player player, String itemId) {
        if (!this.isCustomItem(itemId)) {
            Logger.info("Item " + itemId + " is not a custom item.", Logger.LogType.WARNING);
            return;
        }
        CustomItemData itemData = this.customItems.get(itemId);
        MenuItemStack menuItemStack = itemData.menuItemStack();
        ItemStack itemStack = menuItemStack.build(player);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(this.itemIdKey, PersistentDataType.STRING, (Object)itemId);
        itemMeta.getPersistentDataContainer().set(this.ownerKey, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
        itemStack.setItemMeta(itemMeta);
        boolean shouldCancel = false;
        for (String mechanicId : itemData.mechanicIds()) {
            boolean cancel;
            MechanicListener mechanicListener = this.mechanicListeners.get(mechanicId);
            if (mechanicListener == null || !(cancel = mechanicListener.onItemGive(player, itemStack, itemId))) continue;
            shouldCancel = true;
        }
        if (shouldCancel) {
            return;
        }
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    @Override
    public Set<String> getItemIds() {
        return this.customItems.keySet();
    }

    @Override
    public void executeCheckInventoryItems(Player player) {
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack built;
            Player owner;
            String itemId;
            ItemMeta meta;
            ItemStack itemStack = contents[i];
            if (itemStack == null || !itemStack.hasItemMeta() || (meta = itemStack.getItemMeta()) == null || !meta.getPersistentDataContainer().has(this.itemIdKey) || (itemId = (String)meta.getPersistentDataContainer().get(this.itemIdKey, PersistentDataType.STRING)) == null) continue;
            if (!this.isCustomItem(itemId)) {
                meta.getPersistentDataContainer().remove(this.itemIdKey);
                meta.getPersistentDataContainer().remove(this.ownerKey);
                itemStack.setItemMeta(meta);
                player.getInventory().setItem(i, itemStack);
                continue;
            }
            CustomItemData itemData = this.customItems.get(itemId);
            if (itemData == null) continue;
            MenuItemStack menuItemStack = itemData.menuItemStack();
            String ownerUuid = (String)meta.getPersistentDataContainer().get(this.ownerKey, PersistentDataType.STRING);
            if (ownerUuid == null || (owner = this.menuPlugin.getServer().getPlayer(UUID.fromString(ownerUuid))) == null || (built = menuItemStack.build(owner)) == null) continue;
            built.setAmount(itemStack.getAmount());
            ItemMeta builtMeta = built.getItemMeta();
            if (builtMeta == null) continue;
            builtMeta.getPersistentDataContainer().set(this.itemIdKey, PersistentDataType.STRING, (Object)itemId);
            builtMeta.getPersistentDataContainer().set(this.ownerKey, PersistentDataType.STRING, (Object)owner.getUniqueId().toString());
            built.setItemMeta(builtMeta);
            if (built.isSimilar(itemStack)) continue;
            player.getInventory().setItem(i, built);
        }
    }
}

