/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.attribute.AttributeMergeStrategy;
import fr.maxlego08.menu.api.attribute.AttributeUtil;
import fr.maxlego08.menu.api.attribute.AttributeWrapper;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.enchantment.Enchantments;
import fr.maxlego08.menu.api.enums.MenuItemRarity;
import fr.maxlego08.menu.api.exceptions.ItemEnchantException;
import fr.maxlego08.menu.api.font.FontImage;
import fr.maxlego08.menu.api.itemstack.Banner;
import fr.maxlego08.menu.api.itemstack.Firework;
import fr.maxlego08.menu.api.itemstack.LeatherArmor;
import fr.maxlego08.menu.api.itemstack.Potion;
import fr.maxlego08.menu.api.itemstack.TrimConfiguration;
import fr.maxlego08.menu.api.loader.MaterialLoader;
import fr.maxlego08.menu.api.utils.LoreType;
import fr.maxlego08.menu.api.utils.MapConfiguration;
import fr.maxlego08.menu.api.utils.OfflinePlayerCache;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.ZUtils;
import fr.maxlego08.menu.zcore.utils.itemstack.MenuItemStackFormMap;
import fr.maxlego08.menu.zcore.utils.itemstack.MenuItemStackFromItemStack;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.potion.PotionType;

public class ZMenuItemStack
extends ZUtils
implements MenuItemStack {
    private final InventoryManager inventoryManager;
    private final String filePath;
    private final String path;
    private String material;
    private String targetPlayer;
    private String amount;
    private String url;
    private String data;
    private String tooltipStyle;
    private int durability;
    private Potion potion;
    private List<String> lore = new ArrayList<String>();
    private List<ItemFlag> flags = new ArrayList<ItemFlag>();
    private String displayName;
    private Map<String, String> translatedDisplayName = new HashMap<String, String>();
    private Map<String, List<String>> translatedLore = new HashMap<String, List<String>>();
    private boolean isGlowing;
    private String modelID;
    private String itemModel;
    private String equippedModel;
    private Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    private boolean clearDefaultAttributes = false;
    private List<AttributeWrapper> attributes = new ArrayList<AttributeWrapper>();
    private AttributeMergeStrategy attributeMergeStrategy;
    private Banner banner;
    private Firework firework;
    private LeatherArmor leatherArmor;
    private boolean needPlaceholderAPI = false;
    private ItemStack cacheItemStack;
    private boolean centerName;
    private boolean centerLore;
    private LoreType loreType = LoreType.REPLACE;
    private int maxStackSize;
    private int maxDamage;
    private int damage;
    private int repairCost;
    private Boolean unbreakableEnabled;
    private Boolean unbreakableShowInTooltip;
    private Boolean fireResistant;
    private Boolean hideTooltip;
    private Boolean hideAdditionalTooltip;
    private Boolean enchantmentGlint;
    private Boolean enchantmentShowInTooltip;
    private Boolean attributeShowInTooltip;
    private MenuItemRarity itemRarity;
    private TrimConfiguration trimConfiguration;

    public ZMenuItemStack(InventoryManager inventoryManager, String filePath, String path) {
        this.inventoryManager = inventoryManager;
        this.filePath = filePath;
        this.path = path;
    }

    public static ZMenuItemStack fromItemStack(InventoryManager manager, ItemStack itemStack) {
        return MenuItemStackFromItemStack.fromItemStack(manager, itemStack);
    }

    public static ZMenuItemStack fromMap(InventoryManager inventoryManager, File file, String path, Map<String, Object> map) {
        return MenuItemStackFormMap.fromMap(inventoryManager, file, path, map);
    }

    @Override
    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    @Override
    public ItemStack build(Player player) {
        return this.build(player, true);
    }

    @Override
    public ItemStack build(Player player, boolean useCache) {
        return this.build(player, useCache, new Placeholders());
    }

    @Override
    public ItemStack build(Player player, boolean useCache, Placeholders placeholders) {
        OfflinePlayer offlinePlayer;
        if (this.shouldUseCache(useCache)) {
            return this.cacheItemStack;
        }
        if (this.material == null) {
            this.material = "STONE";
        }
        int amount = this.parseAmount((OfflinePlayer)((offlinePlayer = this.resolveOfflinePlayer(player, placeholders)) == null ? player : offlinePlayer), placeholders);
        ItemStack itemStack = this.createItemStack(player, placeholders, offlinePlayer, amount);
        this.applyItemMeta(player, placeholders, offlinePlayer, useCache, itemStack);
        this.applyAttributes(itemStack);
        if (!this.needPlaceholderAPI && Config.enableCacheItemStack) {
            this.cacheItemStack = itemStack;
        }
        return itemStack;
    }

    private boolean shouldUseCache(boolean useCache) {
        return !this.needPlaceholderAPI && this.cacheItemStack != null && Config.enableCacheItemStack && useCache;
    }

    private OfflinePlayer resolveOfflinePlayer(Player player, Placeholders placeholders) {
        return this.targetPlayer != null ? OfflinePlayerCache.get(this.papi(placeholders.parse(this.targetPlayer), (OfflinePlayer)player, false)) : null;
    }

    private ItemStack createItemStack(Player player, Placeholders placeholders, OfflinePlayer offlinePlayer, int amount) {
        Material material = this.resolveMaterial(player, placeholders, offlinePlayer);
        ItemStack itemStack = this.resolveCustomItem(player, placeholders, material);
        if (itemStack == null) {
            itemStack = this.createDefaultItemStack(player, material, amount);
        }
        if ((itemStack = this.applySpecialItemStack(player, amount, itemStack)) == null) {
            itemStack = new ItemStack(Material.STONE);
        }
        itemStack.setAmount(Math.max(1, amount));
        if (this.durability != 0) {
            itemStack.setDurability((short)this.durability);
        }
        return itemStack;
    }

    private Material resolveMaterial(Player player, Placeholders placeholders, OfflinePlayer offlinePlayer) {
        String papiMaterial = this.papi(placeholders.parse(this.material), (OfflinePlayer)(offlinePlayer == null ? player : offlinePlayer), true);
        try {
            return this.getMaterial(Integer.parseInt(papiMaterial));
        }
        catch (Exception exception) {
            try {
                return papiMaterial != null ? Material.getMaterial((String)papiMaterial.toUpperCase()) : null;
            }
            catch (Exception ignored) {
                return null;
            }
        }
    }

    private ItemStack resolveCustomItem(Player player, Placeholders placeholders, Material material) {
        String[] values;
        String papiMaterial = this.papi(placeholders.parse(this.material), (OfflinePlayer)player, true);
        if (material != null && !material.equals((Object)Material.AIR)) {
            return null;
        }
        if (papiMaterial != null && papiMaterial.contains(":") && (values = papiMaterial.split(":", 2)).length == 2) {
            String key = values[0];
            String value = values[1];
            Optional<MaterialLoader> optional = this.inventoryManager.getMaterialLoader(key);
            if (optional.isPresent()) {
                MaterialLoader loader = optional.get();
                return loader.load(player, null, this.path, value);
            }
        }
        return null;
    }

    private ItemStack createDefaultItemStack(Player player, Material material, int amount) {
        if (material == null) {
            material = Material.STONE;
        }
        return this.data != null && !this.data.isEmpty() ? new ItemStack(material, amount, (short)Byte.parseByte(this.papi(this.data, (OfflinePlayer)player, false))) : new ItemStack(material);
    }

    private ItemStack applySpecialItemStack(Player player, int amount, ItemStack itemStack) {
        String urlResult;
        if (this.url != null && !this.url.equalsIgnoreCase("null") && (urlResult = this.papi(this.url, (OfflinePlayer)player, false)) != null) {
            itemStack = this.createSkull(urlResult);
        }
        if (this.potion != null) {
            itemStack = this.potion.toItemStack(amount);
        }
        if (this.banner != null) {
            itemStack = this.banner.toItemStack(amount);
        }
        if (this.firework != null) {
            itemStack = this.firework.toItemStack(amount);
        }
        if (this.leatherArmor != null) {
            itemStack = this.leatherArmor.toItemStack(amount);
        }
        return itemStack;
    }

    private void applyItemMeta(Player player, Placeholders placeholders, OfflinePlayer offlinePlayer, boolean useCache, ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        Material finalMaterial = itemStack.getType();
        String locale = this.findPlayerLocale(player);
        FontImage fontImage = this.inventoryManager.getFontImage();
        this.applyDisplayNameLore(player, placeholders, itemMeta, offlinePlayer, locale, fontImage, useCache);
        this.applyGlowing(itemMeta);
        this.applyCustomModelData(player, placeholders, offlinePlayer, itemMeta);
        this.applyEnchantments(finalMaterial, itemMeta);
        this.applyFlags(itemMeta);
        this.applyVersionSpecificMeta(itemStack, itemMeta, player, placeholders);
        itemStack.setItemMeta(itemMeta);
    }

    private void applyGlowing(ItemMeta itemMeta) {
        if (!this.isGlowing) {
            return;
        }
        Enchantments helperEnchantments = this.inventoryManager.getEnchantments();
        helperEnchantments.getEnchantments("power").ifPresent(menuEnchantment -> {
            itemMeta.addEnchant(menuEnchantment.enchantment(), 1, true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        });
    }

    private void applyCustomModelData(Player player, Placeholders placeholders, OfflinePlayer offlinePlayer, ItemMeta itemMeta) {
        try {
            int customModelData = Integer.parseInt(this.papi(placeholders.parse(this.modelID), (OfflinePlayer)(offlinePlayer == null ? player : offlinePlayer), true));
            if (customModelData != 0) {
                itemMeta.setCustomModelData(Integer.valueOf(customModelData));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void applyEnchantments(Material finalMaterial, ItemMeta itemMeta) {
        this.enchantments.forEach((enchantment, level) -> {
            if (finalMaterial.equals((Object)Material.ENCHANTED_BOOK)) {
                ((EnchantmentStorageMeta)itemMeta).addStoredEnchant(enchantment, level.intValue(), true);
            } else {
                itemMeta.addEnchant(enchantment, level.intValue(), true);
            }
        });
    }

    private void applyFlags(ItemMeta itemMeta) {
        for (ItemFlag flag : this.flags) {
            if (flag == null) continue;
            itemMeta.addItemFlags(new ItemFlag[]{flag});
        }
    }

    private void applyVersionSpecificMeta(ItemStack itemStack, ItemMeta itemMeta, Player player, Placeholders placeholders) {
        if (NmsVersion.getCurrentVersion().isNewItemStackAPI()) {
            this.buildNewItemStackAPI(itemStack, itemMeta, player, placeholders);
        }
        if (NmsVersion.getCurrentVersion().isNewHeadApi()) {
            this.buildTrimAPI(itemStack, itemMeta, player, placeholders);
        }
        if (this.clearDefaultAttributes && this.attributes.isEmpty() && NmsVersion.getCurrentVersion().getVersion() >= NmsVersion.V_1_20_4.getVersion()) {
            itemMeta.setAttributeModifiers((Multimap)ArrayListMultimap.create());
        }
    }

    private void applyAttributes(ItemStack itemStack) {
        if (itemStack.getType() == Material.AIR) {
            return;
        }
        AttributeUtil.applyAttributes(itemStack, this.attributes, this.inventoryManager.getPlugin(), this.attributeMergeStrategy);
    }

    private void applyDisplayNameLore(Player player, Placeholders placeholders, ItemMeta itemMeta, OfflinePlayer offlinePlayer, String locale, FontImage fontImage, boolean useCache) {
        String itemName = null;
        ArrayList<String> itemLore = new ArrayList<String>();
        if (this.displayName != null) {
            try {
                String displayName = locale == null ? this.displayName : this.translatedDisplayName.getOrDefault(locale, this.displayName);
                itemName = fontImage.replace(this.papi(placeholders.parse(displayName), (OfflinePlayer)(offlinePlayer == null ? player : offlinePlayer), useCache));
            }
            catch (Exception exception) {
                Logger.info("Error with update display name for item " + this.path + " in file " + this.filePath + " (" + String.valueOf(player) + ", " + this.displayName + ")", Logger.LogType.ERROR);
                exception.printStackTrace();
            }
        }
        if (!this.lore.isEmpty()) {
            List<String> lore = this.papi(placeholders.parse(locale == null ? this.lore : this.translatedLore.getOrDefault(locale, this.lore)), (OfflinePlayer)(offlinePlayer == null ? player : offlinePlayer), useCache);
            ArrayList<String> flattened = new ArrayList<String>();
            for (String str : lore) {
                String[] parts;
                for (String part : parts = str.split("\n")) {
                    flattened.add(fontImage.replace(part));
                }
            }
            itemLore = flattened;
        }
        if (itemName != null) {
            this.inventoryManager.getMeta().updateDisplayName(itemMeta, itemName, player);
        }
        if (!itemLore.isEmpty()) {
            this.inventoryManager.getMeta().updateLore(itemMeta, itemLore, this.loreType);
        }
    }

    private void buildNewItemStackAPI(ItemStack itemStack, ItemMeta itemMeta, Player player, Placeholders placeholders) {
        String[] equippedModelSplit;
        String[] itemModelSplit;
        String[] tooltipstyleSplit;
        if (this.maxStackSize > 0 && this.maxStackSize != itemStack.getMaxStackSize()) {
            itemMeta.setMaxStackSize(Integer.valueOf(this.maxStackSize));
        }
        if (itemMeta instanceof Damageable) {
            ItemFlag[] damageable = (ItemFlag[])itemMeta;
            if (this.maxDamage > 0) {
                damageable.setMaxDamage(Integer.valueOf(this.maxDamage));
            }
            if (this.damage != 0) {
                damageable.setDamage(this.damage);
            }
            if (this.unbreakableEnabled != null) {
                damageable.setUnbreakable(this.unbreakableEnabled.booleanValue());
                if (this.unbreakableShowInTooltip != null && !this.unbreakableShowInTooltip.booleanValue()) {
                    itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
                }
            }
        }
        if (itemMeta instanceof Repairable && this.repairCost > 0) {
            ((Repairable)itemMeta).setRepairCost(this.repairCost);
        }
        if (this.hideTooltip != null) {
            itemMeta.setHideTooltip(this.hideTooltip.booleanValue());
        }
        if (this.hideAdditionalTooltip != null && this.hideAdditionalTooltip.booleanValue()) {
            for (ItemFlag value : ItemFlag.values()) {
                itemMeta.addItemFlags(new ItemFlag[]{value});
            }
        }
        if (this.enchantmentShowInTooltip != null && !this.enchantmentShowInTooltip.booleanValue()) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (this.enchantmentGlint != null) {
            itemMeta.setEnchantmentGlintOverride(this.enchantmentGlint);
        }
        if (this.fireResistant != null) {
            itemMeta.setFireResistant(this.fireResistant.booleanValue());
        }
        if (this.attributeShowInTooltip != null && !this.attributeShowInTooltip.booleanValue()) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (this.itemRarity != null) {
            itemMeta.setRarity(this.itemRarity.getItemRarity());
        }
        if (this.tooltipStyle != null && (tooltipstyleSplit = this.tooltipStyle.split(":", 2)).length == 2) {
            itemMeta.setTooltipStyle(new NamespacedKey(tooltipstyleSplit[0], tooltipstyleSplit[1]));
        }
        if (this.itemModel != null && (itemModelSplit = this.itemModel.split(":", 2)).length == 2) {
            itemMeta.setItemModel(new NamespacedKey(itemModelSplit[0], itemModelSplit[1]));
        }
        if (this.equippedModel != null && (equippedModelSplit = this.equippedModel.split(":", 2)).length == 2) {
            EquippableComponent equippable = itemMeta.getEquippable();
            equippable.setModel(new NamespacedKey(equippedModelSplit[0], equippedModelSplit[1]));
            itemMeta.setEquippable(equippable);
        }
    }

    private void buildTrimAPI(ItemStack itemStack, ItemMeta itemMeta, Player player, Placeholders placeholders) {
        if (itemMeta instanceof ArmorMeta && this.trimConfiguration != null) {
            ((ArmorMeta)itemMeta).setTrim(new ArmorTrim(this.trimConfiguration.getMaterial(), this.trimConfiguration.getPattern()));
        }
    }

    @Override
    public String getTargetPlayer() {
        return this.targetPlayer;
    }

    @Override
    public void setTargetPlayer(String targetPlayer) {
        this.targetPlayer = targetPlayer;
    }

    @Override
    public String getMaterial() {
        return this.material;
    }

    @Override
    public void setMaterial(String material) {
        this.material = material;
        this.updatePlaceholder(material);
    }

    @Override
    public String getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(String amount) {
        this.amount = amount;
        this.updatePlaceholder(amount);
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public void setData(String data) {
        this.data = data;
    }

    @Override
    public int getDurability() {
        return this.durability;
    }

    @Override
    public void setDurability(int durability) {
        this.durability = durability;
    }

    @Override
    public Potion getPotion() {
        return this.potion;
    }

    @Override
    public void setPotion(Potion potion) {
        this.potion = potion;
    }

    @Override
    public List<String> getLore() {
        return this.lore;
    }

    @Override
    public void setLore(List<String> lore) {
        this.lore = lore;
        lore.forEach(this::updatePlaceholder);
    }

    @Override
    public List<ItemFlag> getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(List<ItemFlag> flags) {
        this.flags = flags;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updatePlaceholder(displayName);
    }

    @Override
    public boolean isGlowing() {
        return this.isGlowing;
    }

    @Override
    public void setGlowing(boolean isGlowing) {
        this.isGlowing = isGlowing;
    }

    @Override
    public String getModelID() {
        return this.modelID;
    }

    @Override
    public void setModelID(String modelID) {
        this.modelID = modelID;
        this.updatePlaceholder(modelID);
    }

    @Override
    public void setModelID(int modelID) {
        this.modelID = String.valueOf(modelID);
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public List<AttributeWrapper> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<AttributeWrapper> attributes) {
        this.attributes = attributes;
    }

    @Override
    public AttributeMergeStrategy getAttributeMergeStrategy() {
        return this.attributeMergeStrategy;
    }

    @Override
    public void setAttributeMergeStrategy(AttributeMergeStrategy attributeMergeStrategy) {
        this.attributeMergeStrategy = attributeMergeStrategy;
    }

    @Override
    public Banner getBanner() {
        return this.banner;
    }

    @Override
    public void setBanner(Banner banner) {
        this.banner = banner;
    }

    @Override
    public Firework getFirework() {
        return this.firework;
    }

    @Override
    public void setFirework(Firework firework) {
        this.firework = firework;
    }

    @Override
    public LeatherArmor getLeatherArmor() {
        return this.leatherArmor;
    }

    @Override
    public void setLeatherArmor(LeatherArmor leatherArmor) {
        this.leatherArmor = leatherArmor;
    }

    @Override
    public String getToolTipStyle() {
        return this.tooltipStyle;
    }

    @Override
    public void setToolTipStyle(String toolTipStyle) {
        this.tooltipStyle = toolTipStyle;
    }

    @Override
    public String getItemModel() {
        return this.itemModel;
    }

    @Override
    public void setItemModel(String itemModel) {
        this.itemModel = itemModel;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int parseAmount(Player player) {
        int amount = 1;
        try {
            amount = Integer.parseInt(this.papi(this.amount, (OfflinePlayer)player, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amount;
    }

    @Override
    public int parseAmount(Player player, Placeholders placeholders) {
        int amount = 1;
        try {
            amount = Integer.parseInt(this.papi(placeholders.parse(this.amount), (OfflinePlayer)player, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amount;
    }

    @Override
    public int parseAmount(OfflinePlayer offlinePlayer, Placeholders placeholders) {
        int amount = 1;
        try {
            amount = Integer.parseInt(this.papi(placeholders.parse(this.amount), offlinePlayer, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amount;
    }

    private void updatePlaceholder(String string) {
        if (string == null || this.needPlaceholderAPI) {
            return;
        }
        this.needPlaceholderAPI = string.contains("%");
    }

    public void setTypeMapAccessor(MapConfiguration configuration) {
        List<?> attributesFromConfig;
        Object object;
        List<String> lore;
        this.setData(configuration.getString("data", "0"));
        this.setDurability(configuration.getInt("durability", 0));
        this.setAmount(configuration.getString("amount", "1"));
        this.setMaterial(configuration.getString("material", null));
        this.setTargetPlayer(configuration.getString("target", null));
        this.setUrl(configuration.getString("url", null));
        Color potionColor = this.getColor(configuration, "color", null);
        try {
            Material material = Material.valueOf((String)configuration.getString("material", "").toUpperCase());
            String materialName = material.toString();
            if (materialName.startsWith("LEATHER_")) {
                Color armorColor = this.getColor(configuration, "color", Color.fromRGB((int)160, (int)101, (int)64));
                String type = materialName.replace("LEATHER_", "");
                this.setLeatherArmor(new LeatherArmor(LeatherArmor.ArmorType.valueOf(type), armorColor));
            }
        }
        catch (Exception material) {
            // empty catch block
        }
        if (configuration.contains("potion")) {
            PotionType type = PotionType.valueOf((String)configuration.getString("potion", "REGEN").toUpperCase());
            int level = configuration.getInt("level", 1);
            boolean splash = configuration.getBoolean("splash", false);
            boolean extended = configuration.getBoolean("extended", false);
            boolean arrow = configuration.getBoolean("arrow", false);
            Potion potion = new Potion(type, level, splash, extended, arrow);
            potion.setColor(potionColor);
            this.setPotion(potion);
        }
        if (configuration.contains("banner")) {
            DyeColor dyeColor = DyeColor.valueOf((String)configuration.getString("banner", "WHITE").toUpperCase());
            List<String> stringPattern = configuration.getStringList("patterns");
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String string : stringPattern) {
                String[] split = string.split(":");
                if (split.length != 2) continue;
                patterns.add(new Pattern(DyeColor.valueOf((String)split[0]), PatternType.valueOf((String)split[1])));
            }
            this.setBanner(new Banner(dyeColor, patterns));
        }
        if ((lore = configuration.getStringList("lore")).isEmpty() && (object = configuration.getObject("lore", null)) instanceof String) {
            String loreString = (String)object;
            lore = Arrays.asList(loreString.split("\n"));
        }
        this.setLore(lore);
        this.setDisplayName(configuration.getString("name", null));
        this.setGlowing(configuration.getBoolean("glow"));
        this.setModelID(configuration.getString("modelID", configuration.getString("model-id", configuration.getString("modelId", configuration.getString("customModelId", configuration.getString("customModelData", "0"))))));
        List<String> enchants = configuration.getStringList("enchants");
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (String enchantString : enchants) {
            try {
                int level;
                String[] splitEnchant = enchantString.split(",");
                if (splitEnchant.length == 1) {
                    throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString);
                }
                String enchant = splitEnchant[0];
                try {
                    level = Integer.parseInt(splitEnchant[1]);
                }
                catch (NumberFormatException e) {
                    throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString);
                }
                Enchantment enchantment = Enchantment.getByName((String)enchant);
                if (enchantment == null) {
                    throw new ItemEnchantException("an error occurred while loading the enchantment " + enchantString);
                }
                enchantments.put(enchantment, level);
            }
            catch (ItemEnchantException e) {
                e.printStackTrace();
            }
        }
        List<String> flagStrings = configuration.getStringList("flags");
        ArrayList<ItemFlag> flags = new ArrayList<ItemFlag>(flagStrings.size());
        for (String flag : flagStrings) {
            flags.add(this.getFlag(flag));
        }
        ArrayList<AttributeWrapper> attributeModifiers = new ArrayList<AttributeWrapper>();
        if (configuration.contains("attributes") && (attributesFromConfig = configuration.getList("attributes")) != null) {
            for (Map attributeMap : attributesFromConfig) {
                attributeModifiers.add(AttributeWrapper.deserialize(attributeMap));
            }
        }
        this.setEnchantments(enchantments);
        this.setFlags(flags);
        this.setAttributes(attributeModifiers);
        this.setAttributeMergeStrategy(AttributeMergeStrategy.valueOf(configuration.getString("attribute-merge-strategy", "REPLACE").toUpperCase()));
    }

    private Color getColor(MapConfiguration configuration, String key, Color def) {
        String[] split = configuration.getString(key, "").split(",");
        if (split.length == 3) {
            return Color.fromRGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2]));
        }
        if (split.length == 4) {
            return Color.fromARGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2]), (int)Integer.parseInt(split[3]));
        }
        return def;
    }

    private List<Color> getColors(MapConfiguration section, String key) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String color : section.getStringList(key)) {
            String[] split = color.split(",");
            if (split.length == 3) {
                colors.add(Color.fromRGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2])));
                continue;
            }
            if (split.length != 4) continue;
            colors.add(Color.fromARGB((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[2]), (int)Integer.parseInt(split[3])));
        }
        return colors;
    }

    @Override
    public Map<String, String> getTranslatedDisplayName() {
        return this.translatedDisplayName;
    }

    @Override
    public void setTranslatedDisplayName(Map<String, String> translatedDisplayName) {
        this.translatedDisplayName = translatedDisplayName;
    }

    @Override
    public Map<String, List<String>> getTranslatedLore() {
        return this.translatedLore;
    }

    @Override
    public void setTranslatedLore(Map<String, List<String>> translatedLore) {
        this.translatedLore = translatedLore;
    }

    @Override
    public boolean isNeedPlaceholderAPI() {
        return this.needPlaceholderAPI;
    }

    @Override
    public void setNeedPlaceholderAPI(boolean needPlaceholderAPI) {
        this.needPlaceholderAPI = needPlaceholderAPI;
    }

    @Override
    public ItemStack getCacheItemStack() {
        return this.cacheItemStack;
    }

    @Override
    public void setCacheItemStack(ItemStack cacheItemStack) {
        this.cacheItemStack = cacheItemStack;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    @Override
    public int getMaxDamage() {
        return this.maxDamage;
    }

    @Override
    public void setMaxDamage(int maxDamage) {
        this.maxDamage = maxDamage;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(int damage) {
        this.damage = damage;
    }

    @Override
    public int getRepairCost() {
        return this.repairCost;
    }

    @Override
    public void setRepairCost(int repairCost) {
        this.repairCost = repairCost;
    }

    @Override
    public boolean isUnbreakableEnabled() {
        return this.unbreakableEnabled;
    }

    @Override
    public void setUnbreakableEnabled(Boolean unbreakableEnabled) {
        this.unbreakableEnabled = unbreakableEnabled;
    }

    @Override
    public boolean isUnbreakableShowInTooltip() {
        return this.unbreakableShowInTooltip;
    }

    @Override
    public void setUnbreakableShowInTooltip(Boolean unbreakableShowInTooltip) {
        this.unbreakableShowInTooltip = unbreakableShowInTooltip;
    }

    @Override
    public boolean isFireResistant() {
        return this.fireResistant;
    }

    @Override
    public void setFireResistant(Boolean fireResistant) {
        this.fireResistant = fireResistant;
    }

    @Override
    public boolean isHideTooltip() {
        return this.hideTooltip;
    }

    @Override
    public void setHideTooltip(Boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
    }

    @Override
    public boolean isHideAdditionalTooltip() {
        return this.hideAdditionalTooltip;
    }

    @Override
    public void setHideAdditionalTooltip(Boolean hideAdditionalTooltip) {
        this.hideAdditionalTooltip = hideAdditionalTooltip;
    }

    @Override
    public boolean isEnchantmentGlint() {
        return this.enchantmentGlint;
    }

    @Override
    public void setEnchantmentGlint(Boolean enchantmentGlint) {
        this.enchantmentGlint = enchantmentGlint;
    }

    @Override
    public boolean isEnchantmentShowInTooltip() {
        return this.enchantmentShowInTooltip;
    }

    @Override
    public void setEnchantmentShowInTooltip(Boolean enchantmentShowInTooltip) {
        this.enchantmentShowInTooltip = enchantmentShowInTooltip;
    }

    @Override
    public boolean isAttributeShowInTooltip() {
        return this.attributeShowInTooltip;
    }

    @Override
    public void setAttributeShowInTooltip(Boolean attributeShowInTooltip) {
        this.attributeShowInTooltip = attributeShowInTooltip;
    }

    @Override
    public MenuItemRarity getItemRarity() {
        return this.itemRarity;
    }

    @Override
    public void setItemRarity(MenuItemRarity itemRarity) {
        this.itemRarity = itemRarity;
    }

    @Override
    public TrimConfiguration getTrimConfiguration() {
        return this.trimConfiguration;
    }

    @Override
    public void setTrimConfiguration(TrimConfiguration trimConfiguration) {
        this.trimConfiguration = trimConfiguration;
    }

    @Override
    public boolean isCenterLore() {
        return this.centerLore;
    }

    @Override
    public void setCenterLore(boolean centerLore) {
        this.centerLore = centerLore;
    }

    @Override
    public boolean isCenterName() {
        return this.centerName;
    }

    @Override
    public void setCenterName(boolean centerName) {
        this.centerName = centerName;
    }

    @Override
    public LoreType getLoreType() {
        return this.loreType;
    }

    @Override
    public void setLoreType(LoreType loreType) {
        this.loreType = loreType;
    }

    @Override
    public String getEquippedModel() {
        return this.equippedModel;
    }

    @Override
    public void setEquippedModel(String equippedModel) {
        this.equippedModel = equippedModel;
    }

    @Override
    public boolean isClearDefaultAttributes() {
        return this.clearDefaultAttributes;
    }

    @Override
    public void setClearDefaultAttributes(boolean clearDefaultAttributes) {
        this.clearDefaultAttributes = clearDefaultAttributes;
    }
}

