/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu;

import fr.maxlego08.menu.ZButtonManager;
import fr.maxlego08.menu.ZCommandManager;
import fr.maxlego08.menu.ZInventoryManager;
import fr.maxlego08.menu.ZItemManager;
import fr.maxlego08.menu.api.ButtonManager;
import fr.maxlego08.menu.api.DialogManager;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.ItemManager;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.attribute.ApplySpigotAttribute;
import fr.maxlego08.menu.api.attribute.AttributApplier;
import fr.maxlego08.menu.api.command.CommandManager;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.configuration.dialog.ConfigDialogBuilder;
import fr.maxlego08.menu.api.dupe.DupeManager;
import fr.maxlego08.menu.api.enchantment.Enchantments;
import fr.maxlego08.menu.api.font.FontImage;
import fr.maxlego08.menu.api.interfaces.ReturnBiConsumer;
import fr.maxlego08.menu.api.pattern.PatternManager;
import fr.maxlego08.menu.api.players.DataManager;
import fr.maxlego08.menu.api.players.inventory.InventoriesPlayer;
import fr.maxlego08.menu.api.storage.StorageManager;
import fr.maxlego08.menu.api.utils.MetaUpdater;
import fr.maxlego08.menu.api.utils.toast.ToastHelper;
import fr.maxlego08.menu.api.website.WebsiteManager;
import fr.maxlego08.menu.command.VCommandManager;
import fr.maxlego08.menu.command.commands.CommandMenu;
import fr.maxlego08.menu.config.ConfigManager;
import fr.maxlego08.menu.dupe.DupeListener;
import fr.maxlego08.menu.dupe.NMSDupeManager;
import fr.maxlego08.menu.dupe.PDCDupeManager;
import fr.maxlego08.menu.enchantment.ZEnchantments;
import fr.maxlego08.menu.font.EmptyFont;
import fr.maxlego08.menu.hooks.ApplyPaperAttribute;
import fr.maxlego08.menu.hooks.BreweryXLoader;
import fr.maxlego08.menu.hooks.ComponentMeta;
import fr.maxlego08.menu.hooks.CraftEngineLoader;
import fr.maxlego08.menu.hooks.EcoLoader;
import fr.maxlego08.menu.hooks.HmccosmeticsLoader;
import fr.maxlego08.menu.hooks.MagicCosmeticsLoader;
import fr.maxlego08.menu.hooks.NexoLoader;
import fr.maxlego08.menu.hooks.NextGensGeneratorLoader;
import fr.maxlego08.menu.hooks.NovaLoader;
import fr.maxlego08.menu.hooks.OraxenFont;
import fr.maxlego08.menu.hooks.OraxenLoader;
import fr.maxlego08.menu.hooks.SlimeFunLoader;
import fr.maxlego08.menu.hooks.ZHeadLoader;
import fr.maxlego08.menu.hooks.ZItemsLoader;
import fr.maxlego08.menu.hooks.dialogs.ZDialogManager;
import fr.maxlego08.menu.hooks.executableblocks.ExecutableBlocksLoader;
import fr.maxlego08.menu.hooks.executableitems.ExecutableItemsLoader;
import fr.maxlego08.menu.hooks.folialib.FoliaLib;
import fr.maxlego08.menu.hooks.folialib.impl.PlatformScheduler;
import fr.maxlego08.menu.hooks.headdatabase.HeadDatabaseLoader;
import fr.maxlego08.menu.hooks.itemsadder.ItemsAdderFont;
import fr.maxlego08.menu.hooks.itemsadder.ItemsAdderLoader;
import fr.maxlego08.menu.hooks.mythicmobs.MythicManager;
import fr.maxlego08.menu.hooks.mythicmobs.MythicMobsItemsLoader;
import fr.maxlego08.menu.inventory.VInventoryManager;
import fr.maxlego08.menu.inventory.inventories.InventoryDefault;
import fr.maxlego08.menu.listener.AdapterListener;
import fr.maxlego08.menu.listener.ItemUpdaterListener;
import fr.maxlego08.menu.listener.SwapKeyListener;
import fr.maxlego08.menu.loader.materials.ArmorLoader;
import fr.maxlego08.menu.loader.materials.Base64Loader;
import fr.maxlego08.menu.pattern.ZPatternManager;
import fr.maxlego08.menu.placeholder.LocalPlaceholder;
import fr.maxlego08.menu.placeholder.MenuPlaceholders;
import fr.maxlego08.menu.placeholder.Placeholder;
import fr.maxlego08.menu.players.ZDataManager;
import fr.maxlego08.menu.players.inventory.ZInventoriesPlayer;
import fr.maxlego08.menu.save.MessageLoader;
import fr.maxlego08.menu.storage.ZStorageManager;
import fr.maxlego08.menu.website.Token;
import fr.maxlego08.menu.website.ZWebsiteManager;
import fr.maxlego08.menu.zcore.ZPlugin;
import fr.maxlego08.menu.zcore.enums.EnumInventory;
import fr.maxlego08.menu.zcore.logger.Logger;
import fr.maxlego08.menu.zcore.utils.meta.ClassicMeta;
import fr.maxlego08.menu.zcore.utils.nms.NMSUtils;
import fr.maxlego08.menu.zcore.utils.nms.NmsVersion;
import fr.maxlego08.menu.zcore.utils.plugins.Metrics;
import fr.maxlego08.menu.zcore.utils.plugins.Plugins;
import fr.maxlego08.menu.zcore.utils.plugins.VersionChecker;
import fr.maxlego08.menu.zcore.utils.toast.ToastManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;

public class ZMenuPlugin
extends ZPlugin
implements MenuPlugin {
    private static ZMenuPlugin instance;
    private final StorageManager storageManager = new ZStorageManager(this);
    private final ButtonManager buttonManager = new ZButtonManager(this);
    private final InventoryManager inventoryManager = new ZInventoryManager(this);
    private final CommandManager commandManager = new ZCommandManager(this);
    private final MessageLoader messageLoader = new MessageLoader(this);
    private final DataManager dataManager = new ZDataManager(this);
    private final ZWebsiteManager websiteManager = new ZWebsiteManager(this);
    private final InventoriesPlayer inventoriesPlayer = new ZInventoriesPlayer(this);
    private final PatternManager patternManager = new ZPatternManager(this);
    private final Enchantments enchantments = new ZEnchantments();
    private final ItemManager itemManager = new ZItemManager(this);
    private final Map<String, Object> globalPlaceholders = new HashMap<String, Object>();
    private final ToastHelper toastHelper = new ToastManager(this);
    private final File configFile = new File(this.getDataFolder(), "config.yml");
    private DialogManager dialogManager;
    private CommandMenu commandMenu;
    private PlatformScheduler scheduler;
    private DupeManager dupeManager;
    private FontImage fontImage = new EmptyFont();
    private MetaUpdater metaUpdater = new ClassicMeta();
    private FoliaLib foliaLib;
    private AttributApplier attributApplier = new ApplySpigotAttribute();

    public static ZMenuPlugin getInstance() {
        return instance;
    }

    public void onLoad() {
    }

    public void onEnable() {
        instance = this;
        this.foliaLib = new FoliaLib(this);
        this.scheduler = this.foliaLib.getScheduler();
        this.dupeManager = NmsVersion.nmsVersion.isPdcVersion() ? new PDCDupeManager(this) : new NMSDupeManager();
        this.enchantments.register();
        this.preEnable();
        this.saveDefaultConfig();
        Config.getInstance().load(this.getConfig());
        this.storageManager.loadDatabase();
        this.addListener(this.storageManager);
        this.loadMeta();
        List<String> files = this.getInventoriesFiles();
        File folder = new File(this.getDataFolder(), "inventories");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (Config.generateDefaultFile) {
            files.forEach(filePath -> {
                if (!new File(this.getDataFolder(), (String)filePath).exists()) {
                    this.saveResource((String)filePath, false);
                }
            });
        }
        this.loadGlobalPlaceholders();
        this.zCommandManager = new VCommandManager(this);
        this.vinventoryManager = new VInventoryManager(this);
        ServicesManager servicesManager = this.getServer().getServicesManager();
        servicesManager.register(InventoryManager.class, (Object)this.inventoryManager, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(ButtonManager.class, (Object)this.buttonManager, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(CommandManager.class, (Object)this.commandManager, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(WebsiteManager.class, (Object)this.websiteManager, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(DataManager.class, (Object)this.dataManager, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(InventoriesPlayer.class, (Object)this.inventoriesPlayer, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(PatternManager.class, (Object)this.patternManager, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(DupeManager.class, (Object)this.dupeManager, (Plugin)this, ServicePriority.Highest);
        servicesManager.register(Enchantments.class, (Object)this.enchantments, (Plugin)this, ServicePriority.Highest);
        if (this.isPaper() && NmsVersion.getCurrentVersion().isDialogsVersion()) {
            Logger.info("Paper server detected, loading Dialogs support");
            ConfigManager configManager = new ConfigManager(this);
            this.dialogManager = new ZDialogManager(this, configManager);
            this.attributApplier = new ApplyPaperAttribute();
            servicesManager.register(DialogManager.class, (Object)this.dialogManager, (Plugin)this, ServicePriority.Highest);
            ConfigDialogBuilder configDialogBuilder = new ConfigDialogBuilder("zMenu Config", "zMenu Configuration");
            Logger.info(configDialogBuilder.getName());
            configManager.registerConfig(configDialogBuilder, Config.class, this);
        }
        this.registerInventory(EnumInventory.INVENTORY_DEFAULT, new InventoryDefault());
        this.commandMenu = new CommandMenu(this);
        this.registerCommand("zmenu", this.commandMenu, "zm");
        this.addListener(new SwapKeyListener());
        this.addListener(new AdapterListener(this));
        this.addListener(this.vinventoryManager);
        this.addListener(this.inventoriesPlayer);
        this.addListener(new ItemUpdaterListener(this.itemManager));
        this.addSimpleListener(this.inventoryManager);
        this.inventoryManager.registerMaterialLoader(new Base64Loader());
        this.inventoryManager.registerMaterialLoader(new ArmorLoader());
        this.registerHooks();
        this.inventoryManager.load();
        this.commandManager.loadCommands();
        this.messageLoader.load();
        this.inventoriesPlayer.loadInventories();
        this.dataManager.loadPlayers();
        this.itemManager.loadAll();
        LocalPlaceholder localPlaceholder = LocalPlaceholder.getInstance();
        localPlaceholder.register("argument_", (offlinePlayer, value) -> {
            Optional<String> optional = this.commandManager.getPlayerArgument(offlinePlayer.getUniqueId(), (String)value);
            return optional.orElse(null);
        });
        this.websiteManager.registerPlaceholders();
        new MenuPlaceholders().register(this);
        ((ZDataManager)this.dataManager).registerPlaceholder(localPlaceholder);
        new Metrics(this, 14951);
        File tokenFile = new File(this.getDataFolder(), "token.json");
        if (tokenFile.exists()) {
            Token.getInstance().load(this.getPersist());
        }
        new VersionChecker(this, 253).useLastVersion();
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        if (Config.enableAntiDupe) {
            this.addListener(new DupeListener(this.dupeManager));
        }
        if (!this.isActive(Plugins.ZMENUPLUS)) {
            Logger.info("");
            Logger.info("You can support zMenu by upgrading your account here: https://minecraft-inventory-builder.com/account-upgrade");
            Logger.info("zMenu\u2019s site includes an inventory editor (under development), a marketplace (already available) is a forum (under development)");
            Logger.info("");
        }
        this.websiteManager.loadPlaceholders();
        this.dataManager.loadDefaultValues();
        this.postEnable();
    }

    private void registerHooks() {
        if (this.isActive(Plugins.HEADDATABASE)) {
            this.inventoryManager.registerMaterialLoader(new HeadDatabaseLoader());
            this.getLogger().info("Registered HeadDatabase material loader");
        }
        if (this.isActive(Plugins.ZHEAD)) {
            this.inventoryManager.registerMaterialLoader(new ZHeadLoader(this));
            this.getLogger().info("Registered ZHead material loader");
        }
        if (this.isActive(Plugins.ORAXEN)) {
            this.inventoryManager.registerMaterialLoader(new OraxenLoader());
            this.fontImage = new OraxenFont();
            this.getLogger().info("Registered Oraxen material loader and font");
        }
        if (this.isActive(Plugins.CRAFTENGINE)) {
            this.inventoryManager.registerMaterialLoader(new CraftEngineLoader());
            this.getLogger().info("Registered CraftEngine material loader");
        }
        if (this.isActive(Plugins.NEXO)) {
            this.inventoryManager.registerMaterialLoader(new NexoLoader());
            this.getLogger().info("Registered Nexo material loader");
        }
        if (this.isActive(Plugins.MAGICCOSMETICS)) {
            this.inventoryManager.registerMaterialLoader(new MagicCosmeticsLoader());
            this.getLogger().info("Registered MagicCosmetics material loader");
        }
        if (this.isActive(Plugins.HMCCOSMETICS)) {
            this.inventoryManager.registerMaterialLoader(new HmccosmeticsLoader());
            this.getLogger().info("Registered HMC Cosmetics material loader");
        }
        if (this.isActive(Plugins.ITEMSADDER)) {
            this.inventoryManager.registerMaterialLoader(new ItemsAdderLoader(this));
            this.fontImage = new ItemsAdderFont();
            this.getLogger().info("Registered ItemsAdder material loader and font");
        }
        if (this.isActive(Plugins.SLIMEFUN)) {
            this.inventoryManager.registerMaterialLoader(new SlimeFunLoader());
            this.getLogger().info("Registered SlimeFun material loader");
        }
        if (this.isActive(Plugins.NOVA)) {
            this.inventoryManager.registerMaterialLoader(new NovaLoader());
            this.getLogger().info("Registered Nova material loader");
        }
        if (this.isActive(Plugins.ECO)) {
            this.inventoryManager.registerMaterialLoader(new EcoLoader());
            this.getLogger().info("Registered Eco material loader");
        }
        if (this.isActive(Plugins.ZITEMS)) {
            this.inventoryManager.registerMaterialLoader(new ZItemsLoader(this));
            this.getLogger().info("Registered zItems material loader");
        }
        if (this.isActive(Plugins.EXECUTABLE_ITEMS)) {
            this.inventoryManager.registerMaterialLoader(new ExecutableItemsLoader());
            this.getLogger().info("Registered ExecutableItems material loader");
        }
        if (this.isActive(Plugins.EXECUTABLE_BLOCKS)) {
            this.inventoryManager.registerMaterialLoader(new ExecutableBlocksLoader());
            this.getLogger().info("Registered ExecutableBlocks material loader");
        }
        if (this.isActive(Plugins.NEXTGENS)) {
            this.inventoryManager.registerMaterialLoader(new NextGensGeneratorLoader());
            this.getLogger().info("Registered NextGens material loader");
        }
        if (this.isActive(Plugins.MYTHICMOBS)) {
            this.inventoryManager.registerMaterialLoader(new MythicMobsItemsLoader());
            this.addListener(new MythicManager(this));
            this.getLogger().info("Registered MythicMobs material loader and listener");
        }
        if (this.isActive(Plugins.BREWERYX)) {
            this.inventoryManager.registerMaterialLoader(new BreweryXLoader());
        }
    }

    private List<String> getInventoriesFiles() {
        ArrayList<String> files = new ArrayList<String>();
        files.add("inventories/basic_inventory.yml");
        files.add("inventories/advanced_inventory.yml");
        files.add("inventories/pro_inventory.yml");
        files.add("inventories/example_punish.yml");
        files.add("inventories/examples/cookies.yml");
        files.add("inventories/examples/playtimes.yml");
        files.add("inventories/examples/switch.yml");
        files.add("commands/commands.yml");
        files.add("commands/punish/punish.yml");
        files.add("patterns/pattern_example.yml");
        files.add("patterns/pattern_cookies.yml");
        files.add("patterns/playtime_reward.yml");
        if (this.isPaper() && NmsVersion.getCurrentVersion().isDialogsVersion()) {
            files.add("dialogs/confirmation-dialog.yml");
            files.add("dialogs/default-dialog.yml");
            files.add("dialogs/multi_action-dialog.yml");
            files.add("dialogs/server_link-dialog.yml");
        }
        files.add("items/default-items.yml");
        return files;
    }

    public void onDisable() {
        this.preDisable();
        if (this.vinventoryManager != null) {
            this.vinventoryManager.close();
        }
        Config.getInstance().save(this.getConfig(), this.configFile);
        if (Token.token != null) {
            Token.getInstance().save(this.getPersist());
        }
        this.itemManager.unloadListeners();
        this.postDisable();
    }

    @Override
    public ButtonManager getButtonManager() {
        return this.buttonManager;
    }

    @Override
    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public MessageLoader getMessageLoader() {
        return this.messageLoader;
    }

    @Override
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public DialogManager getDialogManager() {
        return this.dialogManager;
    }

    @Override
    public ItemManager getItemManager() {
        return this.itemManager;
    }

    @Override
    public AttributApplier getAttributApplier() {
        return this.attributApplier;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public boolean isFolia() {
        return this.foliaLib.isFolia();
    }

    @Override
    public boolean isPaper() {
        return this.foliaLib.isPaper();
    }

    @Override
    public boolean isSpigot() {
        return this.foliaLib.isSpigot();
    }

    @Override
    public void registerPlaceholder(String startWith, ReturnBiConsumer<OfflinePlayer, String, String> biConsumer) {
        LocalPlaceholder.getInstance().register(startWith, biConsumer);
    }

    @Override
    public MenuItemStack loadItemStack(YamlConfiguration configuration, String path, File file) {
        return this.inventoryManager.loadItemStack(configuration, path, file);
    }

    public ZWebsiteManager getWebsiteManager() {
        return this.websiteManager;
    }

    public CommandMenu getCommandMenu() {
        return this.commandMenu;
    }

    @Override
    public DataManager getDataManager() {
        return this.dataManager;
    }

    @Override
    public PlatformScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public InventoriesPlayer getInventoriesPlayer() {
        return this.inventoriesPlayer;
    }

    @Override
    public PatternManager getPatternManager() {
        return this.patternManager;
    }

    @Override
    public DupeManager getDupeManager() {
        return this.dupeManager;
    }

    @Override
    public Enchantments getEnchantments() {
        return this.enchantments;
    }

    @Override
    public MetaUpdater getMetaUpdater() {
        return this.metaUpdater;
    }

    @Override
    public FontImage getFontImage() {
        return this.fontImage;
    }

    @Override
    public Map<String, Object> getGlobalPlaceholders() {
        return this.globalPlaceholders;
    }

    public void loadGlobalPlaceholders() {
        this.globalPlaceholders.clear();
        File file = new File(this.getDataFolder(), "global-placeholders.yml");
        if (!file.exists()) {
            this.saveResource("global-placeholders.yml", false);
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.getKeys(false).forEach(key -> this.globalPlaceholders.put((String)key, configuration.get(key)));
    }

    @Override
    public <T> T getProvider(Class<T> classPath) {
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(classPath);
        if (provider == null) {
            this.getLogger().info("Unable to retrieve the provider " + String.valueOf(classPath));
            return null;
        }
        return (T)provider.getProvider();
    }

    @Override
    public String parse(Player player, String string) {
        return Placeholder.Placeholders.getPlaceholder().setPlaceholders(player, string);
    }

    @Override
    public String parse(OfflinePlayer offlinePlayer, String string) {
        return Placeholder.Placeholders.getPlaceholder().setPlaceholders(offlinePlayer, string);
    }

    @Override
    public List<String> parse(Player player, List<String> strings) {
        return Placeholder.Placeholders.getPlaceholder().setPlaceholders(player, strings);
    }

    @Override
    public List<String> parse(OfflinePlayer offlinePlayer, List<String> strings) {
        return Placeholder.Placeholders.getPlaceholder().setPlaceholders(offlinePlayer, strings);
    }

    private void loadMeta() {
        if (!Config.enableMiniMessageFormat || !NMSUtils.isComponentColor()) {
            this.metaUpdater = new ClassicMeta();
            this.getLogger().info("Use ClassicMeta");
        } else {
            try {
                Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
                this.metaUpdater = new ComponentMeta(this);
                this.getLogger().info("Use ComponentMeta");
            }
            catch (Exception ignored) {
                this.metaUpdater = new ClassicMeta();
                this.getLogger().info("Use ClassicMeta");
            }
        }
    }

    @Override
    public ToastHelper getToastHelper() {
        return this.toastHelper;
    }

    public File getConfigFile() {
        return this.configFile;
    }
}

