/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.attribute;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.attribute.AttributApplier;
import fr.maxlego08.menu.api.attribute.AttributeEntry;
import fr.maxlego08.menu.api.attribute.AttributeMergeStrategy;
import fr.maxlego08.menu.api.attribute.AttributeUtil;
import fr.maxlego08.menu.api.attribute.AttributeWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ApplySpigotAttribute
implements AttributApplier {
    @Override
    public void applyAttributesModern(ItemStack itemStack, List<AttributeWrapper> attributes, MenuPlugin plugin, AttributeMergeStrategy strategy) {
        ItemMeta meta = itemStack.getItemMeta();
        ArrayList<AttributeEntry> existingEntries = new ArrayList<AttributeEntry>();
        if (meta.hasAttributeModifiers()) {
            for (Attribute attr : Attribute.values()) {
                Collection modifiers = meta.getAttributeModifiers(attr);
                if (modifiers == null || modifiers.isEmpty()) continue;
                for (AttributeModifier modifier : modifiers) {
                    existingEntries.add(new AttributeEntry(attr, modifier));
                }
            }
        }
        ArrayList<AttributeEntry> newEntries = new ArrayList<AttributeEntry>();
        for (AttributeWrapper wrapper : attributes) {
            AttributeModifier modifier = wrapper.toAttributeModifier(plugin);
            newEntries.add(new AttributeEntry(wrapper.attribute(), modifier));
        }
        List<AttributeEntry> resultEntries = AttributeUtil.mergeAttributes(existingEntries, newEntries, strategy);
        for (Attribute attr : Attribute.values()) {
            meta.removeAttributeModifier(attr);
        }
        for (AttributeEntry entry : resultEntries) {
            meta.addAttributeModifier(entry.attribute(), entry.modifier());
        }
        itemStack.setItemMeta(meta);
    }
}

