/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.attribute;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.attribute.AttributeEntry;
import fr.maxlego08.menu.api.attribute.AttributeMergeStrategy;
import fr.maxlego08.menu.api.attribute.AttributeWrapper;
import fr.maxlego08.menu.api.attribute.ModifierKey;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;

public final class AttributeUtil {
    private AttributeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void applyAttributes(ItemStack itemStack, List<AttributeWrapper> attributes, MenuPlugin plugin, AttributeMergeStrategy strategy) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        plugin.getAttributApplier().applyAttributesModern(itemStack, attributes, plugin, strategy);
    }

    public static List<AttributeEntry> mergeAttributes(List<AttributeEntry> existing, List<AttributeEntry> newEntries, AttributeMergeStrategy strategy) {
        ArrayList<AttributeEntry> result = new ArrayList<AttributeEntry>();
        switch (strategy) {
            case REPLACE: {
                result.addAll(newEntries);
                break;
            }
            case ADD: {
                result.addAll(existing);
                result.addAll(newEntries);
                break;
            }
            case KEEP_HIGHEST: {
                ArrayList<AttributeEntry> allEntries = new ArrayList<AttributeEntry>();
                allEntries.addAll(existing);
                allEntries.addAll(newEntries);
                Map<ModifierKey, List<AttributeEntry>> grouped = allEntries.stream().collect(Collectors.groupingBy(entry -> new ModifierKey(entry.attribute(), entry.modifier().getOperation(), entry.modifier().getSlotGroup())));
                for (Map.Entry<ModifierKey, List<AttributeEntry>> group : grouped.entrySet()) {
                    List<AttributeEntry> entries = group.getValue();
                    if (entries.isEmpty()) continue;
                    AttributeEntry highest = entries.stream().max(Comparator.comparingDouble(e -> e.modifier().getAmount())).orElse(entries.getFirst());
                    result.add(highest);
                }
                break;
            }
            case KEEP_LOWEST: {
                ArrayList<AttributeEntry> allEntries = new ArrayList<AttributeEntry>();
                allEntries.addAll(existing);
                allEntries.addAll(newEntries);
                Map<ModifierKey, List<AttributeEntry>> grouped = allEntries.stream().collect(Collectors.groupingBy(entry -> new ModifierKey(entry.attribute(), entry.modifier().getOperation(), entry.modifier().getSlotGroup())));
                for (Map.Entry<ModifierKey, List<AttributeEntry>> group : grouped.entrySet()) {
                    List<AttributeEntry> entries = group.getValue();
                    if (entries.isEmpty()) continue;
                    AttributeEntry lowest = entries.stream().min(Comparator.comparingDouble(e -> e.modifier().getAmount())).orElse(entries.getFirst());
                    result.add(lowest);
                }
                break;
            }
            case SUM: {
                ArrayList<AttributeEntry> allEntries = new ArrayList<AttributeEntry>();
                allEntries.addAll(existing);
                allEntries.addAll(newEntries);
                Map<ModifierKey, List<AttributeEntry>> grouped = allEntries.stream().collect(Collectors.groupingBy(entry -> new ModifierKey(entry.attribute(), entry.modifier().getOperation(), entry.modifier().getSlotGroup())));
                for (Map.Entry<ModifierKey, List<AttributeEntry>> group : grouped.entrySet()) {
                    List<AttributeEntry> entries = group.getValue();
                    if (entries.isEmpty()) continue;
                    double totalAmount = entries.stream().mapToDouble(e -> e.modifier().getAmount()).sum();
                    AttributeModifier first = entries.getFirst().modifier();
                    AttributeModifier summed = new AttributeModifier(first.getKey(), totalAmount, first.getOperation(), first.getSlotGroup());
                    result.add(new AttributeEntry(group.getKey().attribute(), summed));
                }
                break;
            }
        }
        return result;
    }
}

