/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.button;

import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.button.SlotButton;
import fr.maxlego08.menu.api.configuration.Config;
import fr.maxlego08.menu.api.utils.Placeholders;
import fr.maxlego08.menu.hooks.folialib.impl.PlatformScheduler;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public abstract class PerformButton
extends SlotButton {
    private List<String> commands = new ArrayList<String>();
    private List<String> leftCommands = new ArrayList<String>();
    private List<String> rightCommands = new ArrayList<String>();
    private List<String> consoleCommands = new ArrayList<String>();
    private List<String> consoleRightCommands = new ArrayList<String>();
    private List<String> consoleLeftCommands = new ArrayList<String>();
    private List<String> consolePermissionCommands = new ArrayList<String>();
    private String consolePermission;

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public List<String> getLeftCommands() {
        return this.leftCommands;
    }

    public void setLeftCommands(List<String> leftCommands) {
        this.leftCommands = leftCommands;
    }

    public List<String> getRightCommands() {
        return this.rightCommands;
    }

    public void setRightCommands(List<String> rightCommands) {
        this.rightCommands = rightCommands;
    }

    public List<String> getConsoleCommands() {
        return this.consoleCommands;
    }

    public void setConsoleCommands(List<String> consoleCommands) {
        this.consoleCommands = consoleCommands;
    }

    public List<String> getConsolePermissionCommands() {
        return this.consolePermissionCommands;
    }

    public void setConsolePermissionCommands(List<String> consolePermissionCommands) {
        this.consolePermissionCommands = consolePermissionCommands;
    }

    public String getConsolePermission() {
        return this.consolePermission;
    }

    public void setConsolePermission(String consolePermission) {
        this.consolePermission = consolePermission;
    }

    public List<String> getConsoleRightCommands() {
        return this.consoleRightCommands;
    }

    public void setConsoleRightCommands(List<String> consoleRightCommands) {
        this.consoleRightCommands = consoleRightCommands;
    }

    public List<String> getConsoleLeftCommands() {
        return this.consoleLeftCommands;
    }

    public void setConsoleLeftCommands(List<String> consoleLeftCommands) {
        this.consoleLeftCommands = consoleLeftCommands;
    }

    public void execute(MenuPlugin plugin, ClickType type, Placeholders placeholders, Player player) {
        PlatformScheduler scheduler = plugin.getScheduler();
        if (type.isRightClick()) {
            this.execute(plugin, player, this.rightCommands, scheduler, placeholders, (CommandSender)player);
            this.execute(plugin, player, this.consoleRightCommands, scheduler, placeholders, (CommandSender)player);
        }
        if (type.isLeftClick()) {
            this.execute(plugin, player, this.leftCommands, scheduler, placeholders, (CommandSender)player);
            this.execute(plugin, player, this.consoleLeftCommands, scheduler, placeholders, (CommandSender)player);
        }
        this.execute(plugin, player, this.commands, scheduler, placeholders, (CommandSender)player);
        this.execute(plugin, player, this.consoleCommands, scheduler, placeholders, (CommandSender)Bukkit.getConsoleSender());
        if (this.consolePermission == null || player.hasPermission(this.consolePermission)) {
            this.execute(plugin, player, this.consolePermissionCommands, scheduler, placeholders, (CommandSender)Bukkit.getConsoleSender());
        }
    }

    private void execute(MenuPlugin plugin, Player player, List<String> strings, PlatformScheduler scheduler, Placeholders placeholders, CommandSender executor) {
        strings.forEach(command -> {
            command = placeholders.parse(command.replace("%player%", player.getName()));
            try {
                if (executor instanceof Player && Config.enablePlayerCommandInChat) {
                    player.chat("/" + plugin.parse(player, (String)command));
                } else {
                    String finalCommand = command;
                    Runnable runnable = () -> Bukkit.dispatchCommand((CommandSender)executor, (String)plugin.parse(player, finalCommand));
                    if (plugin.isFolia()) {
                        if (executor instanceof Player) {
                            scheduler.runAtEntity((Entity)((Player)executor), w -> runnable.run());
                        } else {
                            scheduler.runNextTick(w -> runnable.run());
                        }
                    } else {
                        runnable.run();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }
}

