/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.configuration;

import fr.maxlego08.menu.api.configuration.annotation.ConfigOption;
import fr.maxlego08.menu.api.configuration.annotation.ConfigUpdate;
import fr.maxlego08.menu.api.enums.DialogInputType;
import fr.maxlego08.menu.api.utils.OpGrantMethod;
import fr.maxlego08.menu.zcore.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.inventory.ClickType;

public class Config {
    @ConfigOption(key="enableDebug", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable debug")
    public static boolean enableDebug = false;
    @ConfigOption(key="enableDebugTime", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable debug time")
    public static boolean enableDebugTime = false;
    @ConfigOption(key="enableInformationMessage", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable information message")
    public static boolean enableInformationMessage = true;
    @ConfigOption(key="enableLogStorageFile", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable log storage file")
    public static boolean enableLogStorageFile = false;
    @ConfigOption(key="skipUpdateCheck", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Skip update check")
    public static boolean skipUpdateCheck = false;
    @ConfigOption(key="enableOpenMessage", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable open message")
    public static boolean enableOpenMessage = true;
    @ConfigOption(key="enableMiniMessageFormat", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable mini message format")
    public static boolean enableMiniMessageFormat = true;
    @ConfigOption(key="enablePlayerCommandInChat", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable player command in chat")
    public static boolean enablePlayerCommandInChat = false;
    @ConfigOption(key="enableFastEvent", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable FastEvent")
    public static boolean enableFastEvent = false;
    @ConfigOption(key="secondsSavePlayerData", type=DialogInputType.NUMBER_RANGE, label="Seconds save player data", startRange=60.0f, endRange=3600.0f, stepRange=5.0f)
    public static int secondsSavePlayerData = 600;
    @ConfigOption(key="secondsSavePlayerInventories", type=DialogInputType.NUMBER_RANGE, label="Seconds save player inventories", startRange=60.0f, endRange=3600.0f, stepRange=5.0f)
    public static int secondsSavePlayerInventories = 600;
    public static String mainMenu = "example";
    @ConfigOption(key="useSwapItemOffHandKeyToOpenMainMenu", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Use swap item offhand key to open main menu")
    public static boolean useSwapItemOffHandKeyToOpenMainMenu = false;
    @ConfigOption(key="useSwapItemOffHandKeyToOpenMainMenuNeedsShift", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Use swap item offhand key to open main menu needs shift")
    public static boolean useSwapItemOffHandKeyToOpenMainMenuNeedsShift = false;
    public static List<String> specifyPathMenus = new ArrayList<String>();
    @ConfigOption(key="generateDefaultFile", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Generate default file")
    public static boolean generateDefaultFile = true;
    @ConfigOption(key="disableDoubleClickEvent", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Disable double click event")
    public static boolean disableDoubleClickEvent = true;
    @ConfigOption(key="enableAntiDupe", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable anti dupe")
    public static boolean enableAntiDupe = true;
    @ConfigOption(key="enableAntiDupeDiscordNotification", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable anti dupe discord notification")
    public static boolean enableAntiDupeDiscordNotification = false;
    @ConfigOption(key="antiDupeDiscordWebhookUrl", type=DialogInputType.TEXT, label="Anti dupe discord webhook url", maxLength=100)
    public static String antiDupeDiscordWebhookUrl = "https://discord.com/api/webhooks/<your discord webhook url>";
    @ConfigOption(key="antiDupeMessage", type=DialogInputType.TEXT, label="Anti dupe message", maxLength=200)
    public static String antiDupeMessage = "**%player%** use %amount% %itemname% which comes from zMenu. Removing it !";
    public static List<ClickType> allClicksType = Arrays.asList(ClickType.MIDDLE, ClickType.RIGHT, ClickType.LEFT, ClickType.SHIFT_RIGHT, ClickType.SHIFT_LEFT);
    @ConfigOption(key="enableCacheItemStack", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable cache item stack")
    public static boolean enableCacheItemStack = true;
    @ConfigOption(key="enableCooldownClick", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable cooldown click")
    public static boolean enableCooldownClick = true;
    @ConfigOption(key="cooldownClickMilliseconds", type=DialogInputType.NUMBER_RANGE, label="Cooldown click milliseconds", endRange=1000.0f, stepRange=10.0f)
    public static long cooldownClickMilliseconds = 100L;
    @ConfigOption(key="cachePlaceholderAPI", type=DialogInputType.NUMBER_RANGE, label="Cache PlaceholderAPI", endRange=300.0f, stepRange=5.0f)
    public static long cachePlaceholderAPI = 20L;
    @ConfigOption(key="enableCachePlaceholderAPI", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable cache PlaceholderAPI")
    public static boolean enableCachePlaceholderAPI = false;
    @ConfigOption(key="enableDownloadCommand", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable download command")
    public static boolean enableDownloadCommand = false;
    @ConfigOption(key="enablePlayerOpenInventoryLogs", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable player open inventory logs")
    public static boolean enablePlayerOpenInventoryLogs = true;
    @ConfigOption(key="enablePlayerCommandsAsOPAction", type=DialogInputType.BOOLEAN, trueText="<green>Enabled", falseText="<red>Disabled", label="Enable player commands as OP action (requires server restart)")
    public static boolean enablePlayerCommandsAsOPAction = false;
    public static OpGrantMethod opGrantMethod = OpGrantMethod.ATTACHMENT;
    public static boolean enableToast = true;
    @ConfigUpdate
    public static boolean updated = false;
    private static volatile Config instance;

    private Config() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getInstance() {
        if (instance != null) return instance;
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (instance != null) return instance;
            instance = new Config();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void load(FileConfiguration configuration) {
        enableDebug = configuration.getBoolean(ConfigPath.ENABLE_DEBUG.getPath());
        enableDebugTime = configuration.getBoolean(ConfigPath.ENABLE_DEBUG_TIME.getPath());
        enableInformationMessage = configuration.getBoolean(ConfigPath.ENABLE_INFORMATION_MESSAGE.getPath());
        enableLogStorageFile = configuration.getBoolean(ConfigPath.ENABLE_LOG_STORAGE_FILE.getPath());
        skipUpdateCheck = configuration.getBoolean(ConfigPath.SKIP_UPDATE_CHECK.getPath());
        enableOpenMessage = configuration.getBoolean(ConfigPath.ENABLE_OPEN_MESSAGE.getPath());
        enableMiniMessageFormat = configuration.getBoolean(ConfigPath.ENABLE_MINI_MESSAGE_FORMAT.getPath());
        enablePlayerCommandInChat = configuration.getBoolean(ConfigPath.ENABLE_PLAYER_COMMAND_IN_CHAT.getPath());
        enableFastEvent = configuration.getBoolean(ConfigPath.ENABLE_FAST_EVENT.getPath());
        secondsSavePlayerData = configuration.getInt(ConfigPath.SECONDS_SAVE_PLAYER_DATA.getPath());
        secondsSavePlayerInventories = configuration.getInt(ConfigPath.SECONDS_SAVE_PLAYER_INVENTORIES.getPath());
        mainMenu = configuration.getString(ConfigPath.MAIN_MENU.getPath());
        useSwapItemOffHandKeyToOpenMainMenu = configuration.getBoolean(ConfigPath.USE_SWAP_ITEM_OFF_HAND_KEY_TO_OPEN_MAIN_MENU.getPath());
        useSwapItemOffHandKeyToOpenMainMenuNeedsShift = configuration.getBoolean(ConfigPath.USE_SWAP_ITEM_OFF_HAND_KEY_TO_OPEN_MAIN_MENU_NEEDS_SHIFT.getPath());
        specifyPathMenus = configuration.getStringList(ConfigPath.SPECIFY_PATH_MENUS.getPath());
        generateDefaultFile = configuration.getBoolean(ConfigPath.GENERATE_DEFAULT_FILE.getPath());
        disableDoubleClickEvent = configuration.getBoolean(ConfigPath.DISABLE_DOUBLE_CLICK_EVENT.getPath());
        enableAntiDupe = configuration.getBoolean(ConfigPath.ENABLE_ANTI_DUPE.getPath());
        enableAntiDupeDiscordNotification = configuration.getBoolean(ConfigPath.ENABLE_ANTI_DUPE_DISCORD_NOTIFICATION.getPath());
        antiDupeDiscordWebhookUrl = configuration.getString(ConfigPath.ANTI_DUPE_DISCORD_WEBHOOK_URL.getPath());
        antiDupeMessage = configuration.getString(ConfigPath.ANTI_DUPE_MESSAGE.getPath());
        List clickTypeStrings = configuration.getStringList(ConfigPath.ALL_CLICKS_TYPE.getPath());
        ArrayList<ClickType> clickTypes = new ArrayList<ClickType>(clickTypeStrings.size());
        for (String name : clickTypeStrings) {
            try {
                clickTypes.add(ClickType.valueOf((String)name));
            }
            catch (IllegalArgumentException e) {
                Bukkit.getLogger().warning("[zMenu] Invalid click type in config: " + name);
            }
        }
        allClicksType = clickTypes;
        enableCacheItemStack = configuration.getBoolean(ConfigPath.ENABLE_CACHE_ITEM_STACK.getPath());
        enableCooldownClick = configuration.getBoolean(ConfigPath.ENABLE_COOLDOWN_CLICK.getPath());
        cooldownClickMilliseconds = configuration.getLong(ConfigPath.COOLDOWN_CLICK_MILLISECONDS.getPath());
        cachePlaceholderAPI = configuration.getLong(ConfigPath.CACHE_PLACEHOLDER_API.getPath());
        enableCachePlaceholderAPI = configuration.getBoolean(ConfigPath.ENABLE_CACHE_PLACEHOLDER_API.getPath());
        enableDownloadCommand = configuration.getBoolean(ConfigPath.ENABLE_DOWNLOAD_COMMAND.getPath());
        enablePlayerOpenInventoryLogs = configuration.getBoolean(ConfigPath.ENABLE_PLAYER_OPEN_INVENTORY_LOGS.getPath());
        enablePlayerCommandsAsOPAction = configuration.getBoolean(ConfigPath.ENABLE_PLAYER_COMMANDS_AS_OP_ACTION.getPath());
        try {
            opGrantMethod = OpGrantMethod.valueOf(configuration.getString(ConfigPath.OP_GRANT_METHOD.getPath(), OpGrantMethod.ATTACHMENT.name()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            Logger.info("Invalid op grant method in config, defaulting to ATTACHMENT.");
            opGrantMethod = OpGrantMethod.ATTACHMENT;
        }
        enableToast = configuration.getBoolean(ConfigPath.ENABLE_TOAST.getPath());
    }

    public void save(FileConfiguration configuration, File file) {
        if (!updated) {
            return;
        }
        configuration.set(ConfigPath.ENABLE_DEBUG.getPath(), (Object)enableDebug);
        configuration.set(ConfigPath.ENABLE_DEBUG_TIME.getPath(), (Object)enableDebugTime);
        configuration.set(ConfigPath.ENABLE_INFORMATION_MESSAGE.getPath(), (Object)enableInformationMessage);
        configuration.set(ConfigPath.ENABLE_LOG_STORAGE_FILE.getPath(), (Object)enableLogStorageFile);
        configuration.set(ConfigPath.SKIP_UPDATE_CHECK.getPath(), (Object)skipUpdateCheck);
        configuration.set(ConfigPath.ENABLE_OPEN_MESSAGE.getPath(), (Object)enableOpenMessage);
        configuration.set(ConfigPath.ENABLE_MINI_MESSAGE_FORMAT.getPath(), (Object)enableMiniMessageFormat);
        configuration.set(ConfigPath.ENABLE_PLAYER_COMMAND_IN_CHAT.getPath(), (Object)enablePlayerCommandInChat);
        configuration.set(ConfigPath.ENABLE_FAST_EVENT.getPath(), (Object)enableFastEvent);
        configuration.set(ConfigPath.SECONDS_SAVE_PLAYER_DATA.getPath(), (Object)secondsSavePlayerData);
        configuration.set(ConfigPath.SECONDS_SAVE_PLAYER_INVENTORIES.getPath(), (Object)secondsSavePlayerInventories);
        configuration.set(ConfigPath.MAIN_MENU.getPath(), (Object)mainMenu);
        configuration.set(ConfigPath.USE_SWAP_ITEM_OFF_HAND_KEY_TO_OPEN_MAIN_MENU.getPath(), (Object)useSwapItemOffHandKeyToOpenMainMenu);
        configuration.set(ConfigPath.USE_SWAP_ITEM_OFF_HAND_KEY_TO_OPEN_MAIN_MENU_NEEDS_SHIFT.getPath(), (Object)useSwapItemOffHandKeyToOpenMainMenuNeedsShift);
        configuration.set(ConfigPath.SPECIFY_PATH_MENUS.getPath(), specifyPathMenus);
        configuration.set(ConfigPath.GENERATE_DEFAULT_FILE.getPath(), (Object)generateDefaultFile);
        configuration.set(ConfigPath.DISABLE_DOUBLE_CLICK_EVENT.getPath(), (Object)disableDoubleClickEvent);
        configuration.set(ConfigPath.ENABLE_ANTI_DUPE.getPath(), (Object)enableAntiDupe);
        configuration.set(ConfigPath.ENABLE_ANTI_DUPE_DISCORD_NOTIFICATION.getPath(), (Object)enableAntiDupeDiscordNotification);
        configuration.set(ConfigPath.ANTI_DUPE_DISCORD_WEBHOOK_URL.getPath(), (Object)antiDupeDiscordWebhookUrl);
        configuration.set(ConfigPath.ANTI_DUPE_MESSAGE.getPath(), (Object)antiDupeMessage);
        ArrayList<String> clickTypeNames = new ArrayList<String>(allClicksType.size());
        for (ClickType clickType : allClicksType) {
            clickTypeNames.add(clickType.name());
        }
        configuration.set(ConfigPath.ALL_CLICKS_TYPE.getPath(), clickTypeNames);
        configuration.set(ConfigPath.ENABLE_CACHE_ITEM_STACK.getPath(), (Object)enableCacheItemStack);
        configuration.set(ConfigPath.ENABLE_COOLDOWN_CLICK.getPath(), (Object)enableCooldownClick);
        configuration.set(ConfigPath.COOLDOWN_CLICK_MILLISECONDS.getPath(), (Object)cooldownClickMilliseconds);
        configuration.set(ConfigPath.CACHE_PLACEHOLDER_API.getPath(), (Object)cachePlaceholderAPI);
        configuration.set(ConfigPath.ENABLE_CACHE_PLACEHOLDER_API.getPath(), (Object)enableCachePlaceholderAPI);
        configuration.set(ConfigPath.ENABLE_DOWNLOAD_COMMAND.getPath(), (Object)enableDownloadCommand);
        configuration.set(ConfigPath.ENABLE_PLAYER_OPEN_INVENTORY_LOGS.getPath(), (Object)enablePlayerOpenInventoryLogs);
        updated = false;
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Bukkit.getLogger().warning("[zMenu] Unable to save config file: " + e.getMessage());
        }
    }

    private static enum ConfigPath {
        ENABLE_DEBUG("enable-debug"),
        ENABLE_DEBUG_TIME("enable-debug-time"),
        ENABLE_INFORMATION_MESSAGE("enable-information-message"),
        ENABLE_LOG_STORAGE_FILE("enable-log-storage-file"),
        SKIP_UPDATE_CHECK("skip-update-check"),
        ENABLE_OPEN_MESSAGE("enable-open-message"),
        ENABLE_MINI_MESSAGE_FORMAT("enable-mini-message-format"),
        ENABLE_PLAYER_COMMAND_IN_CHAT("enable-player-command-in-chat"),
        ENABLE_FAST_EVENT("enable-fast-event"),
        SECONDS_SAVE_PLAYER_DATA("seconds-save-player-data"),
        SECONDS_SAVE_PLAYER_INVENTORIES("seconds-save-player-inventories"),
        MAIN_MENU("main-menu"),
        USE_SWAP_ITEM_OFF_HAND_KEY_TO_OPEN_MAIN_MENU("use-swap-item-off-hand-key-to-open-main-menu"),
        USE_SWAP_ITEM_OFF_HAND_KEY_TO_OPEN_MAIN_MENU_NEEDS_SHIFT("use-swap-item-off-hand-key-to-open-main-menu-needs-shift"),
        SPECIFY_PATH_MENUS("specify-path-menus"),
        GENERATE_DEFAULT_FILE("generate-default-file"),
        DISABLE_DOUBLE_CLICK_EVENT("disable-double-click-event"),
        ENABLE_ANTI_DUPE("enable-anti-dupe"),
        ENABLE_ANTI_DUPE_DISCORD_NOTIFICATION("enable-anti-dupe-discord-notification"),
        ANTI_DUPE_DISCORD_WEBHOOK_URL("anti-dupe-discord-webhook-url"),
        ANTI_DUPE_MESSAGE("anti-dupe-message"),
        ALL_CLICKS_TYPE("all-clicks-type"),
        ENABLE_CACHE_ITEM_STACK("enable-cache-item-stack"),
        ENABLE_COOLDOWN_CLICK("enable-cooldown-click"),
        COOLDOWN_CLICK_MILLISECONDS("cooldown-click-milliseconds"),
        CACHE_PLACEHOLDER_API("cache-placeholder-api"),
        ENABLE_CACHE_PLACEHOLDER_API("enable-cache-placeholder-api"),
        ENABLE_DOWNLOAD_COMMAND("enable-download-command"),
        ENABLE_PLAYER_OPEN_INVENTORY_LOGS("enable-player-open-inventory-logs"),
        ENABLE_PLAYER_COMMANDS_AS_OP_ACTION("enable-player-commands-as-op-action"),
        OP_GRANT_METHOD("op-grant-method"),
        ENABLE_TOAST("enable-toast");

        private final String path;

        private ConfigPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

