/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Pagination<T> {
    public List<T> paginateReverse(List<T> list, int inventorySize, int page) {
        if (list == null || list.isEmpty() || inventorySize <= 0) {
            return Collections.emptyList();
        }
        if (page <= 0) {
            page = 1;
        }
        ArrayList<T> currentList = new ArrayList<T>();
        int idStart = list.size() - (page - 1) * inventorySize - 1;
        int idEnd = Math.max(idStart - inventorySize + 1, 0);
        if (idStart < 0) {
            return Collections.emptyList();
        }
        for (int i = idStart; i >= idEnd; --i) {
            currentList.add(list.get(i));
        }
        return currentList;
    }

    public List<T> paginate(List<T> list, int size, int page) {
        int idStart;
        if (list == null || list.isEmpty() || size <= 0) {
            return Collections.emptyList();
        }
        if (page <= 0) {
            page = 1;
        }
        if ((idStart = (page - 1) * size) >= list.size()) {
            return Collections.emptyList();
        }
        int idEnd = Math.min(idStart + size, list.size());
        return list.subList(idStart, idEnd);
    }

    public List<T> paginateReverse(Map<?, T> map, int size, int page) {
        return map == null || map.isEmpty() ? Collections.emptyList() : this.paginateReverse(new ArrayList<T>(map.values()), size, page);
    }

    public List<T> paginate(Map<?, T> map, int size, int page) {
        return map == null || map.isEmpty() ? Collections.emptyList() : this.paginate(new ArrayList<T>(map.values()), size, page);
    }
}

