/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.itemstack;

import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class LeatherArmor {
    private ArmorType type;
    private Color color;

    public LeatherArmor(ArmorType type, Color color) {
        this.type = type;
        this.color = color;
    }

    public ArmorType getType() {
        return this.type;
    }

    public void setType(ArmorType type) {
        this.type = type;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public ItemStack toItemStack(int amount) {
        Material material = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Material.LEATHER_HELMET;
            case 1 -> Material.LEATHER_CHESTPLATE;
            case 2 -> Material.LEATHER_LEGGINGS;
            case 3 -> Material.LEATHER_BOOTS;
            case 4 -> Material.LEATHER_HORSE_ARMOR;
        };
        ItemStack stack = new ItemStack(material, amount);
        LeatherArmorMeta lam = (LeatherArmorMeta)stack.getItemMeta();
        lam.setColor(this.color);
        stack.setItemMeta((ItemMeta)lam);
        return stack;
    }

    public static enum ArmorType {
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS,
        HORSE_ARMOR;

    }
}

