/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.mechanic;

import fr.maxlego08.menu.api.ItemManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.mechanic.Mechanic;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public abstract class MechanicFactory {
    private final MenuPlugin plugin;
    private final ItemManager itemManager;
    private final String mechanicId;
    private final Map<String, Mechanic> mechanicByItemId = new HashMap<String, Mechanic>();

    public MechanicFactory(MenuPlugin plugin, String mechanicId) {
        this.plugin = plugin;
        this.mechanicId = mechanicId;
        this.itemManager = plugin.getItemManager();
    }

    public abstract Mechanic parse(MenuPlugin var1, String var2, ConfigurationSection var3, YamlConfiguration var4, File var5, String var6);

    public Mechanic getMechanic(String itemId) {
        return this.mechanicByItemId.get(itemId);
    }

    public void addToImplemented(Mechanic mechanic) {
        this.mechanicByItemId.put(mechanic.getItemId(), mechanic);
    }

    public boolean isNotImplementedIn(ItemStack itemStack) {
        Optional<String> itemId = this.itemManager.getItemId(itemStack);
        return itemId.filter(string -> !this.mechanicByItemId.containsKey(string)).isPresent();
    }

    public boolean isNotImplementedIn(String itemID) {
        return !this.mechanicByItemId.containsKey(itemID);
    }

    public String getMechanicId() {
        return this.mechanicId;
    }

    public Set<Map.Entry<String, Mechanic>> getAllMechanics() {
        return this.mechanicByItemId.entrySet();
    }

    public void clearMechanics() {
        this.mechanicByItemId.clear();
    }
}

