/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class OfflinePlayerCache {
    private static final Map<String, OfflinePlayer> offlinePlayer = new ConcurrentHashMap<String, OfflinePlayer>();

    @NotNull
    public static OfflinePlayer get(@NotNull String playerName) {
        return offlinePlayer.computeIfAbsent(playerName, name -> {
            Player player = Bukkit.getPlayer((String)name);
            return player != null ? player : Bukkit.getOfflinePlayer((String)name);
        });
    }

    public static void clearCache() {
        offlinePlayer.clear();
    }
}

