/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.api.utils.cuboid;

import fr.maxlego08.menu.api.utils.cuboid.Cuboid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class Region {
    private final List<Cuboid> cuboids;

    public Region() {
        this.cuboids = new ArrayList<Cuboid>();
    }

    public Region(List<Cuboid> cuboids) {
        this.cuboids = cuboids;
    }

    public Region(Cuboid ... cuboids) {
        this.cuboids = Arrays.asList(cuboids);
    }

    public void addCube(Cuboid cube) {
        this.cuboids.add(cube);
    }

    public boolean contains(Block block) {
        for (Cuboid cuboid : this.cuboids) {
            if (!cuboid.contains(block)) continue;
            return true;
        }
        return false;
    }

    public List<Cuboid> getCuboids() {
        return this.cuboids;
    }

    public Collection<Player> getPlayers() {
        LinkedHashSet<Player> players = new LinkedHashSet<Player>();
        for (Cuboid cuboid : this.cuboids) {
            players.addAll(cuboid.getPlayers());
        }
        return new ArrayList<Player>(players);
    }

    public Collection<LivingEntity> getEntities() {
        LinkedHashSet<LivingEntity> entities = new LinkedHashSet<LivingEntity>();
        for (Cuboid cuboid : this.cuboids) {
            entities.addAll(cuboid.getEntities());
        }
        return new ArrayList<LivingEntity>(entities);
    }

    public boolean contains(Location location) {
        for (Cuboid cuboid : this.cuboids) {
            if (!cuboid.contains(location)) continue;
            return true;
        }
        return false;
    }
}

