/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.button.buttons;

import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.button.buttons.SwitchButton;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.SwitchCaseButton;
import java.util.List;
import org.bukkit.entity.Player;

public class ZSwitchButton
extends SwitchButton {
    private final String placeholder;
    private final List<SwitchCaseButton> buttons;

    public ZSwitchButton(String placeholder, List<SwitchCaseButton> buttons) {
        this.placeholder = placeholder;
        this.buttons = buttons;
    }

    @Override
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public List<SwitchCaseButton> getButtons() {
        return this.buttons;
    }

    @Override
    public Button getDisplayButton(InventoryEngine inventoryEngine, Player player) {
        if (this.buttons.isEmpty()) {
            return super.getDisplayButton(inventoryEngine, player);
        }
        if (this.buttons.size() == 1) {
            return this.buttons.getFirst().button();
        }
        String result = inventoryEngine.getPlugin().parse(player, this.placeholder);
        for (SwitchCaseButton button : this.buttons) {
            String newValue;
            String value = button.value();
            if (value.startsWith(">=")) {
                newValue = value.substring(2);
                if (Integer.parseInt(result) < Integer.parseInt(newValue)) continue;
                return button.button();
            }
            if (value.startsWith("<=")) {
                newValue = value.substring(2);
                if (Integer.parseInt(result) > Integer.parseInt(newValue)) continue;
                return button.button();
            }
            if (value.startsWith(">")) {
                newValue = value.substring(1);
                if (Integer.parseInt(result) <= Integer.parseInt(newValue)) continue;
                return button.button();
            }
            if (value.startsWith("<")) {
                newValue = value.substring(1);
                if (Integer.parseInt(result) >= Integer.parseInt(newValue)) continue;
                return button.button();
            }
            if (!value.equals(result)) continue;
            return button.button();
        }
        return super.getDisplayButton(inventoryEngine, player);
    }
}

