/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.command.commands.players;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.command.VCommand;
import fr.maxlego08.menu.zcore.enums.Permission;
import fr.maxlego08.menu.zcore.utils.commands.CommandType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class CommandMenuPlayersConvert
extends VCommand {
    private final Map<UUID, Long> confirmationMap = new HashMap<UUID, Long>();

    public CommandMenuPlayersConvert(ZMenuPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ZMENU_PLAYERS);
        this.setDescription(Message.DESCRIPTION_PLAYERS_CONVERT);
        this.addSubCommand("convert");
        this.setConsoleCanUse(false);
    }

    @Override
    protected CommandType perform(ZMenuPlugin plugin) {
        UUID playerId = this.player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.confirmationMap.containsKey(playerId) && currentTime - this.confirmationMap.get(playerId) <= 30000L) {
            this.confirmationMap.remove(playerId);
            plugin.getDataManager().convertOldDatas(this.sender);
            this.message((MenuPlugin)plugin, this.sender, Message.PLAYERS_DATA_CONVERT_SUCCESS, new Object[0]);
        } else {
            this.confirmationMap.put(playerId, currentTime);
            this.message((MenuPlugin)plugin, this.sender, Message.PLAYERS_DATA_CONVERT_CONFIRM, new Object[0]);
            plugin.getScheduler().runLater(() -> this.confirmationMap.remove(playerId), 30L, TimeUnit.SECONDS);
        }
        return CommandType.SUCCESS;
    }
}

