/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.command.commands.players;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.players.Data;
import fr.maxlego08.menu.api.players.DataManager;
import fr.maxlego08.menu.api.players.PlayerData;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.command.VCommand;
import fr.maxlego08.menu.zcore.enums.Permission;
import fr.maxlego08.menu.zcore.utils.commands.CommandType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.OfflinePlayer;

public class CommandMenuPlayersKeys
extends VCommand {
    public CommandMenuPlayersKeys(ZMenuPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ZMENU_PLAYERS);
        this.setDescription(Message.DESCRIPTION_PLAYERS_KEYS);
        this.addSubCommand("keys");
        this.addRequireArg("player");
    }

    @Override
    protected CommandType perform(ZMenuPlugin plugin) {
        OfflinePlayer player;
        DataManager dataManager = plugin.getDataManager();
        Optional<PlayerData> optional = dataManager.getPlayer((player = this.argAsOfflinePlayer(0)).getUniqueId());
        if (optional.isEmpty()) {
            this.message((MenuPlugin)plugin, this.sender, Message.PLAYERS_DATA_KEYS_EMPTY, "%player%", player.getName());
            return CommandType.SUCCESS;
        }
        PlayerData playerData = optional.get();
        Collection<Data> collection = playerData.getDatas();
        if (collection.isEmpty()) {
            this.message((MenuPlugin)plugin, this.sender, Message.PLAYERS_DATA_KEYS_EMPTY, new Object[0]);
            return CommandType.SUCCESS;
        }
        ArrayList<String> keyList = new ArrayList<String>(collection.size());
        for (Data data : collection) {
            keyList.add(data.getKey());
        }
        String keys = this.toList(keyList, "\u00a78", "\u00a77");
        this.message((MenuPlugin)plugin, this.sender, Message.PLAYERS_DATA_KEYS_SUCCESS, "%keys%", keys, "%player%", player.getName());
        return CommandType.SUCCESS;
    }
}

