/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.command.commands.reload;

import fr.maxlego08.menu.ZMenuPlugin;
import fr.maxlego08.menu.api.Inventory;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuPlugin;
import fr.maxlego08.menu.api.utils.Message;
import fr.maxlego08.menu.command.VCommand;
import fr.maxlego08.menu.inventory.inventories.InventoryDefault;
import fr.maxlego08.menu.zcore.enums.Permission;
import fr.maxlego08.menu.zcore.utils.commands.CommandType;
import java.util.ArrayList;
import java.util.Optional;

public class CommandMenuReloadInventory
extends VCommand {
    public CommandMenuReloadInventory(ZMenuPlugin plugin) {
        super(plugin);
        this.addSubCommand("inventory");
        this.setPermission(Permission.ZMENU_RELOAD);
        this.addOptionalArg("menu", (a, b) -> {
            ArrayList<String> menus = new ArrayList<String>();
            for (Inventory inventory : plugin.getInventoryManager().getInventories()) {
                menus.add((inventory.getPlugin().getName() + ":" + inventory.getFileName()).toLowerCase());
            }
            return menus;
        });
    }

    @Override
    protected CommandType perform(ZMenuPlugin plugin) {
        String inventoryName = this.argAsString(0, null);
        InventoryManager inventoryManager = plugin.getInventoryManager();
        if (inventoryName != null) {
            String[] values;
            Optional<Inventory> optional = inventoryName.contains(":") ? ((values = inventoryName.split(":")).length == 2 ? inventoryManager.getInventory(values[0], values[1]) : inventoryManager.getInventory(inventoryName)) : inventoryManager.getInventory(inventoryName);
            if (optional.isEmpty()) {
                this.message((MenuPlugin)plugin, this.sender, Message.INVENTORY_OPEN_ERROR_INVENTORY, "%name%", inventoryName);
                return CommandType.DEFAULT;
            }
            Inventory inventory = optional.get();
            plugin.getVInventoryManager().close(v -> {
                InventoryDefault inventoryDefault = (InventoryDefault)v;
                return !inventoryDefault.isClose() && inventoryDefault.getMenuInventory().equals(inventory);
            });
            inventoryManager.reloadInventory(inventory);
            this.message((MenuPlugin)plugin, this.sender, Message.RELOAD_INVENTORY_FILE, "%name%", inventoryName);
            return CommandType.SUCCESS;
        }
        plugin.getVInventoryManager().close();
        inventoryManager.deleteInventories(plugin);
        inventoryManager.loadInventories();
        this.message((MenuPlugin)plugin, this.sender, Message.RELOAD_INVENTORY, "%inventories%", inventoryManager.getInventories(plugin).size());
        return CommandType.SUCCESS;
    }
}

