/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.config.processors;

import fr.maxlego08.menu.api.enums.DialogInputType;
import fr.maxlego08.menu.config.processors.ConfigFieldProcessor;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

public class ConfigFieldProcessorRegistry {
    private final Map<DialogInputType, ConfigFieldProcessor> processors = new EnumMap<DialogInputType, ConfigFieldProcessor>(DialogInputType.class);

    public void registerProcessor(DialogInputType inputType, ConfigFieldProcessor processor) {
        this.processors.put(inputType, processor);
    }

    public ConfigFieldProcessor getProcessor(DialogInputType inputType) {
        return this.processors.get((Object)inputType);
    }

    public Optional<ConfigFieldProcessor> getProcessorOptional(DialogInputType inputType) {
        return Optional.ofNullable(this.processors.get((Object)inputType));
    }

    public boolean hasProcessor(DialogInputType inputType) {
        return this.processors.containsKey((Object)inputType);
    }

    public void unregisterProcessor(DialogInputType inputType) {
        this.processors.remove((Object)inputType);
    }

    public void clear() {
        this.processors.clear();
    }
}

