/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.dupe;

import fr.maxlego08.menu.api.dupe.DupeItem;
import fr.maxlego08.menu.api.dupe.DupeManager;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;

public class DupeListener
implements Listener {
    private final DupeManager dupeManager;

    public DupeListener(DupeManager dupeManager) {
        this.dupeManager = dupeManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent event) {
        block4: {
            if (event.isCancelled()) {
                return;
            }
            try {
                ItemStack itemStack = event.getItem();
                if (itemStack != null && this.dupeManager.isDupeItem(itemStack)) {
                    event.setCancelled(true);
                    event.getPlayer().getInventory().setItem(event.getHand(), new ItemStack(Material.AIR));
                    this.sendInformation(new DupeItem(itemStack, event.getPlayer()));
                }
            }
            catch (Exception exception) {
                ItemStack itemStack = event.getPlayer().getItemInHand();
                if (itemStack == null || !this.dupeManager.isDupeItem(itemStack)) break block4;
                event.setCancelled(true);
                event.getPlayer().setItemInHand(new ItemStack(Material.AIR));
                this.sendInformation(new DupeItem(itemStack, event.getPlayer()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDrop(PlayerDropItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Item item = event.getItemDrop();
        ItemStack itemStack = item.getItemStack();
        if (this.dupeManager.isDupeItem(itemStack)) {
            item.remove();
            this.sendInformation(new DupeItem(itemStack, event.getPlayer()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDrop(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        try {
            ItemStack itemStack = event.getItemInHand();
            if (this.dupeManager.isDupeItem(itemStack)) {
                event.getPlayer().getInventory().setItem(event.getHand(), new ItemStack(Material.AIR));
                event.setCancelled(true);
                this.sendInformation(new DupeItem(itemStack, event.getPlayer()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDrop(PlayerPickupItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Item item = event.getItem();
        ItemStack itemStack = item.getItemStack();
        if (this.dupeManager.isDupeItem(itemStack)) {
            item.remove();
            event.setCancelled(true);
            this.sendInformation(new DupeItem(itemStack, event.getPlayer()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack != null && this.dupeManager.isDupeItem(itemStack)) {
            event.setCurrentItem(new ItemStack(Material.AIR));
            event.setCancelled(true);
            this.sendInformation(new DupeItem(itemStack, player));
        }
        if ((itemStack = event.getCursor()) != null && this.dupeManager.isDupeItem(itemStack)) {
            event.setCursor(new ItemStack(Material.AIR));
            event.setCancelled(true);
            this.sendInformation(new DupeItem(itemStack, player));
        }
    }

    private void sendInformation(DupeItem dupeItem) {
    }
}

