/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.enchantment;

import fr.maxlego08.menu.api.enchantment.Enchantments;
import fr.maxlego08.menu.api.enchantment.MenuEnchantment;
import fr.maxlego08.menu.enchantment.ZMenuEnchantment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.enchantments.Enchantment;

public class ZEnchantments
implements Enchantments {
    private final List<MenuEnchantment> essentialsEnchantments = new ArrayList<MenuEnchantment>();

    @Override
    public Optional<MenuEnchantment> getEnchantments(String enchantment) {
        for (MenuEnchantment menuEnchantment : this.essentialsEnchantments) {
            for (String alias : menuEnchantment.aliases()) {
                if (!alias.equalsIgnoreCase(enchantment)) continue;
                return Optional.of(menuEnchantment);
            }
        }
        return Optional.empty();
    }

    @Override
    public void register() {
        this.register(this.valueOf("DAMAGE_ALL", "SHARPNESS"), "DAMAGE_ALL", "SHARPNESS", "alldamage", "alldmg", "sharpness", "sharp", "dal");
        this.register(this.valueOf("DAMAGE_ARTHROPODS", "BANE_OF_ARTHROPODS"), "DAMAGE_ARTHROPODS", "BANE_OF_ARTHROPODS", "ardmg", "baneofarthropods", "baneofarthropod", "arthropod", "dar");
        this.register(this.valueOf("DAMAGE_UNDEAD", "SMITE"), "DAMAGE_UNDEAD", "undeaddamage", "smite", "du");
        this.register(this.valueOf("DIG_SPEED", "EFFICIENCY"), "DIG_SPEED", "EFFICIENCY", "digspeed", "efficiency", "minespeed", "cutspeed", "ds", "eff");
        this.register(this.valueOf("DURABILITY", "UNBREAKING"), "durability", "dura", "unbreaking", "d");
        this.register(Enchantment.THORNS, "thorns", "highcrit", "thorn", "highercrit", "t");
        this.register(Enchantment.FIRE_ASPECT, "FIRE_ASPECT", "fireaspect", "fire", "meleefire", "meleeflame", "fa");
        this.register(Enchantment.KNOCKBACK, "knockback", "kback", "kb", "k");
        this.register(this.valueOf("LOOT_BONUS_BLOCKS", "FORTUNE"), "LOOT_BONUS_BLOCKS", "FORTUNE", "blockslootbonus", "fortune", "fort", "lbb");
        this.register(this.valueOf("LOOT_BONUS_MOBS", "LOOTING"), "LOOT_BONUS_MOBS", "LOOTING", "mobslootbonus", "mobloot", "looting", "lbm");
        this.register(this.valueOf("OXYGEN", "RESPIRATION"), "OXYGEN", "RESPIRATION", "oxygen", "respiration", "breathing", "breath", "o");
        this.register(this.valueOf("PROTECTION_ENVIRONMENTAL", "PROTECTION"), "PROTECTION_ENVIRONMENTAL", "PROTECTION", "protection", "prot", "protect", "p");
        this.register(this.valueOf("PROTECTION_EXPLOSIONS", "BLAST_PROTECTION"), "PROTECTION_EXPLOSIONS", "BLAST_PROTECTION", "explosionsprotection", "explosionprotection", "expprot", "blastprotection", "bprotection", "bprotect", "blastprotect", "pe");
        this.register(this.valueOf("PROTECTION_FALL", "FEATHER_FALLING"), "PROTECTION_FALL", "FEATHER_FALLING", "fallprotection", "fallprot", "featherfall", "featherfalling", "pfa");
        this.register(this.valueOf("PROTECTION_FIRE", "FIRE_PROTECTION"), "PROTECTION_FIRE", "FIRE_PROTECTION", "fireprotection", "flameprotection", "fireprotect", "flameprotect", "fireprot", "flameprot", "pf");
        this.register(this.valueOf("PROTECTION_PROJECTILE", "PROJECTILE_PROTECTION"), "PROTECTION_PROJECTILE", "PROJECTILE_PROTECTION", "projectileprotection", "projprot", "pp");
        this.register(Enchantment.SILK_TOUCH, "SILK_TOUCH", "silktouch", "softtouch", "st");
        this.register(this.valueOf("WATER_WORKER", "AQUA_AFFINITY"), "WATER_WORKER", "AQUA_AFFINITY", "waterworker", "aquaaffinity", "watermine", "ww");
        this.register(this.valueOf("ARROW_FIRE", "FLAME"), "ARROW_FIRE", "FLAME", "firearrow", "flame", "flamearrow", "af");
        this.register(this.valueOf("ARROW_DAMAGE", "POWER"), "ARROW_DAMAGE", "POWER", "arrowdamage", "power", "arrowpower", "ad");
        this.register(this.valueOf("ARROW_KNOCKBACK", "PUNCH"), "ARROW_KNOCKBACK", "PUNCH", "arrowknockback", "arrowkb", "punch", "arrowpunch", "ak");
        this.register(this.valueOf("ARROW_INFINITE", "INFINITY"), "ARROW_INFINITE", "INFINITY", "infinitearrows", "infarrows", "infinity", "infinite", "unlimited", "unlimitedarrows", "ai");
        this.register(this.valueOf("LUCK", "LUCK_OF_THE_SEA"), "LUCK", "LUCK_OF_THE_SEA", "luck", "luckofsea", "luckofseas", "rodluck");
        this.register(Enchantment.getByName((String)"LURE"), "lure", "rodlure");
        this.register(Enchantment.getByName((String)"DEPTH_STRIDER"), "DEPTH_STRIDER", "depthstrider", "depth", "strider");
        this.register(Enchantment.getByName((String)"FROST_WALKER"), "FROST_WALKER", "frostwalker", "frost", "walker");
        this.register(Enchantment.getByName((String)"MENDING"), "mending");
        this.register(Enchantment.getByName((String)"BINDING_CURSE"), "BINDING_CURSE", "bindingcurse", "bindcurse", "binding", "bind");
        this.register(Enchantment.getByName((String)"VANISHING_CURSE"), "VANISHING_CURSE", "vanishingcurse", "vanishcurse", "vanishing", "vanish");
        this.register(Enchantment.getByName((String)"SWEEPING_EDGE"), "SWEEPING_EDGE", "sweepingedge", "sweepedge", "sweeping");
        this.register(Enchantment.getByName((String)"LOYALTY"), "loyalty", "loyal", "return");
        this.register(Enchantment.getByName((String)"IMPALING"), "impaling", "impale", "oceandamage", "oceandmg");
        this.register(Enchantment.getByName((String)"RIPTIDE"), "riptide", "rip", "tide", "launch");
        this.register(Enchantment.getByName((String)"CHANNELING"), "channelling", "chanelling", "channeling", "chaneling", "channel");
        this.register(Enchantment.getByName((String)"MULTISHOT"), "multishot", "tripleshot");
        this.register(Enchantment.getByName((String)"QUICK_CHARGE"), "QUICK_CHARGE", "quickcharge", "quickdraw", "fastcharge", "fastdraw");
        this.register(Enchantment.getByName((String)"PIERCING"), "piercing");
        this.register(Enchantment.getByName((String)"SOUL_SPEED"), "SOUL_SPEED", "soulspeed", "soilspeed", "sandspeed");
        this.register(Enchantment.getByName((String)"SWIFT_SNEAK"), "swiftsneak", "SWIFT_SNEAK");
        this.register(Enchantment.getByName((String)"BREACH"), "breach");
        this.register(Enchantment.getByName((String)"DENSITY"), "density");
        this.register(Enchantment.getByName((String)"WIND_BURST"), "WIND_BURST", "windburst", "wind", "burst");
    }

    private void register(Enchantment enchantment, String ... strings) {
        if (enchantment == null) {
            return;
        }
        try {
            this.essentialsEnchantments.add(new ZMenuEnchantment(enchantment, Arrays.asList(strings)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<String> getEnchantments() {
        ArrayList<String> aliases = new ArrayList<String>();
        for (MenuEnchantment menuEnchantment : this.essentialsEnchantments) {
            aliases.addAll(menuEnchantment.aliases());
        }
        return aliases;
    }

    private Enchantment valueOf(String ... names) {
        for (String name : names) {
            try {
                Enchantment value = (Enchantment)Enchantment.class.getDeclaredField(name).get(null);
                if (value == null) continue;
                return value;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }
}

