/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.menu.hooks.currencies;

import fr.maxlego08.menu.hooks.currencies.CurrencyProvider;
import fr.maxlego08.menu.hooks.currencies.Updater;
import fr.maxlego08.menu.hooks.currencies.providers.BeastTokenProvider;
import fr.maxlego08.menu.hooks.currencies.providers.CoinsEngineProvider;
import fr.maxlego08.menu.hooks.currencies.providers.EcoBitProvider;
import fr.maxlego08.menu.hooks.currencies.providers.ElementalGemsProvider;
import fr.maxlego08.menu.hooks.currencies.providers.ElementalTokensProvider;
import fr.maxlego08.menu.hooks.currencies.providers.ExperienceProvider;
import fr.maxlego08.menu.hooks.currencies.providers.ItemProvider;
import fr.maxlego08.menu.hooks.currencies.providers.LevelProvider;
import fr.maxlego08.menu.hooks.currencies.providers.PlayerPointsProvider;
import fr.maxlego08.menu.hooks.currencies.providers.RedisEconomyProvider;
import fr.maxlego08.menu.hooks.currencies.providers.RoyaleEconomyProvider;
import fr.maxlego08.menu.hooks.currencies.providers.VaultProvider;
import fr.maxlego08.menu.hooks.currencies.providers.VotingProvider;
import fr.maxlego08.menu.hooks.currencies.providers.ZEssentialsProvider;
import fr.maxlego08.menu.hooks.currencies.providers.ZMenuItemProvider;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public enum Currencies {
    BEASTTOKENS("BeastTokens", BeastTokenProvider.class),
    VAULT("Vault", VaultProvider.class),
    PLAYERPOINTS("PlayerPoints", PlayerPointsProvider.class),
    ELEMENTALTOKENS("ElementalTokens", ElementalTokensProvider.class),
    ELEMENTALGEMS("ElementalGems", ElementalGemsProvider.class),
    ITEM("self", ItemProvider.class, false),
    LEVEL("self", LevelProvider.class),
    EXPERIENCE("self", ExperienceProvider.class),
    ZESSENTIALS("zEssentials", ZEssentialsProvider.class, true, true),
    ZMENUITEMS("zMenu", ZMenuItemProvider.class, false),
    ECOBITS("EcoBits", EcoBitProvider.class, true, true),
    COINSENGINE("CoinsEngine", CoinsEngineProvider.class, true, true),
    VOTINGPLUGIN("VotingPlugin", VotingProvider.class),
    REDISECONOMY("RedisEconomy", RedisEconomyProvider.class, true, true),
    ROYALEECONOMY("RoyaleEconomy", RoyaleEconomyProvider.class, true, true);

    private final String name;
    private final Class<? extends CurrencyProvider> providerClass;
    private final boolean autoCreate;
    private final boolean currencySpecific;
    private final Map<String, CurrencyProvider> providers;

    private Currencies(String name, Class<? extends CurrencyProvider> providerClass) {
        this(name, providerClass, true, false);
    }

    private Currencies(String name, Class<? extends CurrencyProvider> providerClass, boolean autoCreate) {
        this(name, providerClass, autoCreate, false);
    }

    private Currencies(String name, Class<? extends CurrencyProvider> providerClass, boolean autoCreate, boolean currencySpecific) {
        this.name = name;
        this.providerClass = providerClass;
        this.autoCreate = autoCreate;
        this.providers = new HashMap<String, CurrencyProvider>();
        this.currencySpecific = currencySpecific;
    }

    public void registerProvider(String name, Object ... objects) {
        if (this.providers.containsKey(name)) {
            return;
        }
        CurrencyProvider provider = this.createProvider(objects);
        this.providers.put(name, provider);
    }

    public CurrencyProvider createProvider(Object ... objects) {
        CurrencyProvider provider;
        try {
            if (objects.length == 0) {
                provider = this.providerClass.newInstance();
            } else {
                Constructor<?> constructor = this.providerClass.getConstructors()[0];
                provider = (CurrencyProvider)constructor.newInstance(objects);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create the provider for the plugin " + this.name + ".", e);
        }
        return provider;
    }

    private boolean isDisable() {
        if (this.name.equalsIgnoreCase("self")) {
            return false;
        }
        return !Bukkit.getPluginManager().isPluginEnabled(this.name);
    }

    public void deposit(OfflinePlayer player, BigDecimal amount, String reason) {
        this.deposit(player, amount, "default", reason);
    }

    public void withdraw(OfflinePlayer player, BigDecimal amount, String reason) {
        this.withdraw(player, amount, "default", reason);
    }

    public void deposit(OfflinePlayer player, BigDecimal amount) {
        this.deposit(player, amount, "default", "No reason");
    }

    public void withdraw(OfflinePlayer player, BigDecimal amount) {
        this.withdraw(player, amount, "default", "No reason");
    }

    public BigDecimal getBalance(OfflinePlayer player) {
        return this.getBalance(player, "default");
    }

    public void deposit(OfflinePlayer player, BigDecimal amount, String currencyName, String reason) {
        this.canBeUse(currencyName);
        this.providers.get(currencyName).deposit(player, amount, reason);
    }

    public void withdraw(OfflinePlayer player, BigDecimal amount, String currencyName, String reason) {
        this.canBeUse(currencyName);
        this.providers.get(currencyName).withdraw(player, amount, reason);
    }

    public BigDecimal getBalance(OfflinePlayer player, String currencyName) {
        this.canBeUse(currencyName);
        return this.providers.get(currencyName).getBalance(player);
    }

    private void canBeUse(String currencyName) {
        if (this.isDisable()) {
            throw new IllegalStateException("The plugin " + this.name + " is not enable.");
        }
        if (this.autoCreate) {
            if (this.currencySpecific) {
                this.registerProvider(currencyName, currencyName);
            } else {
                this.registerProvider(currencyName, new Object[0]);
            }
        } else if (!this.providers.containsKey(currencyName)) {
            String currency = this.name.equalsIgnoreCase("default") ? "" : " and for the currency " + this.name;
            throw new IllegalStateException("You must create the provider for the plugin " + this.name + currency + " before using it.");
        }
    }

    static {
        Updater.checkUpdates();
    }
}

